/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeEntry;
import forestry.core.utils.Vect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockLog;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockUtil {
    public static ArrayList getBlockItemStack(World world, Vect posBlock) {
        Block block = Block.field_71973_m[world.func_72798_a(posBlock.x, posBlock.y, posBlock.z)];
        if (block == null) {
            return null;
        }
        int meta = world.func_72805_g(posBlock.x, posBlock.y, posBlock.z);
        return block.getBlockDropped(world, posBlock.x, posBlock.y, posBlock.z, meta, 0);
    }

    public static IInventory[] getAdjacentInventories(World world, Vect blockPos, ForgeDirection from) {
        ArrayList<IInventory> inventories = new ArrayList<IInventory>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity entity;
            if (from != ForgeDirection.UNKNOWN && from != dir.getOpposite() || (entity = world.func_72796_p(blockPos.x + dir.offsetX, blockPos.y + dir.offsetY, blockPos.z + dir.offsetZ)) == null || !(entity instanceof IInventory) || entity instanceof TileEntityHopper || entity instanceof IPowerReceptor) continue;
            inventories.add((IInventory)entity);
        }
        return inventories.toArray(new IInventory[inventories.size()]);
    }

    public static ForgeDirection[] getPipeDirections(World world, Vect blockPos, ForgeDirection from) {
        LinkedList<ForgeDirection> possiblePipes = new LinkedList<ForgeDirection>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (from != ForgeDirection.UNKNOWN && from != dir.getOpposite()) continue;
            Position posPipe = new Position(blockPos.x, blockPos.y, blockPos.z, dir);
            posPipe.moveForwards(1.0);
            TileEntity pipeEntry = world.func_72796_p((int)posPipe.x, (int)posPipe.y, (int)posPipe.z);
            if (!(pipeEntry instanceof IPipeEntry) || !((IPipeEntry)pipeEntry).acceptItems()) continue;
            if (from != ForgeDirection.UNKNOWN && pipeEntry instanceof IPipeConnection) {
                if (!((IPipeConnection)pipeEntry).isPipeConnected(from)) continue;
                possiblePipes.add(dir);
                continue;
            }
            possiblePipes.add(dir);
        }
        return possiblePipes.toArray(new ForgeDirection[0]);
    }

    public static ForgeDirection[] filterPipeDirections(ForgeDirection[] all, ForgeDirection[] exclude) {
        LinkedList<ForgeDirection> filtered = new LinkedList<ForgeDirection>();
        ArrayList<ForgeDirection> excludeList = new ArrayList<ForgeDirection>(Arrays.asList(exclude));
        for (int i = 0; i < all.length; ++i) {
            if (excludeList.contains(all[i])) continue;
            filtered.add(all[i]);
        }
        return filtered.toArray(new ForgeDirection[filtered.size()]);
    }

    public static void putFromStackIntoPipe(TileEntity tile, ForgeDirection[] pipes, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.field_77994_a <= 0) {
            return;
        }
        if (pipes.length <= 0) {
            return;
        }
        int choice = tile.field_70331_k.field_73012_v.nextInt(pipes.length);
        Position itemPos = new Position(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n, pipes[choice]);
        itemPos.x += 0.5;
        itemPos.y += 0.25;
        itemPos.z += 0.5;
        itemPos.moveForwards(0.5);
        Position pipePos = new Position(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n, pipes[choice]);
        pipePos.moveForwards(1.0);
        IPipeEntry pipe = (IPipeEntry)tile.field_70331_k.func_72796_p((int)pipePos.x, (int)pipePos.y, (int)pipePos.z);
        ItemStack payload = stack.func_77979_a(1);
        pipe.entityEntering(payload, itemPos.orientation);
    }

    public static boolean isPoweredTile(TileEntity tile) {
        if (tile == null) {
            return false;
        }
        if (!(tile instanceof IPowerReceptor)) {
            return false;
        }
        IPowerReceptor receptor = (IPowerReceptor)tile;
        return receptor.getPowerProvider() != null;
    }

    public static boolean tryPlantPot(World world, int x, int y, int z, int blockid) {
        int direction = BlockUtil.getDirectionalMetadata(world, x, y, z);
        if (direction < 0) {
            return false;
        }
        world.func_72832_d(x, y, z, blockid, direction, 2);
        return true;
    }

    public static int getDirectionalMetadata(World world, int x, int y, int z) {
        for (int i = 0; i < 4; ++i) {
            if (!BlockUtil.isValidPot(world, x, y, z, i)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValidPot(World world, int x, int y, int z, int notchDirection) {
        int blockid = world.func_72798_a(x += Direction.field_71583_a[notchDirection], y, z += Direction.field_71581_b[notchDirection]);
        if (blockid == Block.field_71951_J.field_71990_ca) {
            return BlockLog.func_72141_e((int)world.func_72805_g(x, y, z)) == 3;
        }
        if (Block.field_71973_m[blockid] != null) {
            return Block.field_71973_m[blockid].isWood(world, x, y, z);
        }
        return false;
    }

    public static int getMaturityPod(int metadata) {
        return BlockCocoa.func_72219_c((int)metadata);
    }
}

