/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IIconProvider;
import forestry.api.core.ITextureManager;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureStitched;
import net.minecraft.util.Icon;

@SideOnly(value=Side.CLIENT)
public class TextureManager
implements ITextureManager {
    private static TextureManager instance;
    String[] defaultIconNames = new String[]{"habitats/desert", "habitats/end", "habitats/forest", "habitats/hills", "habitats/jungle", "habitats/mushroom", "habitats/nether", "habitats/ocean", "habitats/plains", "habitats/snow", "habitats/swamp", "habitats/taiga", "misc/access.private", "misc/access.viewable", "misc/access.shared", "misc/empty", "misc/energy", "misc/hint", "misc/liquid", "analyzer/anything", "analyzer/bee", "analyzer/cave", "analyzer/closed", "analyzer/drone", "analyzer/flyer", "analyzer/item", "analyzer/nocturnal", "analyzer/princess", "analyzer/pure_breed", "analyzer/pure_cave", "analyzer/pure_flyer", "analyzer/pure_nocturnal", "analyzer/queen", "analyzer/natural", "particles/ember", "particles/flame", "particles/poison", "particles/snow", "particles/swarm_bee", "errors/errored", "slots/blocked", "slots/blocked_2", "slots/liquid", "slots/container", "slots/locked", "mail/carrier.player", "mail/carrier.trader"};
    HashMap defaultIcons = new HashMap();
    public TextureMap terrainMap;
    public TextureMap itemMap;
    Icon[] textures = new Icon[2048];
    ArrayList iconProvider = new ArrayList();

    public static TextureManager getInstance() {
        if (instance == null) {
            instance = new TextureManager(Proxies.common.getClientInstance().field_71446_o.field_94154_l, Proxies.common.getClientInstance().field_71446_o.field_94155_m);
            ForestryAPI.textureManager = instance;
        }
        return instance;
    }

    public void initDefaultIcons() {
        for (String str : this.defaultIconNames) {
            this.defaultIcons.put(str, TextureManager.getInstance().registerItemTex(str));
        }
    }

    @Override
    public Icon getDefault(String ident) {
        if (this.defaultIcons.containsKey(ident)) {
            return (Icon)this.defaultIcons.get(ident);
        }
        return null;
    }

    public TextureManager(TextureMap textureMap, TextureMap itemMap) {
        this.terrainMap = textureMap;
        this.itemMap = itemMap;
    }

    public boolean setTerrainTex(String name, TextureStitched entry) {
        return this.terrainMap.setTextureEntry("forestry:" + name, entry);
    }

    public Icon registerTerrainTex(String identifier) {
        return this.terrainMap.func_94245_a("forestry:" + identifier);
    }

    public Icon registerItemTex(String identifier) {
        return this.itemMap.func_94245_a("forestry:" + identifier);
    }

    public Icon registerTerrainTexUID(short uid, String identifier) {
        return this.setTexUID(uid, this.registerTerrainTex(identifier));
    }

    public Icon registerItemTexUID(short uid, String identifier) {
        return this.setTexUID(uid, this.registerItemTex(identifier));
    }

    public Icon setTexUID(short uid, Icon texture) {
        this.textures[uid] = texture;
        return texture;
    }

    @Override
    public void registerIconProvider(IIconProvider provider) {
        this.iconProvider.add(provider);
    }

    @Override
    public Icon getIcon(short texUID) {
        if (texUID < this.textures.length) {
            return this.textures[texUID];
        }
        for (IIconProvider provider : this.iconProvider) {
            Icon retr = provider.getIcon(texUID);
            if (retr == null) continue;
            return retr;
        }
        return null;
    }
}

