/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.interfaces.IEnergyConsumer;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;

public class PowerLedger
extends Ledger {
    IEnergyConsumer tile;

    public PowerLedger(LedgerManager manager, IEnergyConsumer tile) {
        super(manager);
        this.tile = tile;
        this.maxHeight = 94;
        this.overlayColor = manager.gui.fontColor.get("ledger.power.background");
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawIcon(TextureManager.getInstance().getDefault("misc/energy"), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.manager.minecraft.field_71466_p.func_78261_a(StringUtil.localize("gui.energy"), x + 22, y + 8, this.manager.gui.fontColor.get("ledger.power.header"));
        this.manager.minecraft.field_71466_p.func_78261_a(StringUtil.localize("gui.stored") + ":", x + 22, y + 20, this.manager.gui.fontColor.get("ledger.power.subheader"));
        this.manager.minecraft.field_71466_p.func_78276_b(this.tile.getEnergyStored() + " MJ", x + 22, y + 32, this.manager.gui.fontColor.get("ledger.power.text"));
        this.manager.minecraft.field_71466_p.func_78261_a(StringUtil.localize("gui.maxenergy") + ":", x + 22, y + 44, this.manager.gui.fontColor.get("ledger.power.subheader"));
        this.manager.minecraft.field_71466_p.func_78276_b(this.tile.getMaxEnergyStored() + " MJ", x + 22, y + 56, this.manager.gui.fontColor.get("ledger.power.text"));
        this.manager.minecraft.field_71466_p.func_78261_a(StringUtil.localize("gui.maxenergyreceive") + ":", x + 22, y + 68, this.manager.gui.fontColor.get("ledger.power.subheader"));
        this.manager.minecraft.field_71466_p.func_78276_b(this.tile.getMaxEnergyReceived() + " MJ", x + 22, y + 80, this.manager.gui.fontColor.get("ledger.power.text"));
    }

    @Override
    public String getTooltip() {
        return this.tile.getEnergyStored() + " MJ";
    }
}

