/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import forestry.core.GameMode;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.IRenderableMachine;
import forestry.core.network.ClassMap;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.TankSlot;
import forestry.plugins.PluginBuildCraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidContainerData;

public abstract class TilePowered
extends TileBase
implements IPowerReceptor,
IRenderableMachine {
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    @Override
    public PacketPayload getPacketPayload() {
        if (!ClassMap.classMappers.containsKey(this.getClass())) {
            ClassMap.classMappers.put(this.getClass(), new ClassMap(this.getClass()));
        }
        ClassMap classmap = (ClassMap)ClassMap.classMappers.get(this.getClass());
        PacketPayload payload = new PacketPayload(classmap.intSize, classmap.floatSize, classmap.stringSize);
        try {
            classmap.setData(this, payload.intPayload, payload.floatPayload, payload.stringPayload, new IndexInPayload(0, 0, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        if (payload.isEmpty()) {
            return;
        }
        if (!ClassMap.classMappers.containsKey(this.getClass())) {
            ClassMap.classMappers.put(this.getClass(), new ClassMap(this.getClass()));
        }
        ClassMap classmap = (ClassMap)ClassMap.classMappers.get(this.getClass());
        try {
            classmap.fromData(this, payload.intPayload, payload.floatPayload, payload.stringPayload, new IndexInPayload(0, 0, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public TilePowered() {
        this.configurePowerProvider(this.powerProvider);
        this.adjustPowerProvider(this.powerProvider);
    }

    protected void configurePowerProvider(IPowerProvider provider) {
        provider.configure(1000, 5, 40, 75, 500);
    }

    private void adjustPowerProvider(IPowerProvider provider) {
        provider.configure(provider.getLatency(), provider.getMinEnergyReceived(), Math.round((float)provider.getMaxEnergyReceived() * GameMode.getGameMode().getFloatSetting("energy.demand.modifier")), Math.round((float)provider.getActivationEnergy() * GameMode.getGameMode().getFloatSetting("energy.demand.modifier")), Math.round((float)provider.getMaxEnergyStored() * GameMode.getGameMode().getFloatSetting("energy.demand.modifier")));
    }

    public abstract boolean isWorking();

    public boolean hasResourcesMin(float percentage) {
        return false;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public boolean hasWork() {
        return false;
    }

    @Override
    public void doWork() {
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            return;
        }
        if (this.field_70331_k.func_72820_D() % 5L * 10L != 0L) {
            return;
        }
        PluginBuildCraft.instance.invokeUseEnergyMethod(this.powerProvider, this.powerProvider.getActivationEnergy(), this.powerProvider.getActivationEnergy(), false);
        if (!this.workCycle()) {
            return;
        }
        PluginBuildCraft.instance.invokeUseEnergyMethod(this.powerProvider, this.powerProvider.getActivationEnergy(), this.powerProvider.getActivationEnergy(), true);
    }

    public abstract boolean workCycle();

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public int powerRequest(ForgeDirection direction) {
        float needed = (float)this.powerProvider.getMaxEnergyStored() - this.powerProvider.getEnergyStored();
        return (int)Math.ceil(Math.min((float)this.powerProvider.getMaxEnergyReceived(), needed));
    }

    protected ItemStack bottleIntoContainer(ItemStack canStack, ItemStack outputStack, LiquidContainerData container, TankSlot tank) {
        if (tank.quantity < container.stillLiquid.amount) {
            return outputStack;
        }
        if (canStack.field_77994_a <= 0) {
            return outputStack;
        }
        if (outputStack != null && !outputStack.func_77969_a(container.filled)) {
            return outputStack;
        }
        if (outputStack != null && outputStack.field_77994_a >= outputStack.func_77976_d()) {
            return outputStack;
        }
        tank.quantity -= container.stillLiquid.amount;
        --canStack.field_77994_a;
        if (outputStack == null) {
            outputStack = container.filled.func_77946_l();
        } else {
            ++outputStack.field_77994_a;
        }
        return outputStack;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return EnumTankLevel.EMPTY;
    }
}

