/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.INBTTagable;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NaturalistGame
implements INBTTagable {
    public static final int BOUNTY_MAX = 16;
    private Random rand = new Random();
    private GameToken[] gameTokens;
    private long lastUpdate;
    private boolean isEnded;
    private int bountyLevel;

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("isEnded", this.isEnded);
        nbttagcompound.func_74768_a("bountyLevel", this.bountyLevel);
        nbttagcompound.func_74772_a("lastUpdate", this.lastUpdate);
        if (this.gameTokens != null) {
            nbttagcompound.func_74768_a("TokenCount", this.gameTokens.length);
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.gameTokens.length; ++i) {
                if (this.gameTokens[i] == null) continue;
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.func_74774_a("Slot", (byte)i);
                this.gameTokens[i].writeToNBT(nbttagcompound2);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
            }
            nbttagcompound.func_74782_a("GameTokens", (NBTBase)nbttaglist);
        } else {
            nbttagcompound.func_74768_a("TokenCount", 0);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.isEnded = nbttagcompound.func_74767_n("isEnded");
        this.bountyLevel = nbttagcompound.func_74762_e("bountyLevel");
        this.lastUpdate = nbttagcompound.func_74763_f("lastUpdate");
        int tokenCount = nbttagcompound.func_74762_e("TokenCount");
        if (tokenCount > 0) {
            this.gameTokens = new GameToken[tokenCount];
            NBTTagList nbttaglist = nbttagcompound.func_74761_m("GameTokens");
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist.func_74743_b(j);
                byte index = nbttagcompound2.func_74771_c("Slot");
                this.gameTokens[index] = new GameToken(nbttagcompound2);
            }
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void initialize(ItemStack specimen) {
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(specimen);
        if (individual == null) {
            return;
        }
        int boardSize = individual.getGenome().getPrimary().getComplexity() + individual.getGenome().getSecondary().getComplexity();
        if (boardSize % 2 != 0) {
            boardSize = Math.round((float)boardSize / 2.0f) * 2;
        }
        boardSize = boardSize <= 22 ? (boardSize >= 6 ? boardSize : 6) : 22;
        this.isEnded = false;
        this.bountyLevel = 16;
        this.gameTokens = new GameToken[boardSize];
        ISpeciesRoot root = individual.getGenome().getPrimary().getRoot();
        ArrayList<ItemStack> pairs = new ArrayList<ItemStack>();
        for (int i = 0; i < boardSize / 2; ++i) {
            IIndividual token = root.templateAsIndividual(root.getRandomTemplate(this.rand));
            pairs.add(root.getMemberStack(token, 0));
        }
        boolean first = true;
        for (ItemStack pair : pairs) {
            if (first) {
                this.gameTokens[0] = new GameToken(pair.func_77946_l());
                first = false;
            } else {
                this.gameTokens[this.getFreeTokenIndex()] = new GameToken(pair.func_77946_l());
            }
            this.gameTokens[this.getFreeTokenIndex()] = new GameToken(pair.func_77946_l());
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    private int getFreeTokenIndex() {
        int probe;
        while (this.gameTokens[probe = this.rand.nextInt(this.gameTokens.length)] != null) {
        }
        return probe;
    }

    private int countUnrevealedTokens() {
        int count = 0;
        for (GameToken token : this.gameTokens) {
            if (token.isRevealed) continue;
            ++count;
        }
        return count;
    }

    private int[] getUnrevealedTokens(int count) {
        ArrayList<Integer> existing = new ArrayList<Integer>();
        int remaining = this.countUnrevealedTokens();
        int[] unrevealed = new int[count < remaining ? count : remaining];
        for (int i = 0; i < unrevealed.length; ++i) {
            int found = -1;
            while (found < 0) {
                int probe = this.rand.nextInt(this.gameTokens.length);
                if (this.gameTokens[probe].isRevealed) continue;
                boolean taken = false;
                Iterator i$ = existing.iterator();
                while (i$.hasNext()) {
                    int exist = (Integer)i$.next();
                    if (exist != probe) continue;
                    taken = true;
                    break;
                }
                if (taken) continue;
                existing.add(probe);
                found = probe;
            }
            unrevealed[i] = found;
        }
        return unrevealed;
    }

    public void probe(ItemStack specimen, IInventory inventory, int startSlot, int slotCount, boolean doShow) {
        if (this.gameTokens == null) {
            return;
        }
        if (this.isEnded) {
            return;
        }
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(specimen);
        if (individual == null) {
            return;
        }
        this.hideProbedTokens();
        if (this.bountyLevel > 1) {
            --this.bountyLevel;
        }
        int[] tokenIndices = this.getUnrevealedTokens(this.getSampleSize() <= slotCount ? this.getSampleSize() : slotCount);
        int processedTokens = 0;
        for (int i = 0; i < slotCount; ++i) {
            if (inventory.func_70301_a(startSlot + i) == null || inventory.func_70301_a((int)(startSlot + i)).field_77994_a <= 0) continue;
            ItemStack taken = inventory.func_70298_a(startSlot + i, 1);
            if (this.rand.nextFloat() >= individual.getGenome().getPrimary().getResearchSuitability(taken)) continue;
            if (doShow) {
                this.gameTokens[tokenIndices[processedTokens]].isProbed = true;
                this.gameTokens[tokenIndices[processedTokens]].isRevealed = true;
            }
            if (++processedTokens >= tokenIndices.length) break;
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void choose(int tokenIndex) {
        if (this.isEnded) {
            return;
        }
        if (tokenIndex > this.gameTokens.length) {
            return;
        }
        if (this.gameTokens[tokenIndex].isRevealed && !this.gameTokens[tokenIndex].isProbed) {
            return;
        }
        this.hideProbedTokens();
        Collection singles = this.getRevealedSingles(this.gameTokens[tokenIndex]);
        if (singles.size() > 0) {
            boolean matched = false;
            for (GameToken single : singles) {
                if (!single.matches(this.gameTokens[tokenIndex])) continue;
                matched = true;
                break;
            }
            if (!matched) {
                this.gameTokens[tokenIndex].isFailed = true;
            }
        }
        this.gameTokens[tokenIndex].isRevealed = true;
        this.checkGameEnd();
        this.lastUpdate = System.currentTimeMillis();
    }

    public void reset() {
        this.gameTokens = null;
        this.lastUpdate = System.currentTimeMillis();
    }

    public boolean isInited() {
        return this.gameTokens != null;
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public int getBountyLevel() {
        return this.bountyLevel;
    }

    public boolean isWon() {
        if (!this.isEnded) {
            return false;
        }
        return !this.isLost();
    }

    private void checkGameEnd() {
        if (this.isLost()) {
            this.isEnded = true;
        }
        if (this.isRevealed()) {
            this.isEnded = true;
        }
    }

    private boolean isRevealed() {
        for (GameToken token : this.gameTokens) {
            if (token.isRevealed) continue;
            return false;
        }
        return true;
    }

    private boolean isLost() {
        for (GameToken token : this.gameTokens) {
            if (!token.isFailed) continue;
            return true;
        }
        return false;
    }

    private void hideProbedTokens() {
        for (GameToken token : this.gameTokens) {
            if (!token.isProbed) continue;
            token.isRevealed = false;
            token.isProbed = false;
        }
    }

    private Collection getRevealedSingles(GameToken exclude) {
        ArrayList<GameToken> singles = new ArrayList<GameToken>();
        for (GameToken token : this.gameTokens) {
            if (!token.isRevealed || token == exclude) continue;
            GameToken matching = null;
            for (GameToken single : singles) {
                if (!single.matches(token)) continue;
                matching = single;
                break;
            }
            if (matching == null) {
                singles.add(token);
                continue;
            }
            singles.remove(matching);
        }
        return singles;
    }

    public int getBoardSize() {
        return this.gameTokens != null ? this.gameTokens.length : 0;
    }

    public int getSampleSize() {
        if (this.gameTokens == null) {
            return 0;
        }
        int samples = this.gameTokens.length / 3;
        return samples >= 2 ? samples : 2;
    }

    public GameToken getToken(int index) {
        return this.gameTokens != null ? (index < this.gameTokens.length ? this.gameTokens[index] : null) : null;
    }

    public void setToken(int index, NBTTagCompound nbttagcompound) {
        if (this.gameTokens == null) {
            this.gameTokens = new GameToken[24];
        }
        this.gameTokens[index] = new GameToken(nbttagcompound);
    }

    public static class GameToken
    implements INBTTagable {
        private static final String[] OVERLAY_NONE = new String[0];
        private static final String[] OVERLAY_FAILED = new String[]{"errors/errored"};
        public ItemStack tokenStack;
        protected boolean isFailed = false;
        protected boolean isProbed = false;
        protected boolean isRevealed = false;

        public GameToken(ItemStack tokenStack) {
            this.tokenStack = tokenStack;
        }

        public GameToken(NBTTagCompound nbttagcompound) {
            this.readFromNBT(nbttagcompound);
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            this.isFailed = nbttagcompound.func_74767_n("isFailed");
            this.isProbed = nbttagcompound.func_74767_n("isProbed");
            this.isRevealed = nbttagcompound.func_74767_n("isRevealed");
            if (nbttagcompound.func_74764_b("tokenStack")) {
                this.tokenStack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("tokenStack"));
            }
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            nbttagcompound.func_74757_a("isFailed", this.isFailed);
            nbttagcompound.func_74757_a("isProbed", this.isProbed);
            nbttagcompound.func_74757_a("isRevealed", this.isRevealed);
            if (this.tokenStack != null) {
                NBTTagCompound stackcompound = new NBTTagCompound();
                this.tokenStack.func_77955_b(stackcompound);
                nbttagcompound.func_74782_a("tokenStack", (NBTBase)stackcompound);
            }
        }

        public boolean isVisible() {
            return this.isRevealed;
        }

        public int getTokenColour() {
            if (this.tokenStack == null || !this.isVisible()) {
                return 0xFFFFFF;
            }
            if (this.isProbed) {
                return Utils.multiplyRGBComponents(AlleleManager.alleleRegistry.getIndividual(this.tokenStack).getGenome().getPrimary().getIconColour(0), 0.7f);
            }
            return AlleleManager.alleleRegistry.getIndividual(this.tokenStack).getGenome().getPrimary().getIconColour(0);
        }

        public String getTooltip() {
            return this.tokenStack != null ? this.tokenStack.func_82833_r() : StringUtil.localize("gui.unknown");
        }

        public String[] getOverlayIcons() {
            return this.isFailed ? OVERLAY_FAILED : OVERLAY_NONE;
        }

        public boolean matches(GameToken other) {
            return this.tokenStack.func_77969_a(other.tokenStack) && ItemStack.func_77970_a((ItemStack)this.tokenStack, (ItemStack)other.tokenStack);
        }
    }
}

