/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.core.gadgets.TilePowered;
import forestry.core.network.EntityNetData;

public abstract class Mill
extends TilePowered {
    @EntityNetData
    public int charge = 0;
    @EntityNetData
    public float speed = 0.01f;
    @EntityNetData
    public int stage = 0;
    public float progress;

    @Override
    public void updateClientSide() {
        this.update(false);
    }

    @Override
    public void updateServerSide() {
        this.update(true);
    }

    private void update(boolean isSimulating) {
        if (this.charge <= 0) {
            if (this.stage > 0) {
                this.progress += this.speed;
            }
            if ((double)this.progress > 0.5) {
                this.stage = 2;
            }
            if (this.progress > 1.0f) {
                this.progress = 0.0f;
                this.stage = 0;
            }
            return;
        }
        this.progress += this.speed;
        if (this.stage <= 0) {
            this.stage = 1;
        }
        if ((double)this.progress > 0.5 && this.stage == 1) {
            this.stage = 2;
            if (this.charge < 7 && isSimulating) {
                ++this.charge;
                this.sendNetworkUpdate();
            }
        }
        if (this.progress > 1.0f) {
            this.progress = 0.0f;
            this.stage = 0;
            if (this.charge >= 7) {
                this.activate();
            }
        }
    }

    protected abstract void activate();

    @Override
    public boolean isWorking() {
        return this.charge != 0;
    }
}

