/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.core.GuiHandlerBase;
import forestry.core.circuits.ContainerSolderingIron;
import forestry.core.circuits.GuiSolderingIron;
import forestry.core.circuits.ItemSolderingIron;
import forestry.core.gadgets.TileAnalyzer;
import forestry.core.gadgets.TileEscritoire;
import forestry.core.gui.ContainerAnalyzer;
import forestry.core.gui.ContainerEscritoire;
import forestry.core.gui.GuiAnalyzer;
import forestry.core.gui.GuiEscritoire;
import forestry.core.network.GuiId;
import forestry.plugins.PluginManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class GuiHandler
extends GuiHandlerBase {
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id < GuiId.values().length) {
            switch (GuiId.values()[id]) {
                case AnalyzerGUI: {
                    return new GuiAnalyzer(player.field_71071_by, (TileAnalyzer)this.getTileForestry(world, x, y, z));
                }
                case NaturalistBenchGUI: {
                    return new GuiEscritoire(player, (TileEscritoire)this.getTileForestry(world, x, y, z));
                }
                case SolderingIronGUI: {
                    return new GuiSolderingIron(player.field_71071_by, new ItemSolderingIron.SolderingInventory());
                }
            }
            for (IGuiHandler handler : PluginManager.guiHandlers) {
                Object element = handler.getClientGuiElement(id, player, world, x, y, z);
                if (element == null) continue;
                return element;
            }
            return null;
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id < GuiId.values().length) {
            switch (GuiId.values()[id]) {
                case AnalyzerGUI: {
                    return new ContainerAnalyzer(player.field_71071_by, (TileAnalyzer)this.getTileForestry(world, x, y, z));
                }
                case NaturalistBenchGUI: {
                    return new ContainerEscritoire(player, (TileEscritoire)this.getTileForestry(world, x, y, z));
                }
                case SolderingIronGUI: {
                    return new ContainerSolderingIron(player.field_71071_by, new ItemSolderingIron.SolderingInventory());
                }
            }
            for (IGuiHandler handler : PluginManager.guiHandlers) {
                Object element = handler.getServerGuiElement(id, player, world, x, y, z);
                if (element == null) continue;
                return element;
            }
            return null;
        }
        return null;
    }
}

