/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.apiculture.gui.ContainerHabitatLocator;
import forestry.apiculture.items.ItemBiomefinder;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.Widget;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.Icon;
import net.minecraft.world.biome.BiomeGenBase;
import org.lwjgl.opengl.GL11;

public class GuiHabitatLocator
extends GuiForestry {
    private HabitatSlot[] habitatSlots = new HabitatSlot[]{new HabitatSlot(0, "Ocean"), new HabitatSlot(1, "Plains"), new HabitatSlot(2, "Desert"), new HabitatSlot(3, "Forest"), new HabitatSlot(4, "Jungle"), new HabitatSlot(5, "Taiga"), new HabitatSlot(6, "Hills"), new HabitatSlot(7, "Swampland"), new HabitatSlot(8, "Snow"), new HabitatSlot(9, "Mushroom"), new HabitatSlot(10, "Hell"), new HabitatSlot(11, "End")};
    private HashMap biomeToHabitat = new HashMap();
    private int startX;
    private int startY;

    public GuiHabitatLocator(InventoryPlayer inventory, ItemBiomefinder.BiomefinderInventory item) {
        super("/gfx/forestry/gui/biomefinder.png", new ContainerHabitatLocator(inventory, item), item, 1, item.func_70302_i_());
        this.xSize = 176;
        this.ySize = 184;
        for (HabitatSlot slot : this.habitatSlots) {
            int y;
            int x;
            if (slot.slot > 5) {
                x = 18 + (slot.slot - 6) * 20;
                y = 50;
            } else {
                x = 18 + slot.slot * 20;
                y = 32;
            }
            slot.setPosition(x, y);
            this.widgetManager.add(slot);
        }
        this.biomeToHabitat.put(BiomeGenBase.field_76771_b.field_76756_M, this.habitatSlots[0]);
        this.biomeToHabitat.put(BiomeGenBase.field_76787_r.field_76756_M, this.habitatSlots[0]);
        this.biomeToHabitat.put(BiomeGenBase.field_76772_c.field_76756_M, this.habitatSlots[1]);
        this.biomeToHabitat.put(BiomeGenBase.field_76769_d.field_76756_M, this.habitatSlots[2]);
        this.biomeToHabitat.put(BiomeGenBase.field_76767_f.field_76756_M, this.habitatSlots[3]);
        this.biomeToHabitat.put(BiomeGenBase.field_76785_t.field_76756_M, this.habitatSlots[3]);
        this.biomeToHabitat.put(BiomeGenBase.field_76781_i.field_76756_M, this.habitatSlots[3]);
        this.biomeToHabitat.put(BiomeGenBase.field_76782_w.field_76756_M, this.habitatSlots[4]);
        this.biomeToHabitat.put(BiomeGenBase.field_76792_x.field_76756_M, this.habitatSlots[4]);
        this.biomeToHabitat.put(BiomeGenBase.field_76768_g.field_76756_M, this.habitatSlots[5]);
        this.biomeToHabitat.put(BiomeGenBase.field_76784_u.field_76756_M, this.habitatSlots[5]);
        this.biomeToHabitat.put(BiomeGenBase.field_76770_e.field_76756_M, this.habitatSlots[6]);
        this.biomeToHabitat.put(BiomeGenBase.field_76783_v.field_76756_M, this.habitatSlots[6]);
        this.biomeToHabitat.put(BiomeGenBase.field_76780_h.field_76756_M, this.habitatSlots[7]);
        this.biomeToHabitat.put(BiomeGenBase.field_76776_l.field_76756_M, this.habitatSlots[8]);
        this.biomeToHabitat.put(BiomeGenBase.field_76777_m.field_76756_M, this.habitatSlots[8]);
        this.biomeToHabitat.put(BiomeGenBase.field_76775_o.field_76756_M, this.habitatSlots[8]);
        this.biomeToHabitat.put(BiomeGenBase.field_76774_n.field_76756_M, this.habitatSlots[8]);
        this.biomeToHabitat.put(BiomeGenBase.field_76789_p.field_76756_M, this.habitatSlots[9]);
        this.biomeToHabitat.put(BiomeGenBase.field_76788_q.field_76756_M, this.habitatSlots[9]);
        this.biomeToHabitat.put(BiomeGenBase.field_76778_j.field_76756_M, this.habitatSlots[10]);
        this.biomeToHabitat.put(BiomeGenBase.field_76779_k.field_76756_M, this.habitatSlots[11]);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        this.drawBackground();
        String str = StringUtil.localize("gui.habitatlocator").toUpperCase();
        this.field_73886_k.func_78276_b(str, this.startX + 8 + this.getCenteredOffset(str, 138), this.startY + 16, this.fontColor.get("gui.screen"));
        str = "(" + StringUtil.localize("gui.closetosearch") + ")";
        this.field_73886_k.func_78276_b(str, this.startX + 8 + this.getCenteredOffset(str, 138), this.startY + 76, this.fontColor.get("gui.table.header"));
        for (HabitatSlot slot : this.habitatSlots) {
            slot.isActive = false;
        }
        ArrayList biomeids = ((ContainerHabitatLocator)this.inventorySlots).inventory.biomesToSearch;
        Iterator i$ = biomeids.iterator();
        while (i$.hasNext()) {
            int biomeid = (Integer)i$.next();
            if (!this.biomeToHabitat.containsKey(biomeid)) continue;
            ((HabitatSlot)this.biomeToHabitat.get((Object)Integer.valueOf((int)biomeid))).isActive = true;
        }
        for (HabitatSlot slot : this.habitatSlots) {
            slot.draw(this.startX, this.startY);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.startX = (this.field_73880_f - this.xSize) / 2;
        this.startY = (this.field_73881_g - this.ySize) / 2;
    }

    public class HabitatSlot
    extends Widget {
        private final int slot;
        private final String name;
        private final String iconIndex;
        public boolean isActive;

        public HabitatSlot(int slot, String name) {
            super(GuiHabitatLocator.this.widgetManager, 0, 0);
            this.isActive = false;
            this.slot = slot;
            this.name = name;
            this.iconIndex = "habitats/" + name.toLowerCase(Locale.ENGLISH);
        }

        @Override
        public String getTooltip(EntityPlayer player) {
            return this.name;
        }

        public Icon getIcon() {
            return TextureManager.getInstance().getDefault(this.iconIndex);
        }

        public void setPosition(int x, int y) {
            this.xPos = x;
            this.yPos = y;
        }

        @Override
        public void draw(int startX, int startY) {
            if (this.getIcon() != null) {
                GL11.glDisable((int)2896);
                if (!this.isActive) {
                    GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.2f, (float)0.2f);
                }
                this.manager.minecraft.field_71446_o.func_98187_b("/gui/items.png");
                this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos, this.getIcon(), 16, 16);
                GL11.glEnable((int)2896);
            }
        }
    }
}

