/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.ForestryAPI;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.apiculture.worldgen.WorldGenHive;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.TileInventoryAdapter;
import forestry.plugins.PluginApiculture;
import java.util.Map;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.ForgeDirection;

public class TileAlvearySwarmer
extends TileAlveary
implements ISpecialInventory {
    public static final int BLOCK_META = 2;
    TileInventoryAdapter swarmerInventory;
    private Stack pendingSpawns = new Stack();

    public TileAlvearySwarmer() {
        super(2);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.swarmerInventory == null) {
            this.createInventory();
        }
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.AlvearySwarmerGUI.ordinal(), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (this.field_70331_k.func_72820_D() % 100L != 0L && this.pendingSpawns.size() > 0) {
            this.trySpawnSwarm();
        }
        if (this.field_70331_k.func_72820_D() % 500L != 0L) {
            return;
        }
        if (!this.hasMaster()) {
            return;
        }
        IAlvearyComponent master = (IAlvearyComponent)this.getCentralTE();
        if (!(master instanceof IBeeHousing)) {
            return;
        }
        IBeeHousing housing = (IBeeHousing)((Object)master);
        ItemStack queenstack = housing.getQueen();
        if (queenstack == null) {
            return;
        }
        if (!PluginApiculture.beeInterface.isMated(queenstack)) {
            return;
        }
        int slot = this.getInducerSlot();
        if (slot < 0) {
            return;
        }
        int chance = this.getChanceFor(this.swarmerInventory.func_70301_a(slot));
        this.swarmerInventory.func_70298_a(slot, 1);
        if (this.field_70331_k.field_73012_v.nextInt(1000) >= chance) {
            return;
        }
        IBee spawn = PluginApiculture.beeInterface.getMember(queenstack);
        spawn.setIsNatural(false);
        this.pendingSpawns.push(PluginApiculture.beeInterface.getMemberStack(spawn, EnumBeeType.PRINCESS.ordinal()));
    }

    private int getChanceFor(ItemStack stack) {
        for (Map.Entry entry : BeeManager.inducers.entrySet()) {
            if (!((ItemStack)entry.getKey()).func_77969_a(stack)) continue;
            return (Integer)entry.getValue();
        }
        return 0;
    }

    private int getInducerSlot() {
        for (int i = 0; i < this.swarmerInventory.func_70302_i_(); ++i) {
            if (this.swarmerInventory.func_70301_a(i) == null) continue;
            for (Map.Entry entry : BeeManager.inducers.entrySet()) {
                if (!((ItemStack)entry.getKey()).func_77969_a(this.swarmerInventory.func_70301_a(i))) continue;
                return i;
            }
        }
        return -1;
    }

    private void trySpawnSwarm() {
        ItemStack toSpawn = (ItemStack)this.pendingSpawns.peek();
        WorldGenHive generator = new WorldGenHive(new ItemStack[]{toSpawn});
        for (int i = 0; i < 10; ++i) {
            int spawnZ;
            int spawnY;
            int spawnX = this.field_70329_l + this.field_70331_k.field_73012_v.nextInt(80) - 40;
            if (!generator.func_76484_a(this.field_70331_k, this.field_70331_k.field_73012_v, spawnX, spawnY = this.field_70330_m + this.field_70331_k.field_73012_v.nextInt(40), spawnZ = this.field_70327_n + this.field_70331_k.field_73012_v.nextInt(80) - 40)) continue;
            this.pendingSpawns.pop();
            break;
        }
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public int getBlockTexture(int side, int metadata) {
        if (side == 0 || side == 1) {
            return 2;
        }
        if (this.pendingSpawns.size() > 0) {
            return 6;
        }
        return 5;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        if (this.swarmerInventory == null) {
            this.createInventory();
        }
        this.swarmerInventory.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("PendingSpawns");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            this.pendingSpawns.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        if (this.swarmerInventory != null) {
            this.swarmerInventory.writeToNBT(nbttagcompound);
        }
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingSpawns.toArray(new ItemStack[this.pendingSpawns.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            offspring[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingSpawns", (NBTBase)nbttaglist);
    }

    @Override
    protected void createInventory() {
        this.swarmerInventory = new TileInventoryAdapter(this, 4, "SwarmInv");
    }

    @Override
    public IInventory getInventory() {
        return this.swarmerInventory;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.addStack(stack, false, doAdd);
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return null;
    }

    public int func_70302_i_() {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int slotIndex) {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.func_70301_a(slotIndex);
        }
        return null;
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.func_70298_a(slotIndex, amount);
        }
        return null;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.func_70304_b(slotIndex);
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        if (this.swarmerInventory == null && !Proxies.common.isSimulating(this.field_70331_k)) {
            this.createInventory();
        }
        if (this.swarmerInventory != null) {
            this.swarmerInventory.func_70299_a(slotIndex, itemstack);
        }
    }

    @Override
    public String func_70303_b() {
        return "tile.alveary.2";
    }

    public int func_70297_j_() {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.func_70297_j_();
        }
        return 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

