/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.core.ITileStructure;
import forestry.apiculture.gadgets.TileAlvearyPlain;
import forestry.core.config.ForestryBlock;
import forestry.core.gadgets.BlockStructure;
import forestry.core.gadgets.StructureLogic;
import forestry.core.utils.Schemata;
import forestry.core.utils.Vect;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;

public class StructureLogicAlveary
extends StructureLogic {
    public static final String UID_ALVEARY = "alveary";
    public static final Schemata SCHEMATA_ALVEARY = new Schemata("alveary3x3", 5, 6, 5, "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FABAF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBMBF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FABAF", "FCCCF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF").setOffsets(-2, -3, -2);
    public static HashSet slabIds = new HashSet();

    public StructureLogicAlveary(ITileStructure structure) {
        super(UID_ALVEARY, structure);
        this.schematas = new Schemata[]{SCHEMATA_ALVEARY};
        this.metaOnValid.put(Schemata.EnumStructureBlock.BLOCK_B, 1);
    }

    @Override
    protected BlockStructure.EnumStructureState determineMasterState(Schemata schemata, boolean rotate) {
        Vect dimensions = schemata.getDimensions(rotate);
        int offsetX = schemata.getxOffset();
        int offsetZ = schemata.getzOffset();
        if (rotate) {
            offsetX = schemata.getzOffset();
            offsetZ = schemata.getxOffset();
        }
        for (int i = 0; i < dimensions.x; ++i) {
            for (int j = 0; j < schemata.getHeight(); ++j) {
                block10: for (int k = 0; k < dimensions.z; ++k) {
                    int z;
                    int x = this.structureTile.field_70329_l + i + offsetX;
                    int y = this.structureTile.field_70330_m + j + schemata.getyOffset();
                    if (!this.structureTile.field_70331_k.func_72899_e(x, y, z = this.structureTile.field_70327_n + k + offsetZ)) {
                        return BlockStructure.EnumStructureState.INDETERMINATE;
                    }
                    Schemata.EnumStructureBlock required = schemata.getAt(i, j, k, rotate);
                    if (required == Schemata.EnumStructureBlock.ANY) continue;
                    TileEntity tile = this.structureTile.field_70331_k.func_72796_p(x, y, z);
                    int blockid = this.structureTile.field_70331_k.func_72798_a(x, y, z);
                    switch (required) {
                        case AIR: {
                            if (blockid == 0) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_A: {
                            if (tile == null || !(tile instanceof IAlvearyComponent)) {
                                return BlockStructure.EnumStructureState.INVALID;
                            }
                            if (((ITileStructure)tile).getTypeUID().equals(UID_ALVEARY)) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case MASTER: 
                        case BLOCK_B: {
                            if (tile != null && tile instanceof TileAlvearyPlain) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_C: {
                            if (!slabIds.contains(blockid)) {
                                return BlockStructure.EnumStructureState.INVALID;
                            }
                            if ((this.structureTile.field_70331_k.func_72805_g(x, y, z) & 8) == 0) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_D: {
                            if (blockid == Block.field_72074_bW.field_71990_ca) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case FOREIGN: {
                            if (!(tile instanceof ITileStructure)) continue block10;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        default: {
                            return BlockStructure.EnumStructureState.INDETERMINATE;
                        }
                    }
                }
            }
        }
        return BlockStructure.EnumStructureState.VALID;
    }

    static {
        slabIds.add(Block.field_72079_ak.field_71990_ca);
        slabIds.add(Block.field_72092_bO.field_71990_ca);
        slabIds.add(ForestryBlock.slabs1.field_71990_ca);
        slabIds.add(ForestryBlock.slabs2.field_71990_ca);
        slabIds.add(ForestryBlock.slabs3.field_71990_ca);
        if (ForestryBlock.slabs4 != null) {
            slabIds.add(ForestryBlock.slabs4.field_71990_ca);
        }
    }
}

