/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.entities;

import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.plugins.PluginApiculture;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.world.World;

public class EntityBee
extends EntityCreature
implements IAnimals {
    private static final String DEFAULT_TEXTURE = "/gfx/forestry/entities/bees/honeyBee.png";
    IBee contained;
    IAlleleBeeSpecies species;
    EnumBeeType type = EnumBeeType.DRONE;
    private String beeTexture = "/gfx/forestry/entities/bees/honeyBee.png";

    public EntityBee(World world) {
        super(world);
    }

    private void resetAppearance() {
        this.beeTexture = this.species.getEntityTexture();
    }

    public EntityBee setIndividual(IBee bee) {
        this.contained = bee != null ? bee : PluginApiculture.beeInterface.templateAsIndividual(PluginApiculture.beeInterface.getDefaultTemplate());
        this.setSpecies(this.contained.getGenome().getPrimary());
        return this;
    }

    public IBee getBee() {
        return this.contained;
    }

    public EntityBee setType(EnumBeeType type) {
        this.type = type;
        return this;
    }

    public EnumBeeType getType() {
        return this.type;
    }

    public EntityBee setSpecies(IAlleleBeeSpecies species) {
        this.species = species;
        this.resetAppearance();
        return this;
    }

    public String func_70073_O() {
        return this.beeTexture;
    }

    public int func_70667_aM() {
        return 10;
    }
}

