/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.utils.StringUtil;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProviderMushroom
implements IFlowerProvider {
    @Override
    public boolean isAcceptedFlower(World world, IIndividual individual, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        if (blockid == Block.field_82516_cf.field_71990_ca) {
            return this.checkFlowerPot(world.func_72805_g(x, y, z));
        }
        return blockid == Block.field_72109_af.field_71990_ca || blockid == Block.field_72103_ag.field_71990_ca;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        EnumSet types = pollinatable.getPlantType();
        return types.size() > 1 || !types.contains(EnumPlantType.Nether);
    }

    private boolean checkFlowerPot(int meta) {
        return meta == 7 || meta == 8;
    }

    @Override
    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        if (blockid != 0) {
            if (blockid == Block.field_82516_cf.field_71990_ca) {
                return this.growInPot(world, x, y, z);
            }
            return false;
        }
        int groundid = world.func_72798_a(x, y - 1, z);
        if (groundid != Block.field_71994_by.field_71990_ca) {
            return false;
        }
        int mushroomId = world.field_73012_v.nextBoolean() ? Block.field_72109_af.field_71990_ca : Block.field_72103_ag.field_71990_ca;
        world.func_72832_d(x, y, z, mushroomId, 0, 2);
        return true;
    }

    private boolean growInPot(World world, int x, int y, int z) {
        if (world.field_73012_v.nextBoolean()) {
            world.func_72832_d(x, y, z, Block.field_82516_cf.field_71990_ca, 7, 2);
        } else {
            world.func_72832_d(x, y, z, Block.field_82516_cf.field_71990_ca, 8, 2);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("flowers.mushroom");
    }

    @Override
    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Override
    public ItemStack[] getItemStacks() {
        return new ItemStack[]{new ItemStack((Block)Block.field_72109_af), new ItemStack((Block)Block.field_72103_ag)};
    }
}

