/*
 * Decompiled with CFR 0.152.
 */
package omnitools.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.logging.Level;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.oredict.OreDictionary;
import omnitools.OmniTools;

public class LexiconManager {
    private static LexiconManager instance = new LexiconManager();
    private static HashMap oreNames = new HashMap();
    private static HashSet listNames = new HashSet();
    private static HashSet listOres = new HashSet();
    public static boolean isWhitelist = true;
    public static boolean logEntries = false;
    public static boolean writeDefaultFile = true;
    static final String BLOCK = "block";
    static final String ORE = "ore";
    static final String DUST = "dust";
    static final String INGOT = "ingot";
    static final String NUGGET = "nugget";
    static File theList;

    public static LexiconManager getInstance() {
        return instance;
    }

    public static String getName(ItemStack ore) {
        if (ore == null) {
            return "";
        }
        String ret = (String)oreNames.get(Arrays.asList(ore.field_77993_c, ore.func_77960_j()));
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public static boolean setList(File listFile) {
        if (theList != null) {
            return false;
        }
        theList = listFile;
        return true;
    }

    public static boolean equivalentOres(ItemStack ore1, ItemStack ore2) {
        if (ore1 == null || ore2 == null) {
            return false;
        }
        String oreName1 = (String)oreNames.get(Arrays.asList(ore1.field_77993_c, ore1.func_77960_j()));
        String oreName2 = (String)oreNames.get(Arrays.asList(ore2.field_77993_c, ore2.func_77960_j()));
        if (oreName1 == null || oreName2 == null) {
            return false;
        }
        return oreName1.equals(oreName2);
    }

    public static boolean invalidOre(ItemStack ore) {
        if (ore == null) {
            return true;
        }
        String oreName = (String)oreNames.get(Arrays.asList(ore.field_77993_c, ore.func_77960_j()));
        if (isWhitelist) {
            return !listOres.contains(Arrays.asList(ore.field_77993_c, ore.func_77960_j())) && !listNames.contains(oreName);
        }
        return listOres.contains(Arrays.asList(ore.field_77993_c, ore.func_77960_j())) || listNames.contains(oreName);
    }

    public static boolean safeOreType(String oreName) {
        return oreName.contains(BLOCK) || oreName.contains(ORE) || oreName.contains(DUST) || oreName.contains(INGOT) || oreName.contains(NUGGET);
    }

    @ForgeSubscribe
    public void addEntry(OreDictionary.OreRegisterEvent event) {
        if (oreNames.get(Arrays.asList(event.Ore.field_77993_c, event.Ore.func_77960_j())) != null) {
            return;
        }
        oreNames.put(Arrays.asList(event.Ore.field_77993_c, event.Ore.func_77960_j()), event.Name);
    }

    public static void addAllRegisteredOres() {
        int i;
        boolean writeToFile = false;
        BufferedWriter out = null;
        ArrayList<String> defaultList = new ArrayList<String>();
        if (writeDefaultFile && !theList.exists()) {
            try {
                writeToFile = true;
                theList.createNewFile();
                out = new BufferedWriter(new FileWriter(theList));
            }
            catch (Exception e) {
                OmniTools.logOT.log(Level.WARNING, "There is an error in the " + theList.getName() + " file!");
                e.printStackTrace();
            }
        }
        String[] registeredOreNames = OreDictionary.getOreNames();
        for (i = 0; i < registeredOreNames.length; ++i) {
            if (writeToFile) {
                if (isWhitelist && LexiconManager.safeOreType(registeredOreNames[i])) {
                    listNames.add(registeredOreNames[i]);
                    defaultList.add(registeredOreNames[i]);
                } else if (!isWhitelist && !LexiconManager.safeOreType(registeredOreNames[i])) {
                    listNames.add(registeredOreNames[i]);
                    defaultList.add(registeredOreNames[i]);
                }
            }
            ArrayList registeredOres = OreDictionary.getOres((String)registeredOreNames[i]);
            for (int j = 0; j < registeredOres.size(); ++j) {
                oreNames.put(Arrays.asList(((ItemStack)registeredOres.get((int)j)).field_77993_c, ((ItemStack)registeredOres.get(j)).func_77960_j()), registeredOreNames[i]);
            }
        }
        if (writeToFile) {
            Collections.sort(defaultList);
            if (isWhitelist) {
                OmniTools.logOT.log(Level.INFO, "[Whitelist] Generating Default Whitelist.");
            } else {
                OmniTools.logOT.log(Level.INFO, "[Blacklist] Generating Default Blacklist.");
            }
            try {
                for (i = 0; i < defaultList.size(); ++i) {
                    out.write((String)defaultList.get(i) + "\n");
                    if (!logEntries) continue;
                    if (isWhitelist) {
                        OmniTools.logOT.log(Level.INFO, "[Whitelist] Forge Lexicon will allow conversions for ALL items of type '" + (String)defaultList.get(i) + "'.");
                        continue;
                    }
                    OmniTools.logOT.log(Level.INFO, "[Blacklist] Forge Lexicon will disable conversions for ALL items of type '" + (String)defaultList.get(i) + "'.");
                }
                out.close();
                defaultList.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addAllListedOres(File listFile) {
        try {
            if (!listFile.exists()) {
                return;
            }
            if (isWhitelist) {
                OmniTools.logOT.log(Level.INFO, "[Whitelist] Reading established Whitelist from file.");
            } else {
                OmniTools.logOT.log(Level.INFO, "[Blacklist] Reading established Blacklist from file.");
            }
            Scanner scan = new Scanner(listFile);
            String[] line = null;
            String[] tokens = null;
            while (scan.hasNext()) {
                line = scan.next().split("\\n");
                tokens = line[0].split(":");
                if (tokens.length == 2) {
                    int itemID = Integer.parseInt(tokens[0]);
                    int itemMeta = Integer.parseInt(tokens[1]);
                    listOres.add(Arrays.asList(itemID, itemMeta));
                    if (!logEntries) continue;
                    if (isWhitelist) {
                        OmniTools.logOT.log(Level.INFO, "[Whitelist] Forge Lexicon will allow conversions to and from the specific item with ID " + itemID + " and metadata " + itemMeta + ".");
                        continue;
                    }
                    OmniTools.logOT.log(Level.INFO, "[Blacklist] Forge Lexicon will disable conversions to and from the specific item with ID " + itemID + " and metadata " + itemMeta + ".");
                    continue;
                }
                if (tokens.length != 1) continue;
                listNames.add(line[0]);
                if (!logEntries) continue;
                if (isWhitelist) {
                    OmniTools.logOT.log(Level.INFO, "[Whitelist] Forge Lexicon will allow conversions for ALL items of type '" + line[0] + "'.");
                    continue;
                }
                OmniTools.logOT.log(Level.INFO, "[Blacklist] Forge Lexicon will disable conversions for ALL items of type '" + line[0] + "'.");
            }
            scan.close();
        }
        catch (Exception e) {
            OmniTools.logOT.log(Level.WARNING, "There is an error in the " + listFile.getName() + " file!");
            e.printStackTrace();
        }
    }
}

