/*
 * Decompiled with CFR 0.152.
 */
package mods.chemcraft.core.util;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraftforge.common.Configuration;

public class ModUtils {
    public Logger myLogger;
    public boolean isDebugMode;
    private Configuration config;
    private boolean isConfigLoaded;
    private int itemIdDefault;
    private int blockIdDefault;

    public ModUtils(FMLPreInitializationEvent event, int itemIdDefault, int blockIdDefault) {
        this(ModUtils.parseConfigFile(event.getModConfigurationDirectory(), event.getModMetadata().modId), event.getModLog(), itemIdDefault, blockIdDefault);
    }

    public ModUtils(File configFile, Logger logger, int itemIdDefault, int blockIdDefault) {
        this.config = new Configuration(configFile);
        this.myLogger = logger;
        this.myLogger.setParent(FMLLog.getLogger());
        this.isConfigLoaded = false;
        this.isDebugMode = this.getBoolean("debugMode", false);
        this.saveConfig();
        this.itemIdDefault = itemIdDefault;
        this.blockIdDefault = blockIdDefault;
    }

    public ModUtils(FMLPreInitializationEvent event) {
        this(event, 0, 0);
    }

    private static File parseConfigFile(File configDir, String modID) {
        return new File(configDir, modID.replace('|', '\\') + ".cfg");
    }

    public void loadConfig() {
        if (!this.isConfigLoaded) {
            this.config.load();
            this.isConfigLoaded = true;
        }
    }

    public void saveConfig() {
        if (this.isConfigLoaded && this.config.hasChanged()) {
            this.config.save();
            this.isConfigLoaded = false;
        }
    }

    public boolean getBoolean(String name, boolean Default) {
        this.loadConfig();
        return this.config.get("general", name, Default).getBoolean(Default);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, true);
    }

    public int getItemId(String name) {
        if (this.itemIdDefault > 0) {
            this.loadConfig();
            return this.config.getItem(name, this.itemIdDefault).getInt(this.itemIdDefault++);
        }
        return 0;
    }

    public int getBlockId(String name) {
        if (this.blockIdDefault > 0) {
            this.loadConfig();
            return this.config.getBlock(name, this.blockIdDefault).getInt(this.blockIdDefault++);
        }
        return 0;
    }

    public void logDebug(String message) {
        if (this.isDebugMode) {
            this.myLogger.log(Level.INFO, "DEBUG: " + message);
        }
    }

    public void logDebug(String message, Exception e) {
        if (this.isDebugMode) {
            this.myLogger.log(Level.WARNING, "DEBUG: " + message);
            e.printStackTrace();
        }
    }
}

