/*
 * Decompiled with CFR 0.152.
 */
package mods.chemcraft.core.util;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import mods.chemcraft.core.asm.ChemcraftCoreLoadingPlugin;
import mods.chemcraft.core.util.CoreModConfiguration;

public class CoreModUtils {
    public Logger myLogger;
    public boolean isDebugMode;
    private CoreModConfiguration config;
    private boolean isConfigLoaded;
    private int itemIdDefault;
    private int blockIdDefault;

    public CoreModUtils(String modId, int itemIdDefault, int blockIdDefault) {
        this(CoreModUtils.parseConfigFile(new File(ChemcraftCoreLoadingPlugin.mcLocation, "config"), modId), Logger.getLogger(modId), itemIdDefault, blockIdDefault);
    }

    public CoreModUtils(File configFile, Logger logger, int itemIdDefault, int blockIdDefault) {
        this.config = new CoreModConfiguration(configFile, this);
        this.myLogger = logger;
        this.myLogger.setParent(FMLLog.getLogger());
        this.isConfigLoaded = false;
        this.isDebugMode = this.getBoolean("debugMode", false);
        this.saveConfig();
        this.itemIdDefault = itemIdDefault;
        this.blockIdDefault = blockIdDefault;
    }

    public CoreModUtils(String modId) {
        this(modId, 0, 0);
    }

    private static File parseConfigFile(File configDir, String modID) {
        return new File(configDir, modID.replace('|', '\\') + ".cfg");
    }

    public void loadConfig() {
        if (!this.isConfigLoaded) {
            this.config.load();
            this.isConfigLoaded = true;
        }
    }

    public void saveConfig() {
        if (this.isConfigLoaded && this.config.hasChanged()) {
            this.config.save();
            this.isConfigLoaded = false;
        }
    }

    public boolean getBoolean(String name, boolean Default) {
        this.loadConfig();
        return this.config.getBoolean(name, Default);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, true);
    }

    public int getItemId(String name) {
        if (this.itemIdDefault > 0) {
            return this.getInt(name, this.itemIdDefault++);
        }
        return 0;
    }

    public int getBlockId(String name) {
        if (this.blockIdDefault > 0) {
            return this.getInt(name, this.blockIdDefault++);
        }
        return 0;
    }

    public int getInt(String name, int Default) {
        this.loadConfig();
        return this.config.getInt(name, Default);
    }

    public void logDebug(String message) {
        if (this.isDebugMode) {
            this.myLogger.log(Level.INFO, "DEBUG: " + message);
        }
    }

    public void logDebug(String message, Exception e) {
        if (this.isDebugMode) {
            this.myLogger.log(Level.WARNING, "DEBUG: " + message);
            e.printStackTrace();
        }
    }
}

