/*
 * Decompiled with CFR 0.152.
 */
package mods.chemcraft.core.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mods.chemcraft.core.util.CoreModUtils;

public class CoreModConfiguration {
    private File configFile;
    private CoreModUtils util;
    private ArrayList properties = new ArrayList();
    private boolean hasChanged = false;

    public CoreModConfiguration(File file, CoreModUtils util) {
        this.configFile = file;
        this.util = util;
    }

    public void load() {
        if (this.configFile.exists()) {
            try {
                List<String> lines = Files.readAllLines(Paths.get(this.configFile.getAbsolutePath(), new String[0]), Charset.defaultCharset());
                for (String line : lines) {
                    this.properties.add(new Property(line));
                }
            }
            catch (IOException e) {
                this.util.logDebug("Failed to read coremod config " + this.configFile.getAbsolutePath(), e);
            }
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void save() {
        if (this.hasChanged) {
            ArrayList<String> lines = new ArrayList<String>();
            for (Property prop : this.properties) {
                if (prop.type == Type.Void) continue;
                lines.add(prop.toString());
            }
            try {
                Files.write(Paths.get(this.configFile.getAbsolutePath(), new String[0]), lines, Charset.defaultCharset(), new OpenOption[0]);
            }
            catch (IOException e) {
                this.util.logDebug("Failed to save coremod config " + this.configFile.getAbsolutePath(), e);
            }
        }
    }

    private Property getProperty(String name, Type type) {
        for (Property prop : this.properties) {
            if (prop.type != type || !prop.name.equals(name)) continue;
            return prop;
        }
        return null;
    }

    private Object getValue(String name, Object Default, Type type) {
        Property prop = this.getProperty(name, type);
        if (prop != null) {
            return prop.value;
        }
        this.properties.add(new Property(name, type, Default));
        this.hasChanged = true;
        return Default;
    }

    public boolean getBoolean(String name, boolean Default) {
        return (Boolean)this.getValue(name, Default, Type.Boolean);
    }

    public int getInt(String name, int Default) {
        return (Integer)this.getValue(name, Default, Type.Integer);
    }

    private static class Property {
        public String name;
        public Type type;
        public Object value;

        Property(String line) {
            try {
                List<String> tokens = Arrays.asList(line.split("[=:]"));
                char typeTest = Character.toUpperCase(tokens.get(0).charAt(0));
                for (Type test : Type.values()) {
                    if (typeTest != test.symbol) continue;
                    this.value = test == Type.String ? tokens.get(2) : test.def.getMethod(test.parseFunction, String.class).invoke(null, tokens.get(2));
                    this.name = tokens.get(1);
                    this.type = test;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.name = "";
            this.type = Type.Void;
            this.value = line;
        }

        Property(String name, Type type, Object value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return this.type.symbol + ":" + this.name + "=" + this.value.toString();
        }
    }

    private static enum Type {
        Integer('I', Integer.class, "parseInt"),
        Boolean('B', Boolean.class, "parseBoolean"),
        String('S', String.class, null),
        Void('V', null, null);

        public char symbol;
        public Class def;
        public String parseFunction;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Type(String symbol) {
            void parseFunction;
            void def;
            this.symbol = (char)symbol;
            this.def = def;
            this.parseFunction = parseFunction;
        }
    }
}

