/*
 * Decompiled with CFR 0.152.
 */
package mods.chemcraft.core.tile.util;

import java.util.ArrayList;
import java.util.HashMap;
import mods.chemcraft.core.tile.util.IGenericTankContainer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TankContainerUtil
implements IGenericTankContainer {
    private ArrayList tanks;
    private HashMap sideMap = new HashMap();
    private HashMap liquidMap = new HashMap();
    private boolean useSideMap;
    private boolean useLiquidMap;

    public TankContainerUtil(int tanks) throws IndexOutOfBoundsException {
        if (tanks <= 0) {
            throw new IndexOutOfBoundsException();
        }
        this.tanks = new ArrayList(tanks);
    }

    @Override
    public boolean addSideMapping(ForgeDirection direction, int index) throws IndexOutOfBoundsException {
        this.useSideMap = true;
        boolean overridden = false;
        if (this.validIndex(index)) {
            if (this.sideMap.containsKey(direction)) {
                overridden = true;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        this.sideMap.put(direction, index);
        return overridden;
    }

    @Override
    public boolean addLiquidMapping(LiquidStack stack, int index) throws IndexOutOfBoundsException {
        this.useLiquidMap = true;
        boolean overridden = false;
        if (this.validIndex(index)) {
            if (this.liquidMap.containsKey(stack)) {
                overridden = true;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        this.liquidMap.put(stack, index);
        return overridden;
    }

    public int addTank(LiquidTank newTank) {
        this.tanks.add(newTank);
        return this.tanks.size() - 1;
    }

    private boolean validIndex(int index) {
        return index >= 0 && index < this.tanks.size() && this.tanks.get(index) != null;
    }

    @Override
    public LiquidTank getTank(int index) {
        if (this.validIndex(index)) {
            return (LiquidTank)this.tanks.get(index);
        }
        return null;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        Integer tankIndex = null;
        if (this.useSideMap) {
            tankIndex = (Integer)this.sideMap.get(from);
            if (this.useLiquidMap) {
                tankIndex = tankIndex == this.liquidMap.get(resource) ? tankIndex : null;
            }
        } else if (this.useLiquidMap) {
            tankIndex = (Integer)this.liquidMap.get(resource);
        }
        if (tankIndex == null) {
            return 0;
        }
        return this.fill(tankIndex, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        LiquidTank tank = this.getTank(tankIndex);
        if (tank == null || this.useLiquidMap && tankIndex != (Integer)this.liquidMap.get(resource)) {
            return 0;
        }
        return tank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        Integer tankIndex = null;
        if (this.useSideMap) {
            tankIndex = (Integer)this.sideMap.get(from);
        } else {
            for (LiquidTank tank : this.tanks) {
                if (tank.getTankPressure() < 0 || tank.getLiquid() == null || tank.getLiquid().amount <= 0) continue;
                tankIndex = this.tanks.indexOf(tank);
            }
        }
        if (tankIndex == null) {
            return null;
        }
        return this.drain(tankIndex, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        LiquidTank tank = this.getTank(tankIndex);
        if (tank == null) {
            return null;
        }
        return tank.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (this.useSideMap) {
            ILiquidTank[] test = new ILiquidTank[]{this.getTank((Integer)this.sideMap.get(direction))};
            return test;
        }
        ILiquidTank[] ans = new ILiquidTank[this.tanks.size()];
        for (int i = 0; i < this.tanks.size(); ++i) {
            ans[i] = (ILiquidTank)this.tanks.get(i);
        }
        return ans;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.getTank((Integer)this.sideMap.get(direction));
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        NBTTagList tankList = new NBTTagList();
        for (int i = 0; i < this.tanks.size(); ++i) {
            LiquidTank tank = this.getTank(i);
            if (tank == null) continue;
            NBTTagCompound invTag = new NBTTagCompound();
            invTag.func_74774_a("tank", (byte)i);
            tankList.func_74742_a((NBTBase)tank.writeToNBT(invTag));
        }
        tag.func_74782_a("Tanks", (NBTBase)tankList);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        NBTTagList tagList = tag.func_74761_m("Tanks");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound invTag = (NBTTagCompound)tagList.func_74743_b(i);
            byte slot = invTag.func_74771_c("tank");
            this.getTank(slot).readFromNBT(invTag);
        }
    }
}

