/*
 * Decompiled with CFR 0.152.
 */
package mods.chemcraft.core.tile.util;

import mods.chemcraft.core.tile.TileEntityInventory;
import mods.chemcraft.core.tile.util.IGenericInventory;
import mods.chemcraft.core.util.ItemStackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class InventoryUtil
implements IGenericInventory {
    protected String name;
    private TileEntityInventory myTile;

    public InventoryUtil(String name, TileEntityInventory myTile) {
        this.name = name;
        this.myTile = myTile;
    }

    @Override
    public boolean addToStackInSlot(int slot, ItemStack stack) {
        if (this.canAddStackToSlot(slot, stack)) {
            ItemStack slotContents = this.func_70301_a(slot);
            if (slotContents == null) {
                slotContents = stack;
            } else {
                slotContents.field_77994_a += stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canAddStackToSlot(int slot, ItemStack stack) {
        if (this.validSlot(slot)) {
            ItemStack slotContents = this.func_70301_a(slot);
            if (slotContents == null) {
                return true;
            }
            return slotContents.func_77985_e() && stack.func_77969_a(slotContents) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotContents) && slotContents.field_77994_a + stack.field_77994_a <= slotContents.func_77976_d();
        }
        return false;
    }

    private boolean validSlot(int slot) {
        return slot > 0 && slot < this.myTile.inventory.length;
    }

    public int func_70302_i_() {
        if (this.myTile.inventory == null) {
            return 0;
        }
        return this.myTile.inventory.length;
    }

    public ItemStack func_70301_a(int index) {
        if (index >= this.myTile.inventory.length || index < 0) {
            return null;
        }
        return this.myTile.inventory[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(index, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(index, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.myTile.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return this.name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void closeChest(World worldObj, int xCoord, int yCoord, int zCoord) {
        for (int i = 0; i < this.myTile.inventory.length; ++i) {
            ItemStack stack = this.myTile.inventory[i];
            if (stack == null || stack.func_77973_b() == null || this.func_94041_b(i, stack)) continue;
            ItemStackUtil.dropItemStack(worldObj, xCoord, yCoord, zCoord, stack);
            this.func_70299_a(i, null);
        }
    }

    public void func_70305_f() {
        for (int i = 0; i < this.myTile.inventory.length; ++i) {
            ItemStack stack = this.myTile.inventory[i];
            if (stack == null || stack.func_77973_b() == null || this.func_94041_b(i, stack)) continue;
            ItemStackUtil.dropItemStack(this.myTile.field_70331_k, this.myTile.field_70329_l, this.myTile.field_70330_m, this.myTile.field_70327_n, stack);
            this.func_70299_a(i, null);
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.myTile.inventory.length; ++i) {
            ItemStack stack = this.myTile.inventory[i];
            if (stack == null) continue;
            NBTTagCompound invTag = new NBTTagCompound();
            invTag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(invTag);
            itemList.func_74742_a((NBTBase)invTag);
        }
        tag.func_74782_a("Inventory", (NBTBase)itemList);
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList tagList = tag.func_74761_m("Inventory");
        this.name = tag.func_74779_i("name");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound invTag = (NBTTagCompound)tagList.func_74743_b(i);
            byte slot = invTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.myTile.inventory.length) continue;
            this.myTile.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)invTag);
        }
    }

    public void func_70296_d() {
    }
}

