/*
 * Decompiled with CFR 0.152.
 */
package mods.chemcraft.core.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mods.chemcraft.core.asm.ChemcraftCore;
import mods.chemcraft.core.render.LiquidGauge;
import mods.chemcraft.core.tile.TileEntityInventory;
import mods.chemcraft.core.tile.TileEntityInventoryAndTank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public abstract class GenericContainer
extends Container {
    public final TileEntityInventory myTile;
    protected final int playerInvHeight;
    protected List dataMap = new ArrayList();
    public List liquidGauges = new ArrayList();

    public GenericContainer(InventoryPlayer inventoryPlayer, TileEntityInventory tile, int playerInvHeight) {
        this.myTile = tile;
        this.playerInvHeight = playerInvHeight;
        this.bindPlayerInventory(inventoryPlayer);
    }

    public GenericContainer(InventoryPlayer inventoryPlayer, TileEntityInventory tile) {
        this(inventoryPlayer, tile, 0);
    }

    protected void addLiquidGuage(int tankCapacity, int x, int y, int width, int height, int tankId) {
        this.liquidGauges.add(new LiquidGauge(tankCapacity, x, y, width, height, tankId));
        this.dataMap.add("tankId" + tankId);
        this.dataMap.add("tankMeta" + tankId);
        this.dataMap.add("tankAmount" + tankId);
    }

    protected void addItemSlot(int index, int x, int y) {
        this.func_75146_a(new Slot((IInventory)this.myTile, index, x, y));
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.myTile.func_70300_a(player);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, this.playerInvHeight + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, this.playerInvHeight + 58));
        }
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        this.myTile.func_70305_f();
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.liquidGauges.isEmpty() && this.myTile instanceof TileEntityInventoryAndTank) {
            TileEntityInventoryAndTank tankTile = (TileEntityInventoryAndTank)this.myTile;
            for (LiquidGauge gauge : this.liquidGauges) {
                LiquidTank tileTank = tankTile.getTank(gauge.tankId);
                LiquidStack tankLiquid = tileTank.getLiquid();
                if (gauge.liquidID == 0 && tankLiquid == null) continue;
                if (tankLiquid == null) {
                    gauge.liquidID = 0;
                    gauge.liquidMeta = 0;
                    gauge.liquidAmount = 0;
                    this.sendGuiUpdate(this.dataMap.indexOf("tankId" + gauge.tankId), 0);
                    this.sendGuiUpdate(this.dataMap.indexOf("tankMeta" + gauge.tankId), 0);
                    this.sendGuiUpdate(this.dataMap.indexOf("tankAmount" + gauge.tankId), 0);
                    continue;
                }
                if (gauge.liquidID == 0) {
                    gauge.liquidID = tankLiquid.itemID;
                    gauge.liquidMeta = tankLiquid.itemMeta;
                    gauge.liquidAmount = tankLiquid.amount;
                    this.sendGuiUpdate(this.dataMap.indexOf("tankId" + gauge.tankId), tankLiquid.itemID);
                    this.sendGuiUpdate(this.dataMap.indexOf("tankMeta" + gauge.tankId), tankLiquid.itemMeta);
                    this.sendGuiUpdate(this.dataMap.indexOf("tankAmount" + gauge.tankId), tankLiquid.amount);
                    continue;
                }
                if (gauge.liquidID != tankLiquid.itemID) {
                    gauge.liquidID = tankLiquid.itemID;
                    this.sendGuiUpdate(this.dataMap.indexOf("tankId" + gauge.tankId), tankLiquid.itemID);
                }
                if (gauge.liquidMeta != tileTank.getLiquid().itemMeta) {
                    gauge.liquidMeta = tankLiquid.itemMeta;
                    this.sendGuiUpdate(this.dataMap.indexOf("tankMeta" + gauge.tankId), tankLiquid.itemMeta);
                }
                if (gauge.liquidAmount == tankLiquid.amount) continue;
                gauge.liquidAmount = tankLiquid.amount;
                this.sendGuiUpdate(this.dataMap.indexOf("tankAmount" + gauge.tankId), tankLiquid.amount);
            }
        }
    }

    protected void sendGuiUpdate(int mapKey, int data) {
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
            icrafting.func_71112_a((Container)this, mapKey, data);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int key, int data) {
        String dataBinding = (String)this.dataMap.get(key);
        try {
            if (dataBinding.startsWith("tankId")) {
                ((LiquidGauge)this.liquidGauges.get((int)Integer.parseInt((String)dataBinding.substring((int)6)))).liquidID = data;
            }
            if (dataBinding.startsWith("tankMeta")) {
                ((LiquidGauge)this.liquidGauges.get((int)Integer.parseInt((String)dataBinding.substring((int)8)))).liquidMeta = data;
            }
            if (dataBinding.startsWith("tankAmount")) {
                ((LiquidGauge)this.liquidGauges.get((int)Integer.parseInt((String)dataBinding.substring((int)10)))).liquidAmount = data;
            }
        }
        catch (Exception e) {
            ChemcraftCore.util.logDebug("Error parsing dataBinding: " + dataBinding + " from key: " + key + "with data: " + data, e);
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        ItemStack stack = null;
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        if (slotObject != null && slotObject.func_75216_d()) {
            ItemStack stackInSlot = slotObject.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slot < 9 ? !this.func_75135_a(stackInSlot, this.myTile.inventory.length, this.myTile.inventory.length + 36, true) : !this.func_75135_a(stackInSlot, 0, this.myTile.inventory.length - 1, false)) {
                return null;
            }
            if (stackInSlot.field_77994_a == 0) {
                slotObject.func_75215_d(null);
            } else {
                slotObject.func_75218_e();
            }
            if (stackInSlot.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slotObject.func_82870_a(player, stackInSlot);
        }
        return stack;
    }
}

