/*
 * Decompiled with CFR 0.152.
 */
package mods.chemcraft.core.compat;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import mods.chemcraft.core.asm.ChemcraftCore;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ModConfigHelper {
    public static ItemStack get(String itemName, int amount, int meta) {
        int Id = ModConfigHelper.getId(itemName);
        if (Id == 0) {
            return null;
        }
        return new ItemStack(Id, amount, meta);
    }

    public static ItemStack get(String itemName) {
        return ModConfigHelper.get(itemName, 1, Short.MAX_VALUE);
    }

    public static ItemStack get(String itemName, int meta) {
        return ModConfigHelper.get(itemName, 1, meta);
    }

    public static int getId(String itemName) {
        for (int i = 1; i < Item.field_77698_e.length; ++i) {
            if (!ModConfigHelper.getName(i).equals(itemName)) continue;
            return i;
        }
        ChemcraftCore.util.logDebug("Can't find item with name: " + itemName);
        return 0;
    }

    public static String getName(int index) {
        String name = "";
        if (index < Block.field_71973_m.length && Block.field_71973_m[index] != null && Block.field_71973_m[index].field_71990_ca != 0) {
            Block block = Block.field_71973_m[index];
            name = block.func_71917_a();
            if (ModConfigHelper.isInvalidName(name) && Item.field_77698_e[index] != null) {
                name = Item.field_77698_e[index].func_77658_a();
            }
            if (ModConfigHelper.isInvalidName(name) && Item.field_77698_e[index] != null) {
                name = Item.field_77698_e[index].func_77667_c(new ItemStack(index, 1, 0));
            }
            if (ModConfigHelper.isInvalidName(name)) {
                name = block.getClass().getCanonicalName();
            }
            if (ModConfigHelper.isInvalidName(name)) {
                name = block.getClass().getName();
            }
        } else if (Item.field_77698_e[index] != null) {
            Item item = Item.field_77698_e[index];
            name = item.func_77658_a();
            if (ModConfigHelper.isInvalidName(name)) {
                name = item.getClass().getCanonicalName();
            }
            if (ModConfigHelper.isInvalidName(name)) {
                name = item.getClass().getName();
            }
        }
        return name;
    }

    private static boolean isInvalidName(String name) {
        return name == null || name.equals("") || name.endsWith(".null");
    }

    public static void printItemRegistry() {
        block4: {
            try {
                File output = new File(Minecraft.func_71380_b(), "Chemcraft ItemRegistry.txt");
                if (output.exists()) {
                    output.delete();
                }
                output.createNewFile();
                String newLine = System.getProperty("line.separator");
                String name = "";
                for (int i = 1; i < Item.field_77698_e.length; ++i) {
                    name = ModConfigHelper.getName(i);
                    if (ModConfigHelper.isInvalidName(name)) continue;
                    Files.append((CharSequence)("Id: " + i + " Name: " + name + newLine), (File)output, (Charset)StandardCharsets.US_ASCII);
                }
            }
            catch (IOException e) {
                if (!ChemcraftCore.util.isDebugMode) break block4;
                e.printStackTrace();
            }
        }
    }
}

