/*
 * Decompiled with CFR 0.152.
 */
package mods.chemcraft.core.block;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mods.chemcraft.core.block.IDifferentDrop;
import mods.chemcraft.core.block.MetaBlock;
import mods.chemcraft.core.block.MetaBlocksItemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class MetaBlocks
extends Block {
    private Map blocks;
    protected int counter = 0;
    protected String modName = Loader.instance().activeModContainer().getModId().toLowerCase().replace('|', '/') + ":";
    public String name;

    public MetaBlocks(int ID, Material material, String name) {
        super(ID, material);
        this.name = name;
        GameRegistry.registerBlock((Block)this, MetaBlocksItemBlock.class, (String)name);
        this.blocks = new HashMap();
    }

    public ItemStack addMetaBlock(MetaBlock newBlock) throws IndexOutOfBoundsException {
        if (this.counter > 15) {
            throw new IndexOutOfBoundsException("MetaBlocks can only have 16 values! (0-15) You can't register 17! Use a MetaTile OR use another MetaBlocks.");
        }
        this.blocks.put(this.counter, newBlock);
        ItemStack temp = new ItemStack((Block)this, 1, this.counter++);
        LanguageRegistry.addName((Object)temp, (String)newBlock.displayName);
        return temp;
    }

    protected boolean indexCheck(int index) {
        return this.blocks.size() > index && this.blocks.get(index) != null;
    }

    public MetaBlock getMetaBlock(int meta) {
        return (MetaBlock)this.blocks.get(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return this.getMetaBlock((int)meta).blockIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int unknown, CreativeTabs tab, List subItems) {
        for (int i = 0; i < this.counter; ++i) {
            subItems.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        for (MetaBlock block : this.blocks.values()) {
            block.registerIcons(this.modName, par1IconRegister);
        }
    }

    public int quantityDropped(int meta, int fortume, Random rand) {
        MetaBlock called = this.getMetaBlock(meta);
        if (called instanceof IDifferentDrop) {
            return ((IDifferentDrop)((Object)called)).getQuantityDropped(meta, fortume, rand);
        }
        return 1;
    }

    public int func_71885_a(int meta, Random rand, int fortune) {
        MetaBlock called = this.getMetaBlock(meta);
        if (called instanceof IDifferentDrop) {
            return ((IDifferentDrop)((Object)called)).getIdDropped(meta, rand, fortune);
        }
        return this.field_71990_ca;
    }

    public int func_71899_b(int meta) {
        MetaBlock called = this.getMetaBlock(meta);
        if (called instanceof IDifferentDrop) {
            return ((IDifferentDrop)((Object)called)).getMetaDropped(meta);
        }
        return meta;
    }
}

