/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.ue;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.power.TileEntityEnergyConsumer;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.IVoltage;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.ElectricityPack;

public class TileEntityUniversalElectricityConsumer
extends TileEntityEnergyConsumer
implements IVoltage,
IConnector {
    private int _wattsLastTick;

    public TileEntityUniversalElectricityConsumer() {
        this(0);
    }

    public TileEntityUniversalElectricityConsumer(int voltageIndex) {
        super(PowerConverterCore.powerSystemUniversalElectricity, voltageIndex, IConductor.class);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            int desiredWatts = this.getTotalEnergyDemand() / PowerConverterCore.powerSystemUniversalElectricity.getInternalEnergyPerInput();
            ElectricityPack powerRequested = new ElectricityPack((double)desiredWatts / this.getVoltage(), this.getVoltage());
            ElectricityPack powerPack = ElectricityNetworkHelper.consumeFromMultipleSides((TileEntity)this, (ElectricityPack)powerRequested);
            double watts = powerPack.getWatts();
            this.storeEnergy(MathHelper.func_76128_c((double)(watts * (double)PowerConverterCore.powerSystemUniversalElectricity.getInternalEnergyPerInput())));
            this._wattsLastTick = (int)watts;
        }
    }

    public double getVoltage() {
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }

    @Override
    public int getInputRate() {
        return this._wattsLastTick;
    }

    public boolean canConnect(ForgeDirection direction) {
        return true;
    }
}

