/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.ic2;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.power.TileEntityEnergyConsumer;

public class TileEntityIndustrialCraftConsumer
extends TileEntityEnergyConsumer
implements IEnergySink {
    private boolean _isAddedToEnergyNet;
    private boolean _didFirstAddToNet;
    private int _euLastTick;
    private long _lastTickInjected;

    public TileEntityIndustrialCraftConsumer() {
        this(0);
    }

    public TileEntityIndustrialCraftConsumer(int voltageIndex) {
        super(PowerConverterCore.powerSystemIndustrialCraft, voltageIndex, IEnergyEmitter.class);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this._didFirstAddToNet && !this.field_70331_k.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this._didFirstAddToNet = true;
            this._isAddedToEnergyNet = true;
        }
        if (this.field_70331_k.func_72820_D() - this._lastTickInjected > 2L) {
            this._euLastTick = 0;
        }
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (!this._isAddedToEnergyNet) {
            this._didFirstAddToNet = false;
        }
    }

    public void func_70313_j() {
        if (this._isAddedToEnergyNet) {
            if (!this.field_70331_k.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            }
            this._isAddedToEnergyNet = false;
        }
        super.func_70313_j();
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    public boolean isAddedToEnergyNet() {
        return this._isAddedToEnergyNet;
    }

    public int demandsEnergy() {
        return this.getTotalEnergyDemand() / PowerConverterCore.powerSystemIndustrialCraft.getInternalEnergyPerInput();
    }

    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.getMaxSafeInput()) {
            int id = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            int meta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            Block.field_71973_m[id].func_71897_c(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, meta, 0);
            return amount;
        }
        int pcuNotStored = this.storeEnergy(amount * PowerConverterCore.powerSystemIndustrialCraft.getInternalEnergyPerInput());
        int euNotStored = pcuNotStored / PowerConverterCore.powerSystemIndustrialCraft.getInternalEnergyPerInput();
        int euThisInjection = amount - euNotStored;
        if (this._lastTickInjected == this.field_70331_k.func_72820_D()) {
            this._euLastTick += euThisInjection;
        } else {
            this._euLastTick = euThisInjection;
            this._lastTickInjected = this.field_70331_k.func_72820_D();
        }
        return euNotStored;
    }

    public int getMaxSafeInput() {
        if (this.getVoltageIndex() == 3) {
            return Integer.MAX_VALUE;
        }
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }

    @Override
    public int getInputRate() {
        return this._euLastTick;
    }
}

