/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.INeighboorUpdateTile;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.power.PowerSystem;

public class TileEntityBridgeComponent
extends TileEntity
implements INeighboorUpdateTile {
    private Map _adjacentBridges = new HashMap();
    private Map _adjacentTiles = new HashMap();
    private Class _adjacentClass;
    protected PowerSystem _powerSystem;
    protected int _voltageIndex;
    private boolean _initialized;

    protected TileEntityBridgeComponent(PowerSystem powersystem, int voltageNameIndex, Class adjacentClass) {
        this._powerSystem = powersystem;
        this._voltageIndex = voltageNameIndex;
        this._adjacentClass = adjacentClass;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this._initialized && !this.field_70328_o) {
            this.onNeighboorChanged();
            this._initialized = true;
        }
    }

    public void onNeighboorChanged() {
        HashMap<ForgeDirection, TileEntityEnergyBridge> adjacentBridges = new HashMap<ForgeDirection, TileEntityEnergyBridge>();
        HashMap<ForgeDirection, TileEntity> adjacentTiles = new HashMap<ForgeDirection, TileEntity>();
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)d);
            if (te != null && te instanceof TileEntityEnergyBridge) {
                adjacentBridges.put(d, (TileEntityEnergyBridge)te);
                continue;
            }
            if (te == null || !this._adjacentClass.isAssignableFrom(te.getClass())) continue;
            adjacentTiles.put(d, te);
        }
        this._adjacentBridges = adjacentBridges;
        this._adjacentTiles = adjacentTiles;
    }

    public PowerSystem getPowerSystem() {
        return this._powerSystem;
    }

    public boolean isConnected() {
        return this._adjacentTiles.size() > 0;
    }

    public boolean isSideConnected(int side) {
        return this._adjacentTiles.get(ForgeDirection.getOrientation((int)side)) != null;
    }

    public boolean isSideConnectedClient(int side) {
        TileEntity te = BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)ForgeDirection.getOrientation((int)side));
        return te != null && this._adjacentClass.isAssignableFrom(te.getClass());
    }

    public int getVoltageIndex() {
        return this._voltageIndex;
    }

    public TileEntityEnergyBridge getFirstBridge() {
        return this._adjacentBridges.size() == 0 ? null : (TileEntityEnergyBridge)((Object)this._adjacentBridges.values().toArray()[0]);
    }

    protected Map getBridges() {
        return this._adjacentBridges;
    }

    protected Map getTiles() {
        return this._adjacentTiles;
    }

    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        if (this._voltageIndex == 0) {
            this._voltageIndex = tagCompound.func_74762_e("voltageIndex");
        }
    }

    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        tagCompound.func_74768_a("voltageIndex", this._voltageIndex);
    }
}

