/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;
import powercrystals.powerconverters.common.BridgeSideData;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.gui.ContainerEnergyBridge;

public class GuiEnergyBridge
extends GuiContainer {
    private static final int _barColor = -16734721;
    protected TileEntityEnergyBridge _bridge;

    public GuiEnergyBridge(ContainerEnergyBridge container, TileEntityEnergyBridge te) {
        super((Container)container);
        this.field_74195_c = 195;
        this._bridge = te;
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        this.field_73886_k.func_78276_b("Energy Bridge", 8, 6, 0x404040);
        if (this._bridge.isInputLimited()) {
            this.field_73886_k.func_78276_b("INPUT LIMITED", 98, 6, -1);
        } else {
            this.field_73886_k.func_78276_b("OUTPUT LIMITED", 90, 6, -1);
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            this.field_73886_k.func_78276_b(dir.toString(), 10, 6 + 12 * (i + 1), -1);
            BridgeSideData data = this._bridge.getDataForSide(dir);
            if ((data.isConsumer || data.isProducer) && data.powerSystem != null) {
                String name = data.powerSystem.getAbbreviation();
                if (data.powerSystem.getVoltageNames() != null) {
                    name = name + " " + data.powerSystem.getVoltageNames()[data.voltageNameIndex];
                }
                this.field_73886_k.func_78276_b(name, 49, 6 + 12 * (i + 1), -1);
                this.field_73886_k.func_78276_b(data.isConsumer ? "IN" : "OUT", 92, 6 + 12 * (i + 1), -1);
                this.field_73886_k.func_78276_b(this.getOutputRateString(data), 119, 6 + 12 * (i + 1), -1);
                continue;
            }
            this.field_73886_k.func_78276_b("<NONE>", 49, 6 + 12 * (i + 1), -1);
        }
        this.field_73886_k.func_78276_b("% CHG", 10, 90, -1);
        GL11.glDisable((int)2896);
        GuiEnergyBridge.func_73734_a((int)46, (int)97, (int)(46 + this._bridge.getEnergyScaled()), (int)89, (int)-16734721);
        GL11.glEnable((int)2896);
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_74195_c - 96 + 2, 0x404040);
    }

    protected void func_74185_a(float gameTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b("/powercrystals/powerconverters/textures/gui/energybridge.png");
        int x = (this.field_73880_f - this.field_74194_b) / 2;
        int y = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_74194_b, this.field_74195_c);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            BridgeSideData data = this._bridge.getDataForSide(dir);
            if ((data.isConsumer || data.isProducer) && data.powerSystem != null) {
                if (!data.isConnected) {
                    this.func_73729_b(x + 7, y + 15 + 12 * i, 0, 208, 162, 12);
                    continue;
                }
                if (data.outputRate == 0) {
                    this.func_73729_b(x + 7, y + 15 + 12 * i, 0, 234, 162, 12);
                    continue;
                }
                this.func_73729_b(x + 7, y + 15 + 12 * i, 0, 195, 162, 12);
                continue;
            }
            this.func_73729_b(x + 7, y + 15 + 12 * i, 0, 221, 162, 12);
        }
    }

    private String getOutputRateString(BridgeSideData data) {
        if (!data.isConnected) {
            return "NO LINK";
        }
        int rate = data.outputRate;
        if (rate > 1000) {
            double rateThousand = (double)rate / 1000.0;
            return String.format("%.1f %s%s", rateThousand, "k", data.powerSystem.getUnit());
        }
        return rate + " " + data.powerSystem.getUnit();
    }
}

