/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import buildcraft.transport.utils.BitSetCodec;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import net.minecraftforge.common.ForgeDirection;

public class ConnectionMatrix {
    private final BitSet _connected = new BitSet(ForgeDirection.VALID_DIRECTIONS.length);
    private final BitSetCodec _bitSetCodec = new BitSetCodec();
    private boolean dirty = false;

    public boolean isConnected(ForgeDirection direction) {
        return this._connected.get(direction.ordinal());
    }

    public void setConnected(ForgeDirection direction, boolean value) {
        if (this._connected.get(direction.ordinal()) != value) {
            this._connected.set(direction.ordinal(), value);
            this.dirty = true;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(DataOutputStream data) throws IOException {
        data.writeByte(this._bitSetCodec.encode(this._connected));
    }

    public void readData(DataInputStream data) throws IOException {
        this._bitSetCodec.decode(data.readByte(), this._connected);
    }
}

