/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.RedstonePowerFramework;
import buildcraft.core.inventory.InventoryWrapper;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsWood
extends Pipe
implements IPowerReceptor {
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    protected int standardIconIndex = 9;
    protected int solidIconIndex = 10;

    protected PipeItemsWood(PipeTransportItems transport, PipeLogic logic, int itemID) {
        super(transport, logic, itemID);
        this.powerProvider.configure(50, 1, 64, 1, 64);
        this.powerProvider.configurePowerPerdition(64, 1);
    }

    protected PipeItemsWood(int itemID, PipeTransportItems transport) {
        this(transport, (PipeLogic)new PipeLogicWood(), itemID);
    }

    public PipeItemsWood(int itemID) {
        this(itemID, new PipeTransportItems());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
        if (this.powerProvider.getEnergyStored() <= 0.0f) {
            return;
        }
        World w = this.worldObj;
        int meta = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (meta > 5) {
            return;
        }
        Position pos = new Position(this.xCoord, this.yCoord, this.zCoord, ForgeDirection.getOrientation((int)meta));
        pos.moveForwards(1.0);
        TileEntity tile = w.func_72796_p((int)pos.x, (int)pos.y, (int)pos.z);
        if (tile instanceof IInventory) {
            if (!PipeManager.canExtractItems(this, w, (int)pos.x, (int)pos.y, (int)pos.z)) {
                return;
            }
            IInventory inventory = (IInventory)tile;
            ItemStack[] extracted = this.checkExtract(inventory, true, pos.orientation.getOpposite());
            if (extracted == null) {
                return;
            }
            for (ItemStack stack : extracted) {
                if (stack == null || stack.field_77994_a == 0) {
                    this.powerProvider.useEnergy(1.0f, 1.0f, false);
                    continue;
                }
                Position entityPos = new Position(pos.x + 0.5, pos.y + 0.5, pos.z + 0.5, pos.orientation.getOpposite());
                entityPos.moveForwards(0.6);
                EntityPassiveItem entity = new EntityPassiveItem(w, entityPos.x, entityPos.y, entityPos.z, stack);
                ((PipeTransportItems)this.transport).entityEntering(entity, entityPos.orientation);
            }
        }
    }

    public ItemStack[] checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        if (inventory instanceof ISpecialInventory) {
            ItemStack[] stacks = ((ISpecialInventory)inventory).extractItem(doRemove, from, (int)this.powerProvider.getEnergyStored());
            if (stacks != null && doRemove) {
                for (ItemStack stack : stacks) {
                    if (stack == null) continue;
                    this.powerProvider.useEnergy(stack.field_77994_a, stack.field_77994_a, true);
                }
            }
            return stacks;
        }
        IInventory inv = Utils.getInventory(inventory);
        ItemStack result = this.checkExtractGeneric(inv, doRemove, from);
        if (result != null) {
            return new ItemStack[]{result};
        }
        return null;
    }

    public ItemStack checkExtractGeneric(IInventory inventory, boolean doRemove, ForgeDirection from) {
        return this.checkExtractGeneric(InventoryWrapper.getWrappedInventory(inventory), doRemove, from);
    }

    public ItemStack checkExtractGeneric(ISidedInventory inventory, boolean doRemove, ForgeDirection from) {
        for (int k : inventory.func_94128_d(from.ordinal())) {
            ItemStack slot = inventory.func_70301_a(k);
            if (slot == null || slot.field_77994_a <= 0 || !inventory.func_102008_b(k, slot, from.ordinal())) continue;
            if (doRemove) {
                return inventory.func_70298_a(k, (int)this.powerProvider.useEnergy(1.0f, slot.field_77994_a, true));
            }
            return slot;
        }
        return null;
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        return this.getPowerProvider().getMaxEnergyReceived();
    }

    @Override
    public boolean canConnectRedstone() {
        if (PowerFramework.currentFramework instanceof RedstonePowerFramework) {
            return true;
        }
        return super.canConnectRedstone();
    }
}

