/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.TileGenericPipe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;

public class PacketLiquidUpdate
extends PacketCoordinates {
    public LiquidStack[] renderCache = new LiquidStack[ForgeDirection.values().length];
    public BitSet delta;

    public PacketLiquidUpdate(int xCoord, int yCoord, int zCoord) {
        super(3, xCoord, yCoord, zCoord);
    }

    public PacketLiquidUpdate(int xCoord, int yCoord, int zCoord, boolean chunkPacket) {
        super(3, xCoord, yCoord, zCoord);
        this.isChunkDataPacket = chunkPacket;
    }

    public PacketLiquidUpdate() {
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        World world = CoreProxy.proxy.getClientWorld();
        if (!world.func_72899_e(this.posX, this.posY, this.posZ)) {
            return;
        }
        TileEntity entity = world.func_72796_p(this.posX, this.posY, this.posZ);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportLiquids)) {
            return;
        }
        PipeTransportLiquids transLiq = (PipeTransportLiquids)pipe.pipe.transport;
        this.renderCache = transLiq.renderCache;
        byte[] dBytes = new byte[3];
        data.read(dBytes);
        this.delta = PacketLiquidUpdate.fromByteArray(dBytes);
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (this.delta.get(dir.ordinal() * 3 + 0)) {
                int amt = this.renderCache[dir.ordinal()] != null ? this.renderCache[dir.ordinal()].amount : 0;
                this.renderCache[dir.ordinal()] = new LiquidStack((int)data.readShort(), amt, (int)data.readShort());
            }
            if (!this.delta.get(dir.ordinal() * 3 + 2)) continue;
            if (this.renderCache[dir.ordinal()] == null) {
                this.renderCache[dir.ordinal()] = new LiquidStack(0, 0);
            }
            this.renderCache[dir.ordinal()].amount = Math.min(transLiq.getCapacity(), data.readShort());
        }
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        byte[] dBytes = PacketLiquidUpdate.toByteArray(this.delta);
        data.write(dBytes);
        for (ForgeDirection dir : ForgeDirection.values()) {
            LiquidStack liquid = this.renderCache[dir.ordinal()];
            if (this.delta.get(dir.ordinal() * 3 + 0)) {
                if (liquid != null) {
                    data.writeShort(liquid.itemID);
                    data.writeShort(liquid.itemMeta);
                } else {
                    data.writeShort(0);
                    data.writeShort(0);
                }
            }
            if (!this.delta.get(dir.ordinal() * 3 + 2)) continue;
            if (liquid != null) {
                data.writeShort(liquid.amount);
                continue;
            }
            data.writeShort(0);
        }
    }

    public static BitSet fromByteArray(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static byte[] toByteArray(BitSet bits) {
        byte[] bytes = new byte[3];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    @Override
    public int getID() {
        return 3;
    }
}

