/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.core.TileBuildCraft;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.InventoryMapper;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.TransactorRoundRobin;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.CraftingHelper;
import buildcraft.core.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.ForgeDirection;

public class TileAutoWorkbench
extends TileBuildCraft
implements ISidedInventory {
    public static final int SLOT_RESULT = 0;
    public static final int CRAFT_TIME = 256;
    public static final int UPDATE_TIME = 16;
    private static final int[] SLOTS = Utils.createSlotArray(0, 5);
    private SimpleInventory inv = new SimpleInventory(5, "Auto Workbench", 64);
    private IInventory invBuffer = new InventoryMapper(this.inv, 1, 4);
    public InventoryCrafting craftMatrix = new LocalInventoryCrafting();
    public boolean useLast;
    private final TransactorRoundRobin transactor = new TransactorRoundRobin((IInventory)this.craftMatrix);
    private EntityPlayer internalPlayer;
    private SlotCrafting craftSlot;
    private InventoryCraftResult craftResult = new InventoryCraftResult();
    public int progress;
    private int update = Utils.RANDOM.nextInt();

    @Override
    public void destroy() {
        super.destroy();
        Utils.dropItems(this.field_70331_k, (IInventory)this.craftMatrix, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.inv.func_70298_a(slot, count);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_70303_b() {
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this && player.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.inv.readFromNBT(data);
        Utils.readInvFromNBT((IInventory)this.craftMatrix, "matrix", data);
        if (data.func_74764_b("stackList")) {
            ItemStack[] stacks = new ItemStack[9];
            Utils.readStacksFromNBT(data, "stackList", stacks);
            for (int i = 0; i < 9; ++i) {
                this.craftMatrix.func_70299_a(i, stacks[i]);
            }
        }
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.inv.writeToNBT(data);
        Utils.writeInvToNBT((IInventory)this.craftMatrix, "matrix", data);
    }

    public ItemStack findRecipeOutput() {
        IRecipe recipe = this.findRecipe();
        if (recipe == null) {
            return null;
        }
        ItemStack result = recipe.func_77572_b(this.craftMatrix);
        if (result != null) {
            result = result.func_77946_l();
        }
        return result;
    }

    public IRecipe findRecipe() {
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable((IInventory)this.craftMatrix, ForgeDirection.UP)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            if (!stack.func_77985_e()) {
                return null;
            }
            if (!stack.func_77973_b().func_77634_r()) continue;
            return null;
        }
        return CraftingHelper.findMatchingRecipe(this.craftMatrix, this.field_70331_k);
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        this.processHiddenBuffer();
        if (this.craftSlot == null) {
            this.internalPlayer = new InternalPlayer();
            this.craftSlot = new SlotCrafting(this.internalPlayer, (IInventory)this.craftMatrix, (IInventory)this.craftResult, 0, 0, 0);
        }
        if (this.inv.func_70301_a(0) != null) {
            return;
        }
        ++this.update;
        if (this.update % 16 == 0) {
            this.updateCrafting();
        }
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 256;
    }

    private void processHiddenBuffer() {
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable(this.invBuffer, ForgeDirection.UP)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            if (!this.gridHasRoomFor(stack)) {
                slot.setStackInSlot(null);
                Utils.dropItems(this.field_70331_k, stack, this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
                continue;
            }
            stack.field_77994_a -= this.transactor.add((ItemStack)stack, (ForgeDirection)ForgeDirection.DOWN, (boolean)true).field_77994_a;
            if (stack.field_77994_a > 0) continue;
            slot.setStackInSlot(null);
        }
    }

    private void updateCrafting() {
        IRecipe recipe = this.findRecipe();
        if (recipe == null) {
            this.progress = 0;
            return;
        }
        if (!this.useLast && this.isLast()) {
            this.progress = 0;
            return;
        }
        this.progress += 16;
        if (this.progress < 256) {
            return;
        }
        this.progress = 0;
        this.useLast = false;
        ItemStack result = recipe.func_77572_b(this.craftMatrix);
        if (result == null) {
            return;
        }
        result = result.func_77946_l();
        this.craftSlot.func_82870_a(this.internalPlayer, result);
        this.inv.func_70299_a(0, result);
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable((IInventory)this.internalPlayer.field_71071_by, ForgeDirection.UP)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            slot.setStackInSlot(null);
            Utils.dropItems(this.field_70331_k, stack, this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return false;
        }
        if (stack == null) {
            return false;
        }
        if (!stack.func_77985_e()) {
            return false;
        }
        if (stack.func_77973_b().func_77634_r()) {
            return false;
        }
        return this.gridHasRoomFor(stack);
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    private boolean gridHasRoomFor(ItemStack input) {
        int space = 0;
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable((IInventory)this.craftMatrix, ForgeDirection.UP)) {
            ItemStack stack = slot.getStackInSlot();
            if (!StackHelper.instance().canStacksMerge(stack, input)) continue;
            space += stack.func_77976_d() - stack.field_77994_a;
        }
        return space >= input.field_77994_a;
    }

    public boolean isLast() {
        int minStackSize = 64;
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable((IInventory)this.craftMatrix, ForgeDirection.UP)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || stack.field_77994_a >= minStackSize) continue;
            minStackSize = stack.field_77994_a;
        }
        return minStackSize <= 1;
    }

    private final class InternalPlayer
    extends EntityPlayer {
        public InternalPlayer() {
            super(TileAutoWorkbench.this.field_70331_k);
            this.field_70165_t = TileAutoWorkbench.this.field_70329_l;
            this.field_70163_u = TileAutoWorkbench.this.field_70330_m + 1;
            this.field_70161_v = TileAutoWorkbench.this.field_70327_n;
            this.field_71092_bJ = "[Buildcraft]";
        }

        public void func_70006_a(String var1) {
        }

        public boolean func_70003_b(int var1, String var2) {
            return false;
        }

        public ChunkCoordinates func_82114_b() {
            return null;
        }
    }

    private class LocalInventoryCrafting
    extends InventoryCrafting {
        public LocalInventoryCrafting() {
            super(new Container(){

                public boolean func_75145_c(EntityPlayer entityplayer) {
                    return false;
                }
            }, 3, 3);
        }
    }
}

