/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.core.DefaultProps;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.factory.BlockAutoWorkbench;
import buildcraft.factory.BlockFrame;
import buildcraft.factory.BlockHopper;
import buildcraft.factory.BlockMiningWell;
import buildcraft.factory.BlockPlainPipe;
import buildcraft.factory.BlockPump;
import buildcraft.factory.BlockQuarry;
import buildcraft.factory.BlockRefinery;
import buildcraft.factory.BlockTank;
import buildcraft.factory.BptBlockAutoWorkbench;
import buildcraft.factory.BptBlockFrame;
import buildcraft.factory.BptBlockRefinery;
import buildcraft.factory.BptBlockTank;
import buildcraft.factory.FactoryProxy;
import buildcraft.factory.FactoryProxyClient;
import buildcraft.factory.GuiHandler;
import buildcraft.factory.PumpDimensionList;
import buildcraft.factory.TileAutoWorkbench;
import buildcraft.factory.TileHopper;
import buildcraft.factory.TileMiningWell;
import buildcraft.factory.TilePump;
import buildcraft.factory.TileQuarry;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.TileTank;
import buildcraft.factory.network.PacketHandlerFactory;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;

@Mod(name="BuildCraft Factory", version="3.7.2", useMetadata=false, modid="BuildCraft|Factory", dependencies="required-after:BuildCraft|Core@3.7.2")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandlerFactory.class, clientSideRequired=true, serverSideRequired=true)
public class BuildCraftFactory {
    public static BlockQuarry quarryBlock;
    public static BlockMiningWell miningWellBlock;
    public static BlockAutoWorkbench autoWorkbenchBlock;
    public static BlockFrame frameBlock;
    public static BlockPlainPipe plainPipeBlock;
    public static BlockPump pumpBlock;
    public static BlockTank tankBlock;
    public static BlockRefinery refineryBlock;
    public static BlockHopper hopperBlock;
    public static boolean hopperDisabled;
    public static boolean allowMining;
    public static PumpDimensionList pumpDimensionList;
    @Mod.Instance(value="BuildCraft|Factory")
    public static BuildCraftFactory instance;

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent evt) {
        FactoryProxy.proxy.initializeNEIIntegration();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new QuarryChunkloadCallback());
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        CoreProxy.proxy.registerTileEntity(TileQuarry.class, "Machine");
        CoreProxy.proxy.registerTileEntity(TileMiningWell.class, "MiningWell");
        CoreProxy.proxy.registerTileEntity(TileAutoWorkbench.class, "AutoWorkbench");
        CoreProxy.proxy.registerTileEntity(TilePump.class, "net.minecraft.src.buildcraft.factory.TilePump");
        CoreProxy.proxy.registerTileEntity(TileTank.class, "net.minecraft.src.buildcraft.factory.TileTank");
        CoreProxy.proxy.registerTileEntity(TileRefinery.class, "net.minecraft.src.buildcraft.factory.Refinery");
        if (!hopperDisabled) {
            CoreProxy.proxy.registerTileEntity(TileHopper.class, "net.minecraft.src.buildcraft.factory.TileHopper");
        }
        FactoryProxy.proxy.initializeTileEntities();
        new BptBlockAutoWorkbench(BuildCraftFactory.autoWorkbenchBlock.field_71990_ca);
        new BptBlockFrame(BuildCraftFactory.frameBlock.field_71990_ca);
        new BptBlockRefinery(BuildCraftFactory.refineryBlock.field_71990_ca);
        new BptBlockTank(BuildCraftFactory.tankBlock.field_71990_ca);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftFactory.loadRecipes();
        }
    }

    @Mod.PreInit
    public void initialize(FMLPreInitializationEvent evt) {
        allowMining = BuildCraftCore.mainConfiguration.get("general", "mining.enabled", true).getBoolean(true);
        pumpDimensionList = new PumpDimensionList(BuildCraftCore.mainConfiguration.get("general", "pumping.controlList", DefaultProps.PUMP_DIMENSION_LIST).getString());
        Property miningWellId = BuildCraftCore.mainConfiguration.getBlock("miningWell.id", DefaultProps.MINING_WELL_ID);
        Property plainPipeId = BuildCraftCore.mainConfiguration.getBlock("drill.id", DefaultProps.DRILL_ID);
        Property autoWorkbenchId = BuildCraftCore.mainConfiguration.getBlock("autoWorkbench.id", DefaultProps.AUTO_WORKBENCH_ID);
        Property frameId = BuildCraftCore.mainConfiguration.getBlock("frame.id", DefaultProps.FRAME_ID);
        Property quarryId = BuildCraftCore.mainConfiguration.getBlock("quarry.id", DefaultProps.QUARRY_ID);
        Property pumpId = BuildCraftCore.mainConfiguration.getBlock("pump.id", DefaultProps.PUMP_ID);
        Property tankId = BuildCraftCore.mainConfiguration.getBlock("tank.id", DefaultProps.TANK_ID);
        Property refineryId = BuildCraftCore.mainConfiguration.getBlock("refinery.id", DefaultProps.REFINERY_ID);
        Property hopperId = BuildCraftCore.mainConfiguration.getBlock("hopper.id", DefaultProps.HOPPER_ID);
        Property hopperDisable = BuildCraftCore.mainConfiguration.get("Block Savers", "hopper.disabled", false);
        if (BuildCraftCore.mainConfiguration.hasChanged()) {
            BuildCraftCore.mainConfiguration.save();
        }
        miningWellBlock = new BlockMiningWell(miningWellId.getInt());
        CoreProxy.proxy.registerBlock(miningWellBlock.func_71864_b("miningWellBlock"));
        CoreProxy.proxy.addName((Object)miningWellBlock, "Mining Well");
        plainPipeBlock = new BlockPlainPipe(plainPipeId.getInt());
        CoreProxy.proxy.registerBlock(plainPipeBlock.func_71864_b("plainPipeBlock"));
        CoreProxy.proxy.addName(plainPipeBlock, "Mining Pipe");
        autoWorkbenchBlock = new BlockAutoWorkbench(autoWorkbenchId.getInt());
        CoreProxy.proxy.registerBlock(autoWorkbenchBlock.func_71864_b("autoWorkbenchBlock"));
        CoreProxy.proxy.addName((Object)autoWorkbenchBlock, "Automatic Crafting Table");
        frameBlock = new BlockFrame(frameId.getInt());
        CoreProxy.proxy.registerBlock(frameBlock.func_71864_b("frameBlock"));
        CoreProxy.proxy.addName(frameBlock, "Frame");
        quarryBlock = new BlockQuarry(quarryId.getInt());
        CoreProxy.proxy.registerBlock(quarryBlock.func_71864_b("machineBlock"));
        CoreProxy.proxy.addName((Object)quarryBlock, "Quarry");
        tankBlock = new BlockTank(tankId.getInt());
        CoreProxy.proxy.registerBlock(tankBlock.func_71864_b("tankBlock"));
        CoreProxy.proxy.addName((Object)tankBlock, "Tank");
        pumpBlock = new BlockPump(pumpId.getInt());
        CoreProxy.proxy.registerBlock(pumpBlock.func_71864_b("pumpBlock"));
        CoreProxy.proxy.addName((Object)pumpBlock, "Pump");
        refineryBlock = new BlockRefinery(refineryId.getInt());
        CoreProxy.proxy.registerBlock(refineryBlock.func_71864_b("refineryBlock"));
        CoreProxy.proxy.addName((Object)refineryBlock, "Refinery");
        hopperDisabled = hopperDisable.getBoolean(false);
        if (!hopperDisabled) {
            hopperBlock = new BlockHopper(hopperId.getInt());
            CoreProxy.proxy.registerBlock(hopperBlock.func_71864_b("blockHopper"));
            CoreProxy.proxy.addName((Object)hopperBlock, "Hopper");
        }
        FactoryProxy.proxy.initializeEntityRenders();
        if (BuildCraftCore.mainConfiguration.hasChanged()) {
            BuildCraftCore.mainConfiguration.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void loadRecipes() {
        if (allowMining) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)miningWellBlock, 1), new Object[]{"ipi", "igi", "iPi", Character.valueOf('p'), Item.field_77767_aC, Character.valueOf('i'), Item.field_77703_o, Character.valueOf('g'), BuildCraftCore.ironGearItem, Character.valueOf('P'), Item.field_77696_g});
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)quarryBlock), new Object[]{"ipi", "gig", "dDd", Character.valueOf('i'), BuildCraftCore.ironGearItem, Character.valueOf('p'), Item.field_77767_aC, Character.valueOf('g'), BuildCraftCore.goldGearItem, Character.valueOf('d'), BuildCraftCore.diamondGearItem, Character.valueOf('D'), Item.field_77674_B});
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)pumpBlock), new Object[]{"T ", "W ", Character.valueOf('T'), tankBlock, Character.valueOf('W'), miningWellBlock});
        } else {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)pumpBlock), new Object[]{"iri", "iTi", "gpg", Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('i'), Item.field_77703_o, Character.valueOf('T'), tankBlock, Character.valueOf('g'), BuildCraftCore.ironGearItem, Character.valueOf('p'), BuildCraftTransport.pipeLiquidsGold});
        }
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)autoWorkbenchBlock), new Object[]{" g ", "gwg", " g ", Character.valueOf('w'), Block.field_72060_ay, Character.valueOf('g'), BuildCraftCore.woodenGearItem});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)tankBlock), new Object[]{"ggg", "g g", "ggg", Character.valueOf('g'), Block.field_71946_M});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)refineryBlock), new Object[]{"   ", "RTR", "TGT", Character.valueOf('T'), tankBlock, Character.valueOf('G'), BuildCraftCore.diamondGearItem, Character.valueOf('R'), Block.field_72035_aQ});
        if (!hopperDisabled) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)hopperBlock), new Object[]{"ICI", "IGI", " I ", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('C'), Block.field_72077_au, Character.valueOf('G'), BuildCraftCore.stoneGearItem});
        }
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre evt) {
        if (evt.map == Minecraft.func_71410_x().field_71446_o.field_94154_l) {
            TextureMap terrainTextures = evt.map;
            FactoryProxyClient.pumpTexture = terrainTextures.func_94245_a("buildcraft:pump_tube");
            FactoryProxyClient.drillTexture = terrainTextures.func_94245_a("buildcraft:blockDrillTexture");
            FactoryProxyClient.drillHeadTexture = terrainTextures.func_94245_a("buildcraft:blockDrillHeadTexture");
        }
    }

    static {
        allowMining = true;
    }

    public class QuarryChunkloadCallback
    implements ForgeChunkManager.OrderedLoadingCallback {
        public void ticketsLoaded(List tickets, World world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int quarryX = ticket.getModData().func_74762_e("quarryX");
                int quarryY = ticket.getModData().func_74762_e("quarryY");
                int quarryZ = ticket.getModData().func_74762_e("quarryZ");
                TileQuarry tq = (TileQuarry)world.func_72796_p(quarryX, quarryY, quarryZ);
                tq.forceChunkLoading(ticket);
            }
        }

        public List ticketsLoaded(List tickets, World world, int maxTicketCount) {
            ArrayList validTickets = Lists.newArrayList();
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int quarryZ;
                int quarryY;
                int quarryX = ticket.getModData().func_74762_e("quarryX");
                int blId = world.func_72798_a(quarryX, quarryY = ticket.getModData().func_74762_e("quarryY"), quarryZ = ticket.getModData().func_74762_e("quarryZ"));
                if (blId != BuildCraftFactory.quarryBlock.field_71990_ca) continue;
                validTickets.add(ticket);
            }
            return validTickets;
        }
    }
}

