/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXDatagramSocket;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.RAFChannelProvider;

public final class FileDescriptorCast {
    private final FileDescriptor fdObj;
    private int localPort = 0;
    private int remotePort = 0;
    private static final CastingProviderMap GLOBAL_PROVIDERS_FINAL = new CastingProviderMap(){

        @Override
        protected void addProviders() {
            this.addProvider(FileDescriptor.class, new CastingProvider(){

                @Override
                public FileDescriptor provideAs(FileDescriptorCast fdc, Class desiredType) throws IOException {
                    return fdc.getFileDescriptor();
                }
            });
        }
    };
    private static final CastingProviderMap GLOBAL_PROVIDERS = new CastingProviderMap(){

        @Override
        protected void addProviders() {
            this.addProvider(WritableByteChannel.class, new CastingProvider(){

                @Override
                public WritableByteChannel provideAs(FileDescriptorCast fdc, Class desiredType) throws IOException {
                    return new FileOutputStream(fdc.getFileDescriptor()).getChannel();
                }
            });
            this.addProvider(ReadableByteChannel.class, new CastingProvider(){

                @Override
                public ReadableByteChannel provideAs(FileDescriptorCast fdc, Class desiredType) throws IOException {
                    return new FileInputStream(fdc.getFileDescriptor()).getChannel();
                }
            });
            this.addProvider(FileChannel.class, new CastingProvider(){

                @Override
                public FileChannel provideAs(FileDescriptorCast fdc, Class desiredType) throws IOException {
                    return RAFChannelProvider.getFileChannel(fdc.getFileDescriptor());
                }
            });
            this.addProvider(FileOutputStream.class, new CastingProvider(){

                @Override
                public FileOutputStream provideAs(FileDescriptorCast fdc, Class desiredType) throws IOException {
                    return new FileOutputStream(fdc.getFileDescriptor());
                }
            });
            this.addProvider(FileInputStream.class, new CastingProvider(){

                @Override
                public FileInputStream provideAs(FileDescriptorCast fdc, Class desiredType) throws IOException {
                    return new FileInputStream(fdc.getFileDescriptor());
                }
            });
        }
    };
    private static final Map PRIMARY_TYPE_PROVIDERS_MAP = new HashMap();
    private final CastingProviderMap cpm;

    private FileDescriptorCast(FileDescriptor fdObj, CastingProviderMap cpm) {
        this.fdObj = Objects.requireNonNull(fdObj);
        this.cpm = Objects.requireNonNull(cpm);
    }

    private static void registerCastingProviders(Class primaryType, CastingProviderMap cpm) {
        PRIMARY_TYPE_PROVIDERS_MAP.put(primaryType, cpm);
    }

    public static FileDescriptorCast using(FileDescriptor fdObj) throws IOException {
        if (!fdObj.valid()) {
            throw new IOException("Not a valid file descriptor");
        }
        Class primaryType = NativeUnixSocket.primaryType(fdObj);
        if (primaryType == null) {
            throw new IOException("Unsupported file descriptor");
        }
        CastingProviderMap map = (CastingProviderMap)PRIMARY_TYPE_PROVIDERS_MAP.get(primaryType);
        return new FileDescriptorCast(fdObj, map == null ? GLOBAL_PROVIDERS : map);
    }

    public FileDescriptorCast withLocalPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException();
        }
        this.localPort = port;
        return this;
    }

    public FileDescriptorCast withRemotePort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException();
        }
        this.remotePort = port;
        return this;
    }

    @NonNull
    public Object as(Class desiredType) throws IOException {
        Objects.requireNonNull(desiredType);
        CastingProvider provider = this.cpm.get(desiredType);
        if (provider != null) {
            Object obj = desiredType.cast(provider.provideAs(this, desiredType));
            Objects.requireNonNull(obj);
            return obj;
        }
        throw new ClassCastException("Cannot access file descriptor as " + desiredType);
    }

    public boolean isAvailable(Class desiredType) throws IOException {
        return this.cpm.providers.containsKey(desiredType);
    }

    public Set availableTypes() {
        return this.cpm.classes;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public FileDescriptor getFileDescriptor() {
        return this.fdObj;
    }

    static {
        FileDescriptorCast.registerCastingProviders(AFUNIXSocket.class, new CastingProviderMap(){

            @Override
            protected void addProviders() {
                this.addProviders(GLOBAL_PROVIDERS);
                final CastingProvider cpSocket = new CastingProvider(){

                    @Override
                    public AFUNIXSocket provideAs(FileDescriptorCast fdc, Class desiredType) throws IOException {
                        return AFUNIXSocket.newInstance(fdc.getFileDescriptor(), fdc.localPort, fdc.remotePort);
                    }
                };
                final CastingProvider cpServerSocket = new CastingProvider(){

                    @Override
                    public AFUNIXServerSocket provideAs(FileDescriptorCast fdc, Class desiredType) throws IOException {
                        return AFUNIXServerSocket.newInstance(fdc.getFileDescriptor(), fdc.localPort, fdc.remotePort);
                    }
                };
                this.addProvider(AFUNIXSocketChannel.class, new CastingProvider(){

                    @Override
                    public AFUNIXSocketChannel provideAs(FileDescriptorCast fdc, Class desiredType) throws IOException {
                        return ((AFUNIXSocket)cpSocket.provideAs(fdc, AFUNIXSocket.class)).getChannel();
                    }
                });
                this.addProvider(AFUNIXServerSocketChannel.class, new CastingProvider(){

                    @Override
                    public AFUNIXServerSocketChannel provideAs(FileDescriptorCast fdc, Class desiredType) throws IOException {
                        return ((AFUNIXServerSocket)cpServerSocket.provideAs(fdc, AFUNIXServerSocket.class)).getChannel();
                    }
                });
                this.addProvider(AFUNIXSocket.class, cpSocket);
                this.addProvider(AFUNIXServerSocket.class, cpServerSocket);
            }
        });
        FileDescriptorCast.registerCastingProviders(AFUNIXDatagramSocket.class, new CastingProviderMap(){

            @Override
            protected void addProviders() {
                this.addProviders(GLOBAL_PROVIDERS);
                final CastingProvider cpDatagramSocket = new CastingProvider(){

                    @Override
                    public AFUNIXDatagramSocket provideAs(FileDescriptorCast fdc, Class desiredType) throws IOException {
                        return AFUNIXDatagramSocket.newInstance(fdc.getFileDescriptor(), fdc.localPort, fdc.remotePort);
                    }
                };
                this.addProvider(AFUNIXDatagramChannel.class, new CastingProvider(){

                    @Override
                    public AFUNIXDatagramChannel provideAs(FileDescriptorCast fdc, Class desiredType) throws IOException {
                        return ((AFUNIXDatagramSocket)cpDatagramSocket.provideAs(fdc, AFUNIXDatagramSocket.class)).getChannel();
                    }
                });
                this.addProvider(AFUNIXDatagramSocket.class, cpDatagramSocket);
            }
        });
    }

    private static interface CastingProvider {
        public Object provideAs(FileDescriptorCast var1, Class var2) throws IOException;
    }

    private static abstract class CastingProviderMap {
        private final Map providers = new HashMap();
        private final Set classes = Collections.unmodifiableSet(this.providers.keySet());

        protected CastingProviderMap() {
            this.addProviders();
            this.addProviders(GLOBAL_PROVIDERS_FINAL);
        }

        protected abstract void addProviders();

        protected final void addProvider(Class type, CastingProvider cp) {
            Objects.requireNonNull(type);
            this.addProvider0(type, cp);
        }

        private void addProvider0(Class type, CastingProvider cp) {
            if (this.providers.put(type, cp) != cp) {
                for (Class<?> cl : type.getInterfaces()) {
                    this.addProvider0(cl, cp);
                }
                Class scl = type.getSuperclass();
                if (scl != null) {
                    this.addProvider0(scl, cp);
                }
            }
        }

        protected final void addProviders(CastingProviderMap other) {
            if (other == null || other == this) {
                return;
            }
            this.providers.putAll(other.providers);
        }

        public CastingProvider get(Class desiredType) {
            return (CastingProvider)this.providers.get(desiredType);
        }
    }
}

