/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.newsclub.net.unix.AFUNIXCore;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AncillaryDataSupport;
import org.newsclub.net.unix.NativeUnixSocket;

class AFUNIXSocketCore
extends AFUNIXCore {
    private static final int SHUT_RD_WR = 2;
    protected final AtomicLong inode = new AtomicLong(-1L);
    protected AFUNIXSocketAddress socketAddress;

    protected AFUNIXSocketCore(Object observed, FileDescriptor fd, AncillaryDataSupport ancillaryDataSupport) {
        super(observed, fd, ancillaryDataSupport);
    }

    @Override
    protected void doClose() throws IOException {
        NativeUnixSocket.shutdown(this.fd, 2);
        this.unblockAccepts();
        super.doClose();
    }

    protected void unblockAccepts() {
    }

    AFUNIXSocketAddress receive(ByteBuffer dst) throws IOException {
        ByteBuffer socketAddressBuffer = (ByteBuffer)AFUNIXSocketAddress.SOCKETADDRESS_BUFFER_TL.get();
        int read = this.read(dst, socketAddressBuffer, 0);
        if (read > 0) {
            return AFUNIXSocketAddress.ofInternal(socketAddressBuffer);
        }
        return null;
    }

    boolean isConnected(boolean boundOk) {
        try {
            if (this.fd.valid()) {
                switch (NativeUnixSocket.socketStatus(this.fd)) {
                    case 2: {
                        return true;
                    }
                    case 1: {
                        if (!boundOk) break;
                        return true;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return false;
    }
}

