/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.newsclub.net.unix.AFUNIXInetAddress;
import org.newsclub.net.unix.AFUNIXSocketFactory;
import org.newsclub.net.unix.NativeUnixSocket;

public final class AFUNIXSocketAddress
extends InetSocketAddress {
    private static final long serialVersionUID = 1L;
    private static final int SOCKADDR_UN_LENGTH = NativeUnixSocket.sockAddrUnLength();
    private static final Map ADDRESS_CACHE = new HashMap();
    private static final Charset ADDRESS_CHARSET = Charset.defaultCharset();
    private final byte[] bytes;
    private InetAddress inetAddress = null;
    static final ThreadLocal SOCKETADDRESS_BUFFER_TL = new ThreadLocal(){

        protected ByteBuffer initialValue() {
            return AFUNIXSocketAddress.newSockAddrUnDirectBuffer();
        }
    };
    static final AFUNIXSocketAddress INTERNAL_DUMMY_BIND = new AFUNIXSocketAddress(0);
    static final AFUNIXSocketAddress INTERNAL_DUMMY_CONNECT = new AFUNIXSocketAddress(1);
    static final AFUNIXSocketAddress INTERNAL_DUMMY_DONT_CONNECT = new AFUNIXSocketAddress(2);

    public AFUNIXSocketAddress(File socketFile) throws SocketException {
        this(socketFile, 0);
    }

    public AFUNIXSocketAddress(File socketFile, int port) throws SocketException {
        this(socketFile.getPath().getBytes(ADDRESS_CHARSET), port);
    }

    public AFUNIXSocketAddress(byte[] socketAddress) throws SocketException {
        this(socketAddress, 0);
    }

    public AFUNIXSocketAddress(byte[] socketAddress, int port) throws SocketException {
        this(port, socketAddress);
    }

    private AFUNIXSocketAddress(int port, byte[] socketAddress) throws SocketException {
        super(AFUNIXInetAddress.createUnresolvedHostname(socketAddress), 0);
        if (port < -1) {
            throw new IllegalArgumentException("port out of range");
        }
        if (port > 0) {
            NativeUnixSocket.setPort1(this, port);
        }
        if (socketAddress.length == 0) {
            throw new SocketException("Illegal address length: " + socketAddress.length);
        }
        this.bytes = (byte[])socketAddress.clone();
    }

    private AFUNIXSocketAddress(int port) {
        super(InetAddress.getLoopbackAddress(), port);
        this.bytes = new byte[0];
    }

    public static AFUNIXSocketAddress of(File socketFile) throws SocketException {
        return AFUNIXSocketAddress.of(socketFile, 0);
    }

    public static AFUNIXSocketAddress of(File socketFile, int port) throws SocketException {
        return AFUNIXSocketAddress.of(socketFile.getPath().getBytes(ADDRESS_CHARSET), port);
    }

    public static AFUNIXSocketAddress of(byte[] socketAddress) throws SocketException {
        return AFUNIXSocketAddress.of(socketAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AFUNIXSocketAddress of(byte[] socketAddress, int port) throws SocketException {
        if (port == -1) {
            port = 0;
        }
        if (port != 0) {
            return new AFUNIXSocketAddress(port, socketAddress);
        }
        Class<AFUNIXSocketAddress> clazz = AFUNIXSocketAddress.class;
        synchronized (AFUNIXSocketAddress.class) {
            ByteBuffer direct = (ByteBuffer)SOCKETADDRESS_BUFFER_TL.get();
            NativeUnixSocket.bytesToSockAddrUn(direct, socketAddress);
            direct.rewind();
            direct.limit(SOCKADDR_UN_LENGTH);
            AFUNIXSocketAddress instance = (AFUNIXSocketAddress)ADDRESS_CACHE.get(direct);
            if (instance == null) {
                instance = new AFUNIXSocketAddress(port, socketAddress);
                ByteBuffer key = AFUNIXSocketAddress.newSockAddrUnKeyBuffer();
                key.put(direct);
                ADDRESS_CACHE.put(key, instance);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return instance;
        }
    }

    public static AFUNIXSocketAddress of(Path socketPath) throws SocketException {
        return AFUNIXSocketAddress.of(socketPath, 0);
    }

    public static AFUNIXSocketAddress of(Path socketPath, int port) throws SocketException {
        return AFUNIXSocketAddress.of(socketPath.toString().getBytes(ADDRESS_CHARSET), port);
    }

    public static AFUNIXSocketAddress ofNewTempFile() throws IOException {
        return AFUNIXSocketAddress.ofNewTempPath(0);
    }

    public static AFUNIXSocketAddress ofNewTempPath(int port) throws IOException {
        return AFUNIXSocketAddress.of(AFUNIXSocketAddress.newTempPath(true), port);
    }

    static File newTempPath(boolean deleteOnExit) throws IOException {
        File f = File.createTempFile("jux", ".sock");
        if (deleteOnExit) {
            f.deleteOnExit();
        }
        if (!f.delete() && f.exists()) {
            throw new IOException("Could not delete temporary file that we just created: " + f);
        }
        return f;
    }

    public static AFUNIXSocketAddress unwrap(InetAddress address, int port) throws SocketException {
        Objects.requireNonNull(address);
        return new AFUNIXSocketAddress(port, AFUNIXInetAddress.unwrapAddress(address));
    }

    public static AFUNIXSocketAddress unwrap(SocketAddress address) throws SocketException {
        Objects.requireNonNull(address);
        if (!AFUNIXSocketAddress.isSupportedAddress(address)) {
            throw new SocketException("Unsupported address");
        }
        return (AFUNIXSocketAddress)address;
    }

    static byte[] unwrapAddress(SocketAddress address) throws SocketException {
        Objects.requireNonNull(address);
        if (!AFUNIXSocketAddress.isSupportedAddress(address)) {
            throw new SocketException("Unsupported address");
        }
        return ((AFUNIXSocketAddress)address).getBytes();
    }

    static void unwrapAddressDirectBufferInternal(ByteBuffer socketAddressBuffer, SocketAddress address) throws SocketException {
        byte[] addr = AFUNIXSocketAddress.unwrapAddress(address);
        NativeUnixSocket.bytesToSockAddrUn(socketAddressBuffer, addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AFUNIXSocketAddress ofInternal(ByteBuffer socketAddressBuffer) throws SocketException {
        Class<AFUNIXSocketAddress> clazz = AFUNIXSocketAddress.class;
        synchronized (AFUNIXSocketAddress.class) {
            AFUNIXSocketAddress address = (AFUNIXSocketAddress)ADDRESS_CACHE.get(socketAddressBuffer);
            if (address != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return address;
            }
            byte[] sockAddrUnToBytes = NativeUnixSocket.sockAddrUnToBytes(socketAddressBuffer);
            if (sockAddrUnToBytes == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return AFUNIXSocketAddress.of(sockAddrUnToBytes);
        }
    }

    public InetAddress wrapAddress() {
        return AFUNIXInetAddress.wrapAddress(this.bytes);
    }

    public static AFUNIXSocketAddress inAbstractNamespace(String name) throws SocketException {
        return AFUNIXSocketAddress.inAbstractNamespace(name, 0);
    }

    public static AFUNIXSocketAddress inAbstractNamespace(String name, int port) throws SocketException {
        byte[] bytes = name.getBytes(ADDRESS_CHARSET);
        byte[] addr = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, addr, 1, bytes.length);
        return new AFUNIXSocketAddress(addr, port);
    }

    byte[] getBytes() {
        return this.bytes;
    }

    private static String prettyPrint(byte[] data) {
        int dataLength = data.length;
        if (dataLength == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(dataLength + 16);
        for (int i = 0; i < dataLength; ++i) {
            byte c = data[i];
            if (c >= 32 && c < 127) {
                sb.append((char)c);
                continue;
            }
            sb.append("\\x");
            sb.append(String.format(Locale.ENGLISH, "%02x", c));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        int port = this.getPort();
        return this.getClass().getName() + "[" + (port == 0 ? "" : "port=" + port + ";") + "path=" + AFUNIXSocketAddress.prettyPrint(this.bytes) + "]";
    }

    public String getPath() {
        if (this.bytes.length == 0) {
            return "";
        }
        if (this.bytes[0] != 0) {
            return new String(this.bytes, ADDRESS_CHARSET);
        }
        byte[] by = (byte[])this.bytes.clone();
        for (int i = 0; i < by.length; ++i) {
            byte b = by[i];
            if (b == 0) {
                by[i] = 64;
                continue;
            }
            if (b >= 32 && b < 127) continue;
            by[i] = 46;
        }
        return new String(by, StandardCharsets.US_ASCII);
    }

    public static Charset addressCharset() {
        return ADDRESS_CHARSET;
    }

    public byte[] getPathAsBytes() {
        return (byte[])this.bytes.clone();
    }

    public boolean isInAbstractNamespace() {
        return this.bytes.length > 0 && this.bytes[0] == 0;
    }

    public boolean hasFilename() {
        return this.bytes.length > 0 && this.bytes[0] != 0;
    }

    public File getFile() throws FileNotFoundException {
        if (this.isInAbstractNamespace()) {
            throw new FileNotFoundException("Socket is in abstract namespace");
        }
        if (this.bytes.length == 0) {
            throw new FileNotFoundException("No name");
        }
        return new File(new String(this.bytes, ADDRESS_CHARSET));
    }

    static AFUNIXSocketAddress preprocessSocketAddress(SocketAddress endpoint, AFUNIXSocketFactory socketFactory) throws SocketException {
        InetSocketAddress isa;
        String hostname;
        if (!(endpoint instanceof AFUNIXSocketAddress) && socketFactory != null && endpoint instanceof InetSocketAddress && socketFactory.isHostnameSupported(hostname = (isa = (InetSocketAddress)endpoint).getHostString())) {
            endpoint = socketFactory.addressFromHost(hostname, isa.getPort());
        }
        if (!(endpoint instanceof AFUNIXSocketAddress)) {
            throw new IllegalArgumentException("Can only connect to endpoints of type " + AFUNIXSocketAddress.class.getName() + ", got: " + endpoint);
        }
        return (AFUNIXSocketAddress)endpoint;
    }

    public static boolean isSupportedAddress(InetAddress addr) {
        return AFUNIXInetAddress.isSupportedAddress(addr);
    }

    public static boolean isSupportedAddress(SocketAddress addr) {
        return addr instanceof AFUNIXSocketAddress;
    }

    static InetAddress getInetAddress(FileDescriptor fdesc, boolean peerName) {
        if (!fdesc.valid()) {
            return null;
        }
        byte[] addr = NativeUnixSocket.sockname(fdesc, peerName);
        if (addr == null) {
            return null;
        }
        return AFUNIXInetAddress.wrapAddress(addr);
    }

    static AFUNIXSocketAddress getSocketAddress(FileDescriptor fdesc, boolean peerName) {
        return AFUNIXSocketAddress.getSocketAddress(fdesc, peerName, 0);
    }

    static AFUNIXSocketAddress getSocketAddress(FileDescriptor fdesc, boolean peerName, int port) {
        if (!fdesc.valid()) {
            return null;
        }
        byte[] addr = NativeUnixSocket.sockname(fdesc, peerName);
        if (addr == null) {
            return null;
        }
        try {
            return AFUNIXSocketAddress.unwrap(AFUNIXInetAddress.wrapAddress(addr), port);
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
    }

    static ByteBuffer newSockAddrUnDirectBuffer() {
        return ByteBuffer.allocateDirect(SOCKADDR_UN_LENGTH);
    }

    static ByteBuffer newSockAddrUnKeyBuffer() {
        return ByteBuffer.allocate(SOCKADDR_UN_LENGTH);
    }

    synchronized InetAddress getInetAddress() {
        if (this.inetAddress == null) {
            this.inetAddress = AFUNIXInetAddress.wrapAddress(this.bytes);
        }
        return this.inetAddress;
    }
}

