/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCapability;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.AFUNIXSocketExtensions;
import org.newsclub.net.unix.AFUNIXSocketFactory;
import org.newsclub.net.unix.AFUNIXSocketImpl;
import org.newsclub.net.unix.AFUNIXSomeSocket;
import org.newsclub.net.unix.Closeables;
import org.newsclub.net.unix.NativeLibraryLoader;
import org.newsclub.net.unix.NativeUnixSocket;

public final class AFUNIXSocket
extends Socket
implements AFUNIXSomeSocket,
AFUNIXSocketExtensions {
    static String loadedLibrary;
    private static Integer capabilities;
    private AFUNIXSocketImpl impl;
    private final AFUNIXSocketFactory socketFactory;
    private final Closeables closeables = new Closeables();
    private final AtomicBoolean created = new AtomicBoolean(false);
    private final AFUNIXSocketChannel channel = new AFUNIXSocketChannel(this);

    private AFUNIXSocket(AFUNIXSocketImpl impl, AFUNIXSocketFactory factory) throws SocketException {
        super(impl);
        this.socketFactory = factory;
    }

    public static AFUNIXSocket newInstance() throws IOException {
        return AFUNIXSocket.newInstance0(null, null);
    }

    static AFUNIXSocket newInstance(FileDescriptor fdObj, int localPort, int remotePort) throws IOException {
        if (!fdObj.valid()) {
            throw new SocketException("Invalid file descriptor");
        }
        int status = NativeUnixSocket.socketStatus(fdObj);
        if (status == -1) {
            throw new SocketException("Not a valid socket");
        }
        AFUNIXSocket socket = AFUNIXSocket.newInstance0(fdObj, null);
        socket.getAFImpl().updatePorts(localPort, remotePort);
        switch (status) {
            case 2: {
                socket.internalDummyConnect();
                break;
            }
            case 1: {
                socket.internalDummyBind();
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Invalid socketStatus response: " + status);
            }
        }
        socket.getAFImpl().setSocketAddress(socket.getLocalSocketAddress());
        return socket;
    }

    static AFUNIXSocket newInstance(AFUNIXSocketFactory factory) throws SocketException {
        return AFUNIXSocket.newInstance0(null, factory);
    }

    private static AFUNIXSocket newInstance0(FileDescriptor fdObj, AFUNIXSocketFactory factory) throws SocketException {
        AFUNIXSocketImpl.Lenient impl = new AFUNIXSocketImpl.Lenient(fdObj);
        AFUNIXSocket instance = new AFUNIXSocket(impl, factory);
        instance.impl = impl;
        return instance;
    }

    public static AFUNIXSocket newStrictInstance() throws IOException {
        AFUNIXSocketImpl impl = new AFUNIXSocketImpl();
        AFUNIXSocket instance = new AFUNIXSocket(impl, null);
        instance.impl = impl;
        return instance;
    }

    public static AFUNIXSocket connectTo(AFUNIXSocketAddress addr) throws IOException {
        AFUNIXSocket socket = AFUNIXSocket.newInstance();
        socket.connect(addr);
        return socket;
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        AFUNIXSocketAddress.preprocessSocketAddress(bindpoint, this.socketFactory);
        throw new SocketException("Use AFUNIXServerSocket#bind or #bindOn");
    }

    @Override
    public boolean isBound() {
        return super.isBound() || this.impl.isBound();
    }

    @Override
    public boolean isConnected() {
        return super.isConnected() || this.impl.isConnected();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.connect0(endpoint, timeout);
    }

    boolean connect0(SocketAddress endpoint, int timeout) throws IOException {
        int port;
        boolean success;
        if (endpoint == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        AFUNIXSocketAddress address = AFUNIXSocketAddress.preprocessSocketAddress(endpoint, this.socketFactory);
        if (!this.isBound()) {
            this.internalDummyBind();
        }
        if ((success = this.getAFImpl().connect0(address, timeout)) && (port = address.getPort()) > 0) {
            this.getAFImpl().updatePorts(this.getLocalPort(), port);
        }
        this.internalDummyConnect();
        return success;
    }

    void internalDummyConnect() throws IOException {
        if (!this.isConnected()) {
            super.connect(AFUNIXSocketAddress.INTERNAL_DUMMY_CONNECT, 0);
        }
    }

    void internalDummyBind() throws IOException {
        if (!this.isBound()) {
            super.bind(AFUNIXSocketAddress.INTERNAL_DUMMY_BIND);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + this.toStringSuffix();
    }

    String toStringSuffix() {
        if (this.impl.getFD().valid()) {
            return "[local=" + this.getLocalSocketAddress() + ";remote=" + this.getRemoteSocketAddress() + "]";
        }
        return "[invalid]";
    }

    public static boolean isSupported() {
        return NativeUnixSocket.isLoaded();
    }

    public static String getVersion() {
        try {
            return NativeLibraryLoader.getJunixsocketVersion();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getLoadedLibrary() {
        return loadedLibrary;
    }

    @Override
    public AFUNIXSocketCredentials getPeerCredentials() throws IOException {
        if (this.isClosed() || !this.isConnected()) {
            throw new SocketException("Not connected");
        }
        return this.impl.getPeerCredentials();
    }

    @Override
    public boolean isClosed() {
        return super.isClosed() || this.isConnected() && !this.impl.getFD().valid();
    }

    @Override
    public int getAncillaryReceiveBufferSize() {
        return this.impl.getAncillaryReceiveBufferSize();
    }

    @Override
    public void setAncillaryReceiveBufferSize(int size) {
        this.impl.setAncillaryReceiveBufferSize(size);
    }

    @Override
    public void ensureAncillaryReceiveBufferSize(int minSize) {
        this.impl.ensureAncillaryReceiveBufferSize(minSize);
    }

    @Override
    public FileDescriptor[] getReceivedFileDescriptors() throws IOException {
        return this.impl.getReceivedFileDescriptors();
    }

    @Override
    public void clearReceivedFileDescriptors() {
        this.impl.clearReceivedFileDescriptors();
    }

    @Override
    public void setOutboundFileDescriptors(FileDescriptor ... fdescs) throws IOException {
        if (fdescs != null && fdescs.length > 0 && !this.isConnected()) {
            throw new SocketException("Not connected");
        }
        this.impl.setOutboundFileDescriptors(fdescs);
    }

    @Override
    public boolean hasOutboundFileDescriptors() {
        return this.impl.hasOutboundFileDescriptors();
    }

    private static synchronized int getCapabilities() {
        if (capabilities == null) {
            capabilities = !AFUNIXSocket.isSupported() ? Integer.valueOf(0) : Integer.valueOf(NativeUnixSocket.capabilities());
        }
        return capabilities;
    }

    public static boolean supports(AFUNIXSocketCapability capability) {
        return (AFUNIXSocket.getCapabilities() & capability.getBitmask()) != 0;
    }

    @Override
    public synchronized void close() throws IOException {
        IOException superException = null;
        try {
            super.close();
        }
        catch (IOException e) {
            superException = e;
        }
        this.closeables.close(superException);
    }

    public void addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    public void removeCloseable(Closeable closeable) {
        this.closeables.remove(closeable);
    }

    public static void main(String[] args) {
        System.out.print(AFUNIXSocket.class.getName() + ".isSupported(): ");
        System.out.flush();
        System.out.println(AFUNIXSocket.isSupported());
        for (AFUNIXSocketCapability cap : AFUNIXSocketCapability.values()) {
            System.out.print((Object)((Object)cap) + ": ");
            System.out.flush();
            System.out.println(AFUNIXSocket.supports(cap));
        }
    }

    AFUNIXSocketImpl getAFImpl() {
        if (this.created.compareAndSet(false, true)) {
            try {
                this.getSoTimeout();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return this.impl;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AFUNIXSocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public synchronized AFUNIXSocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return this.impl.getRemoteSocketAddress();
    }

    @Override
    public AFUNIXSocketAddress getLocalSocketAddress() {
        if (this.isClosed()) {
            return null;
        }
        return this.impl.getLocalSocketAddress();
    }

    @Override
    public FileDescriptor getFileDescriptor() throws IOException {
        return this.impl.getFileDescriptor();
    }

    static {
        capabilities = null;
    }
}

