/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXDatagramSocket;
import org.newsclub.net.unix.AFUNIXPipe;
import org.newsclub.net.unix.AFUNIXProtocolFamily;
import org.newsclub.net.unix.AFUNIXSelector;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketPair;
import org.newsclub.net.unix.NativeUnixSocket;

public final class AFUNIXSelectorProvider
extends SelectorProvider {
    private static final AFUNIXSelectorProvider INSTANCE = new AFUNIXSelectorProvider();

    private AFUNIXSelectorProvider() {
    }

    public static AFUNIXSelectorProvider getInstance() {
        return INSTANCE;
    }

    public static AFUNIXSelectorProvider provider() {
        return AFUNIXSelectorProvider.getInstance();
    }

    public AFUNIXSocketPair openSocketChannelPair() throws IOException {
        AFUNIXSocketChannel s1 = this.openSocketChannel();
        AFUNIXSocketChannel s2 = this.openSocketChannel();
        NativeUnixSocket.socketPair(1, s1.getAFCore().fd, s2.getAFCore().fd);
        s1.socket().internalDummyConnect();
        s2.socket().internalDummyConnect();
        return new AFUNIXSocketPair(s1, s2);
    }

    public AFUNIXSocketPair openDatagramChannelPair() throws IOException {
        AFUNIXDatagramChannel s1 = this.openDatagramChannel(AFUNIXProtocolFamily.UNIX);
        AFUNIXDatagramChannel s2 = this.openDatagramChannel(AFUNIXProtocolFamily.UNIX);
        NativeUnixSocket.socketPair(1, s1.getAFCore().fd, s2.getAFCore().fd);
        s1.socket().internalDummyBind();
        s2.socket().internalDummyBind();
        s1.socket().internalDummyConnect();
        s2.socket().internalDummyConnect();
        return new AFUNIXSocketPair(s1, s2);
    }

    @Override
    public AFUNIXDatagramChannel openDatagramChannel() throws IOException {
        return AFUNIXDatagramSocket.newInstance().getChannel();
    }

    @Override
    public AFUNIXDatagramChannel openDatagramChannel(ProtocolFamily family) throws IOException {
        if (!AFUNIXProtocolFamily.UNIX.name().equals(family.name())) {
            throw new UnsupportedOperationException("Unsupported protocol family");
        }
        return this.openDatagramChannel();
    }

    @Override
    public AFUNIXPipe openPipe() throws IOException {
        return new AFUNIXPipe(this, false);
    }

    public AFUNIXPipe openSelectablePipe() throws IOException {
        return new AFUNIXPipe(this, true);
    }

    @Override
    public AbstractSelector openSelector() throws IOException {
        return new AFUNIXSelector(this);
    }

    @Override
    public AFUNIXServerSocketChannel openServerSocketChannel() throws IOException {
        return AFUNIXServerSocket.newInstance().getChannel();
    }

    public AFUNIXServerSocketChannel openServerSocketChannel(SocketAddress sa) throws IOException {
        return AFUNIXServerSocket.bindOn(AFUNIXSocketAddress.unwrap(sa)).getChannel();
    }

    @Override
    public AFUNIXSocketChannel openSocketChannel() throws IOException {
        return AFUNIXSocket.newInstance().getChannel();
    }

    public AFUNIXSocketChannel openSocketChannel(SocketAddress sa) throws IOException {
        return AFUNIXSocket.connectTo(AFUNIXSocketAddress.unwrap(sa)).getChannel();
    }
}

