/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.newsclub.net.unix.AFUNIXPipe;
import org.newsclub.net.unix.AFUNIXSelectionKey;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.NativeUnixSocket;

final class AFUNIXSelector
extends AbstractSelector {
    private static AFUNIXPipe sharedSelectorPipe = null;
    private static PollFd sharedSelectorPipePollFd;
    private static final ByteBuffer PIPE_MSG;
    private static final ByteBuffer PIPE_MSG_RECEIVE_BUFFER;
    private final Set keysRegistered = new HashSet();
    private final Set keysView = Collections.unmodifiableSet(this.keysRegistered);
    private PollFd pollFd = null;
    private final SelectionKeySet keysSelected = new SelectionKeySet();

    protected AFUNIXSelector(SelectorProvider provider) {
        super(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AFUNIXPipe selectorPipe() throws IOException {
        Class<AFUNIXSelector> clazz = AFUNIXSelector.class;
        synchronized (AFUNIXSelector.class) {
            if (sharedSelectorPipe == null) {
                sharedSelectorPipe = AFUNIXSelectorProvider.getInstance().openSelectablePipe();
                sharedSelectorPipePollFd = new PollFd(sharedSelectorPipe.sourceFD());
            }
            AFUNIXPipe selectorPipe = sharedSelectorPipe;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return selectorPipe;
        }
    }

    @Override
    protected SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        AFUNIXSelectionKey key = new AFUNIXSelectionKey(this, ch, ops, att);
        this.pollFd = null;
        this.keysRegistered.add(key);
        return key;
    }

    public Set keys() {
        return this.keysView;
    }

    public Set selectedKeys() {
        return this.keysSelected;
    }

    @Override
    public int selectNow() throws IOException {
        return this.select0(0);
    }

    @Override
    public int select(long timeout) throws IOException {
        if (timeout > Integer.MAX_VALUE) {
            timeout = Integer.MAX_VALUE;
        } else if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        return this.select0((int)timeout);
    }

    @Override
    public int select() throws IOException {
        try {
            return this.select0(-1);
        }
        catch (SocketTimeoutException e) {
            return 0;
        }
    }

    private int select0(int timeout) throws IOException {
        int num;
        this.pollFd = this.initPollFd(this.pollFd);
        this.keysSelected.clear();
        this.begin();
        try {
            num = NativeUnixSocket.poll(this.pollFd, timeout);
        }
        finally {
            this.end();
        }
        if (num > 0) {
            this.consumeAllBytesAfterPoll();
            this.setOpsReady();
        }
        return this.keysSelected.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeAllBytesAfterPoll() throws IOException {
        if ((this.pollFd.rops[0] & 1) == 0) {
            return;
        }
        ByteBuffer byteBuffer = PIPE_MSG_RECEIVE_BUFFER;
        synchronized (byteBuffer) {
            PIPE_MSG_RECEIVE_BUFFER.clear();
            int maxReceive = PIPE_MSG_RECEIVE_BUFFER.remaining();
            int bytesReceived = NativeUnixSocket.receive(this.pollFd.fds[0], PIPE_MSG_RECEIVE_BUFFER, 0, maxReceive, null, 8, null, 0);
            if (bytesReceived == maxReceive) {
                int read;
                do {
                    if ((read = NativeUnixSocket.poll(sharedSelectorPipePollFd, 0)) <= 0) continue;
                    PIPE_MSG_RECEIVE_BUFFER.clear();
                    read = NativeUnixSocket.receive(AFUNIXSelector.sharedSelectorPipePollFd.fds[0], PIPE_MSG_RECEIVE_BUFFER, 0, maxReceive, null, 8, null, 0);
                } while (read == maxReceive);
            }
        }
    }

    private void setOpsReady() {
        for (int i = 1; i < this.pollFd.rops.length; ++i) {
            int rops = this.pollFd.rops[i];
            if (rops == 0) continue;
            AFUNIXSelectionKey key = this.pollFd.keys[i];
            key.setOpsReady(rops);
            this.keysSelected.add0(key);
        }
    }

    private PollFd initPollFd(PollFd existingPollFd) throws IOException {
        Iterator it = this.keysRegistered.iterator();
        while (it.hasNext()) {
            AFUNIXSelectionKey key = (AFUNIXSelectionKey)it.next();
            if (key.getAFCore().fd.valid()) continue;
            key.cancelNoRemove();
            it.remove();
            existingPollFd = null;
        }
        if (existingPollFd != null) {
            return existingPollFd;
        }
        int size = this.keysRegistered.size() + 1;
        FileDescriptor[] fds = new FileDescriptor[size];
        int[] ops = new int[size];
        AFUNIXSelectionKey[] keys = new AFUNIXSelectionKey[size];
        fds[0] = this.selectorPipe().sourceFD();
        ops[0] = 1;
        int i = 1;
        Iterator iterator = this.keysRegistered.iterator();
        while (iterator.hasNext()) {
            AFUNIXSelectionKey key;
            keys[i] = key = (AFUNIXSelectionKey)iterator.next();
            fds[i] = key.getAFCore().fd;
            ops[i] = key.interestOps();
        }
        return new PollFd(keys, fds, ops);
    }

    @Override
    protected void implCloseSelector() throws IOException {
        this.wakeup();
        for (AFUNIXSelectionKey key : this.keysRegistered) {
            key.cancelNoRemove();
        }
        this.keysRegistered.clear();
    }

    @Override
    public Selector wakeup() {
        try {
            this.selectorPipe().sink().write(PIPE_MSG);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    void remove(AFUNIXSelectionKey key) {
        this.keysRegistered.remove(key);
        this.pollFd = null;
    }

    static {
        PIPE_MSG = ByteBuffer.allocate(1);
        PIPE_MSG_RECEIVE_BUFFER = ByteBuffer.allocateDirect(256);
    }

    private static final class SelectionKeySet
    extends HashSet {
        private static final long serialVersionUID = 1L;

        private SelectionKeySet() {
        }

        @Override
        public boolean add(SelectionKey e) {
            throw new UnsupportedOperationException();
        }

        private void add0(SelectionKey e) {
            super.add(e);
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }
    }

    static final class PollFd {
        final FileDescriptor[] fds;
        final int[] ops;
        final int[] rops;
        final AFUNIXSelectionKey[] keys;

        private PollFd(FileDescriptor pipeSourceFd) {
            this(pipeSourceFd, 1);
        }

        PollFd(FileDescriptor pipeSourceFd, int op) {
            this.fds = new FileDescriptor[]{pipeSourceFd};
            this.ops = new int[]{op};
            this.rops = new int[1];
            this.keys = null;
        }

        private PollFd(AFUNIXSelectionKey[] keys, FileDescriptor[] fds, int[] ops) {
            this.keys = keys;
            if (fds.length != ops.length) {
                throw new IllegalStateException();
            }
            this.fds = fds;
            this.ops = ops;
            this.rops = new int[ops.length];
        }
    }
}

