/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXSelector;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketCore;

final class AFUNIXSelectionKey
extends SelectionKey {
    private final AFUNIXSelector sel;
    private final AFUNIXSocketCore core;
    private int ops;
    private final SelectableChannel chann;
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private int opsReady;

    AFUNIXSelectionKey(AFUNIXSelector selector, AbstractSelectableChannel ch, int ops, Object att) {
        this.chann = ch;
        this.sel = selector;
        this.ops = ops;
        if (ch instanceof AFUNIXDatagramChannel) {
            this.core = ((AFUNIXDatagramChannel)ch).getAFCore();
        } else if (ch instanceof AFUNIXSocketChannel) {
            this.core = ((AFUNIXSocketChannel)ch).getAFCore();
        } else if (ch instanceof AFUNIXServerSocketChannel) {
            this.core = ((AFUNIXServerSocketChannel)ch).getAFCore();
        } else {
            throw new UnsupportedOperationException();
        }
        this.attach(att);
    }

    @Override
    public SelectableChannel channel() {
        return this.chann;
    }

    @Override
    public Selector selector() {
        return this.sel;
    }

    @Override
    public boolean isValid() {
        return !this.cancelled.get() && this.chann.isOpen() && this.sel.isOpen();
    }

    @Override
    public void cancel() {
        this.sel.remove(this);
        this.cancelNoRemove();
    }

    void cancelNoRemove() {
        if (!this.cancelled.compareAndSet(false, true) || !this.chann.isOpen()) {
            return;
        }
        this.cancel1();
    }

    private void cancel1() {
    }

    @Override
    public int interestOps() {
        return this.ops;
    }

    @Override
    public SelectionKey interestOps(int interestOps) {
        this.ops = interestOps;
        return this;
    }

    @Override
    public int readyOps() {
        return this.opsReady;
    }

    AFUNIXSocketCore getAFCore() {
        return this.core;
    }

    void setOpsReady(int opsReady) {
        this.opsReady = opsReady;
    }
}

