/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.util.Set;
import org.newsclub.net.unix.AFUNIXDatagramSocket;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCore;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.AFUNIXSocketExtensions;
import org.newsclub.net.unix.AFUNIXSomeSocket;
import org.newsclub.net.unix.SocketOptionsMapper;

public final class AFUNIXDatagramChannel
extends DatagramChannel
implements AFUNIXSomeSocket,
AFUNIXSocketExtensions {
    private final AFUNIXDatagramSocket afSocket;

    AFUNIXDatagramChannel(AFUNIXDatagramSocket socket) {
        super(AFUNIXSelectorProvider.getInstance());
        this.afSocket = socket;
    }

    AFUNIXDatagramSocket getAFSocket() {
        return this.afSocket;
    }

    public static AFUNIXDatagramChannel open() throws IOException {
        return AFUNIXSelectorProvider.provider().openDatagramChannel();
    }

    public static AFUNIXDatagramChannel open(ProtocolFamily family) throws IOException {
        return AFUNIXSelectorProvider.provider().openDatagramChannel(family);
    }

    @Override
    public MembershipKey join(InetAddress group, NetworkInterface interf) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MembershipKey join(InetAddress group, NetworkInterface interf, InetAddress source) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AFUNIXDatagramChannel bind(SocketAddress local) throws IOException {
        this.afSocket.bind(local);
        return this;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AFUNIXDatagramSocket socket() {
        return this.afSocket;
    }

    public boolean isBound() {
        return this.afSocket.isBound();
    }

    @Override
    public boolean isConnected() {
        return this.afSocket.isConnected();
    }

    @Override
    public AFUNIXDatagramChannel connect(SocketAddress remote) throws IOException {
        this.afSocket.connect(remote);
        return this;
    }

    @Override
    public AFUNIXDatagramChannel disconnect() throws IOException {
        this.afSocket.disconnect();
        return this;
    }

    @Override
    public AFUNIXSocketAddress getRemoteAddress() throws IOException {
        return this.afSocket.getRemoteSocketAddress();
    }

    @Override
    public AFUNIXSocketAddress getLocalAddress() throws IOException {
        return this.afSocket.getLocalSocketAddress();
    }

    @Override
    public AFUNIXSocketAddress receive(ByteBuffer dst) throws IOException {
        return this.afSocket.getAFImpl().receive(dst);
    }

    @Override
    public int send(ByteBuffer src, SocketAddress target) throws IOException {
        return this.afSocket.getAFImpl().send(src, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.afSocket.getAFImpl().read(dst, null);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        return this.read(dsts[offset]);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.afSocket.getAFImpl().write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        return this.write(srcs[offset]);
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.getAFSocket().close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.getAFCore().implConfigureBlocking(block);
    }

    @Override
    public FileDescriptor[] getReceivedFileDescriptors() throws IOException {
        return this.afSocket.getReceivedFileDescriptors();
    }

    @Override
    public void clearReceivedFileDescriptors() {
        this.afSocket.clearReceivedFileDescriptors();
    }

    @Override
    public void setOutboundFileDescriptors(FileDescriptor ... fdescs) throws IOException {
        if (fdescs != null && fdescs.length > 0 && !this.isConnected()) {
            throw new SocketException("Not connected");
        }
        this.afSocket.setOutboundFileDescriptors(fdescs);
    }

    @Override
    public boolean hasOutboundFileDescriptors() {
        return this.afSocket.hasOutboundFileDescriptors();
    }

    @Override
    public AFUNIXSocketCredentials getPeerCredentials() throws IOException {
        return this.afSocket.getPeerCredentials();
    }

    @Override
    public int getAncillaryReceiveBufferSize() {
        return this.afSocket.getAncillaryReceiveBufferSize();
    }

    @Override
    public void setAncillaryReceiveBufferSize(int size) {
        this.afSocket.setAncillaryReceiveBufferSize(size);
    }

    @Override
    public void ensureAncillaryReceiveBufferSize(int minSize) {
        this.afSocket.ensureAncillaryReceiveBufferSize(minSize);
    }

    @Override
    public AFUNIXDatagramChannel setOption(SocketOption name, Object value) throws IOException {
        Integer optionId = SocketOptionsMapper.resolve(name);
        if (optionId == null) {
            throw new UnsupportedOperationException("unsupported option");
        }
        this.afSocket.getAFImpl().setOption(optionId, value);
        return this;
    }

    public Object getOption(SocketOption name) throws IOException {
        Integer optionId = SocketOptionsMapper.resolve(name);
        if (optionId == null) {
            throw new UnsupportedOperationException("unsupported option");
        }
        return this.afSocket.getAFImpl().getOption(optionId);
    }

    public Set supportedOptions() {
        return SocketOptionsMapper.SUPPORTED_SOCKET_OPTIONS;
    }

    AFUNIXSocketCore getAFCore() {
        return this.afSocket.getAFImpl().getCore();
    }

    @Override
    public FileDescriptor getFileDescriptor() throws IOException {
        return this.afSocket.getFileDescriptor();
    }

    public boolean isDeleteOnClose() {
        return this.afSocket.isDeleteOnClose();
    }

    public void setDeleteOnClose(boolean b) {
        this.afSocket.setDeleteOnClose(b);
    }
}

