/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.world;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.DimensionManager;

public class DimensionUtils {
    private final List DIMENSION_TYPES = Lists.newArrayList();
    public boolean isInUse = false;
    public boolean enabled = false;
    public List DIMENSION_NAMES = Lists.newArrayList();
    private String CURRENT_DIMENSION_NAME;
    private String CURRENT_DIMENSION_IDENTIFIER;

    private void emptyData() {
        this.DIMENSION_NAMES.clear();
        this.DIMENSION_TYPES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_DIMENSION_NAME = null;
        this.isInUse = false;
        CraftPresence.CLIENT.initArgument("&DIMENSION&");
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? !(!CraftPresence.CONFIG.detectDimensionData || CraftPresence.BIOMES.enabled && CraftPresence.BIOMES.BIOME_NAMES.isEmpty()) : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.DIMENSION_NAMES.isEmpty() || this.DIMENSION_TYPES.isEmpty());
        if (needsUpdate) {
            this.getDimensions();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateDimensionData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private void updateDimensionData() {
        String newDimension_Identifier;
        acn newProvider = CraftPresence.player.q.t;
        String newDimensionName = StringUtils.formatIdentifier(newProvider.l(), false, !CraftPresence.CONFIG.formatWords);
        String newDimension_primaryIdentifier = StringUtils.formatIdentifier(newProvider.l(), true, !CraftPresence.CONFIG.formatWords);
        String newDimension_alternativeIdentifier = StringUtils.formatIdentifier(newProvider.getClass().getSimpleName(), true, !CraftPresence.CONFIG.formatWords);
        String string = newDimension_Identifier = !StringUtils.isNullOrEmpty(newDimension_primaryIdentifier) ? newDimension_primaryIdentifier : newDimension_alternativeIdentifier;
        if (!newDimensionName.equals(this.CURRENT_DIMENSION_NAME) || !newDimension_Identifier.equals(this.CURRENT_DIMENSION_IDENTIFIER)) {
            this.CURRENT_DIMENSION_NAME = !StringUtils.isNullOrEmpty(newDimensionName) ? newDimensionName : newDimension_Identifier;
            this.CURRENT_DIMENSION_IDENTIFIER = newDimension_Identifier;
            if (!this.DIMENSION_NAMES.contains(newDimension_Identifier)) {
                this.DIMENSION_NAMES.add(newDimension_Identifier);
            }
            if (!this.DIMENSION_TYPES.contains(newProvider)) {
                this.DIMENSION_TYPES.add(newProvider);
            }
            this.updateDimensionPresence();
        }
    }

    public void updateDimensionPresence() {
        ArrayList dimensionArgs = Lists.newArrayList();
        dimensionArgs.add(new Pair("&DIMENSION&", this.CURRENT_DIMENSION_NAME));
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            dimensionArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String defaultDimensionMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.dimensionMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentDimensionMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.dimensionMessages, this.CURRENT_DIMENSION_IDENTIFIER, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultDimensionMessage);
        String currentDimensionIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.dimensionMessages, this.CURRENT_DIMENSION_IDENTIFIER, 0, 2, CraftPresence.CONFIG.splitCharacter, this.CURRENT_DIMENSION_IDENTIFIER);
        String formattedIconKey = StringUtils.formatAsIcon(currentDimensionIcon.replace(" ", "_"));
        String CURRENT_DIMENSION_ICON = formattedIconKey.replace("&icon&", CraftPresence.CONFIG.defaultDimensionIcon);
        String CURRENT_DIMENSION_MESSAGE = StringUtils.sequentialReplaceAnyCase(currentDimensionMessage, dimensionArgs);
        CraftPresence.CLIENT.syncArgument("&DIMENSION&", CURRENT_DIMENSION_MESSAGE, false);
        CraftPresence.CLIENT.syncArgument("&DIMENSION&", CraftPresence.CLIENT.imageOf(CURRENT_DIMENSION_ICON, CraftPresence.CONFIG.defaultDimensionIcon, true), true);
    }

    private List getDimensionTypes() {
        ArrayList dimensionTypes;
        block6: {
            dimensionTypes = Lists.newArrayList();
            Map reflectedDimensionTypes = (Map)StringUtils.lookupObject(DimensionManager.class, null, "providers");
            if (!dimensionTypes.isEmpty()) break block6;
            if (reflectedDimensionTypes != null) {
                for (Object objectType : reflectedDimensionTypes.values()) {
                    acn type = objectType instanceof acn ? (acn)objectType : null;
                    if (type == null || dimensionTypes.contains(type)) continue;
                    dimensionTypes.add(type);
                }
            } else {
                for (Class classObj : FileUtils.getClassNamesMatchingSuperType(acn.class, true, "net.minecraft", "com.gitlab.cdagaming.craftpresence")) {
                    if (classObj == null) continue;
                    try {
                        acn providerObj = (acn)classObj.newInstance();
                        if (providerObj == null || dimensionTypes.contains(providerObj)) continue;
                        dimensionTypes.add(providerObj);
                    }
                    catch (Error | Exception ex) {
                        if (!ModUtils.IS_VERBOSE) continue;
                        ex.printStackTrace();
                    }
                }
            }
        }
        return dimensionTypes;
    }

    public void getDimensions() {
        for (acn TYPE : this.getDimensionTypes()) {
            if (TYPE == null) continue;
            if (!this.DIMENSION_NAMES.contains(StringUtils.formatIdentifier(TYPE.l(), true, !CraftPresence.CONFIG.formatWords))) {
                this.DIMENSION_NAMES.add(StringUtils.formatIdentifier(TYPE.l(), true, !CraftPresence.CONFIG.formatWords));
            }
            if (this.DIMENSION_TYPES.contains(TYPE)) continue;
            this.DIMENSION_TYPES.add(TYPE);
        }
        for (String dimensionMessage : CraftPresence.CONFIG.dimensionMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(dimensionMessage) || StringUtils.isNullOrEmpty((part = dimensionMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.DIMENSION_NAMES.contains(StringUtils.formatIdentifier(part[0], true, !CraftPresence.CONFIG.formatWords))) continue;
            this.DIMENSION_NAMES.add(StringUtils.formatIdentifier(part[0], true, !CraftPresence.CONFIG.formatWords));
        }
    }
}

