/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.updater;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.craftpresence.utils.updater.ModUpdaterUtils;
import java.util.List;

public class UpdateInfoGui
extends ExtendedScreen {
    private final ModUpdaterUtils modUpdater;
    private ExtendedButtonControl downloadButton;
    private ExtendedButtonControl checkButton;

    public UpdateInfoGui(axr parentScreen, ModUpdaterUtils modUpdater) {
        super(parentScreen);
        this.modUpdater = modUpdater;
    }

    @Override
    public void initializeUi() {
        this.checkButton = (ExtendedButtonControl)this.addControl((awx)new ExtendedButtonControl(this.h / 2 - 90, this.i - 30, 180, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.checkForUpdates", new Object[0]), new Runnable(){

            @Override
            public void run() {
                UpdateInfoGui.this.modUpdater.checkForUpdates(new Runnable(){

                    @Override
                    public void run() {
                        if (((UpdateInfoGui)UpdateInfoGui.this).modUpdater.isInvalidVersion) {
                            StringUtils.updateField(ModUtils.class, null, new Tuple("VERSION_ID", "v" + ((UpdateInfoGui)UpdateInfoGui.this).modUpdater.targetVersion, -17));
                            StringUtils.updateField(ModUtils.class, null, new Tuple("VERSION_TYPE", ((UpdateInfoGui)UpdateInfoGui.this).modUpdater.currentState.getDisplayName(), -17));
                            StringUtils.updateField(ModUtils.class, null, new Tuple("VERSION_LABEL", ((UpdateInfoGui)UpdateInfoGui.this).modUpdater.currentState.getDisplayName(), -17));
                            StringUtils.updateField(ModUtils.class, null, new Tuple("NAME", CraftPresence.class.getSimpleName(), -17));
                            ((UpdateInfoGui)UpdateInfoGui.this).modUpdater.currentVersion = ((UpdateInfoGui)UpdateInfoGui.this).modUpdater.targetVersion;
                            ((UpdateInfoGui)UpdateInfoGui.this).modUpdater.isInvalidVersion = false;
                        }
                    }
                });
            }
        }, new String[0]));
        this.addControl((awx)new ExtendedButtonControl(10, this.i - 30, 95, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]), new Runnable(){

            @Override
            public void run() {
                CraftPresence.GUIS.openScreen(UpdateInfoGui.this.parentScreen);
            }
        }, new String[0]));
        this.downloadButton = (ExtendedButtonControl)this.addControl((awx)new ExtendedButtonControl(this.h - 105, this.i - 30, 95, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.download", new Object[0]), new Runnable(){

            @Override
            public void run() {
                try {
                    UrlUtils.openUrl(((UpdateInfoGui)UpdateInfoGui.this).modUpdater.downloadUrl);
                }
                catch (Exception ex) {
                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.web", ((UpdateInfoGui)UpdateInfoGui.this).modUpdater.downloadUrl), new Object[0]);
                    ex.printStackTrace();
                }
            }
        }, new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.downloadButton.setControlEnabled(this.modUpdater.currentState == ModUpdaterUtils.UpdateState.OUTDATED || this.modUpdater.currentState == ModUpdaterUtils.UpdateState.BETA_OUTDATED);
        this.checkButton.setControlEnabled(this.modUpdater.currentState != ModUpdaterUtils.UpdateState.PENDING);
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.changes", this.modUpdater.currentState.getDisplayName());
        List notice = StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.changelog", this.modUpdater.targetVersion, this.modUpdater.targetChangelogData));
        this.renderString(mainTitle, (float)this.h / 2.0f - (float)StringUtils.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(subTitle, (float)this.h / 2.0f - (float)StringUtils.getStringWidth(subTitle) / 2.0f, 20.0f, 0xFFFFFF);
        CraftPresence.GUIS.drawMultiLineString(notice, 10, 45, this.h, this.i, this.getWrapWidth(), this.getFontRenderer(), false);
    }
}

