/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class PaginatedScreen
extends ExtendedScreen {
    private final Map paginatedControls = Maps.newHashMap();
    private final Map paginatedLists = Maps.newHashMap();
    protected int startPage;
    protected int currentPage = this.startPage = 1;
    protected int maxPages = this.startPage;
    protected ExtendedButtonControl nextPageButton;
    protected ExtendedButtonControl previousPageButton;
    protected ExtendedButtonControl backButton;
    private Runnable onPageChange;

    public PaginatedScreen(axr parentScreen) {
        super(parentScreen);
    }

    public PaginatedScreen(axr parentScreen, boolean debugMode) {
        super(parentScreen, debugMode);
    }

    public PaginatedScreen(axr parentScreen, boolean debugMode, boolean verboseMode) {
        super(parentScreen, debugMode, verboseMode);
    }

    @Override
    public void initializeUi() {
        this.backButton = (ExtendedButtonControl)this.addControl((awx)new ExtendedButtonControl(this.h / 2 - 90, this.i - 30, 180, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]), new Runnable(){

            @Override
            public void run() {
                CraftPresence.GUIS.openScreen(PaginatedScreen.this.parentScreen);
            }
        }, new String[0]));
        this.previousPageButton = (ExtendedButtonControl)this.addControl((awx)new ExtendedButtonControl(this.backButton.getControlPosX() - 23, this.i - 30, 20, 20, "<", new Runnable(){

            @Override
            public void run() {
                if (PaginatedScreen.this.currentPage > PaginatedScreen.this.startPage) {
                    --PaginatedScreen.this.currentPage;
                    if (PaginatedScreen.this.onPageChange != null) {
                        PaginatedScreen.this.onPageChange.run();
                    }
                }
            }
        }, new String[0]));
        this.nextPageButton = (ExtendedButtonControl)this.addControl((awx)new ExtendedButtonControl(this.backButton.getControlPosX() + this.backButton.getControlWidth() + 3, this.i - 30, 20, 20, ">", new Runnable(){

            @Override
            public void run() {
                if (PaginatedScreen.this.currentPage < PaginatedScreen.this.maxPages) {
                    ++PaginatedScreen.this.currentPage;
                    if (PaginatedScreen.this.onPageChange != null) {
                        PaginatedScreen.this.onPageChange.run();
                    }
                }
            }
        }, new String[0]));
        this.previousPageButton.setControlEnabled(this.currentPage > this.startPage);
        this.nextPageButton.setControlEnabled(this.currentPage < this.maxPages);
        super.initializeUi();
    }

    @NonNull
    protected awx addControl(@NonNull awx buttonIn, int renderTarget) {
        if (!this.paginatedControls.containsKey(renderTarget)) {
            this.paginatedControls.put(renderTarget, Lists.newArrayList((Object[])new awx[]{buttonIn}));
            if (renderTarget > this.maxPages) {
                this.maxPages = renderTarget;
            }
        } else {
            ((List)this.paginatedControls.get(renderTarget)).add(buttonIn);
        }
        return super.addControl(buttonIn);
    }

    @NonNull
    protected ScrollableListControl addList(@NonNull ScrollableListControl buttonIn, int renderTarget) {
        if (!this.paginatedLists.containsKey(renderTarget)) {
            this.paginatedLists.put(renderTarget, Lists.newArrayList((Object[])new ScrollableListControl[]{buttonIn}));
            if (renderTarget > this.maxPages) {
                this.maxPages = renderTarget;
            }
        } else {
            ((List)this.paginatedLists.get(renderTarget)).add(buttonIn);
        }
        return super.addList(buttonIn);
    }

    @Override
    public void preRender() {
        ArrayList defaultButtons = Lists.newArrayList((Object[])new awx[]{this.previousPageButton, this.nextPageButton, this.backButton});
        ArrayList elementsToRender = this.paginatedControls.containsKey(this.currentPage) ? (List)this.paginatedControls.get(this.currentPage) : defaultButtons;
        ArrayList listsToRender = this.paginatedLists.containsKey(this.currentPage) ? (List)this.paginatedLists.get(this.currentPage) : Lists.newArrayList();
        for (awx extendedControl : this.extendedControls) {
            if (extendedControl instanceof ExtendedButtonControl) {
                ((ExtendedButtonControl)extendedControl).setControlVisible(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
                ((ExtendedButtonControl)extendedControl).setControlEnabled(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
            }
            if (!(extendedControl instanceof ExtendedTextControl)) continue;
            ((ExtendedTextControl)extendedControl).e(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
            ((ExtendedTextControl)extendedControl).c(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
        }
        for (ScrollableListControl listControl : this.extendedLists) {
            listControl.setVisible(listsToRender.contains((Object)listControl));
        }
        this.previousPageButton.setControlEnabled(this.currentPage > this.startPage);
        this.nextPageButton.setControlEnabled(this.currentPage < this.maxPages);
    }

    @Override
    protected void a(char typedChar, int keyCode) {
        if (keyCode == 200 && this.currentPage > this.startPage) {
            --this.currentPage;
        }
        if (keyCode == 208 && this.currentPage < this.maxPages) {
            ++this.currentPage;
        }
        super.a(typedChar, keyCode);
    }

    public void renderString(String text, float xPos, float yPos, int color, int renderTarget) {
        if (renderTarget == this.currentPage) {
            this.getFontRenderer().a(text, Math.round(xPos), Math.round(yPos), color);
        }
    }

    public void setOnPageChange(Runnable onPageChange) {
        this.onPageChange = onPageChange;
    }
}

