/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.eclipse.jdt.annotation.NonNull;
import org.lwjgl.input.Keyboard;

public class ExtendedScreen
extends axr {
    public final axr parentScreen;
    public final axr currentScreen;
    protected final List extendedControls = Lists.newArrayList();
    protected final List extendedLists = Lists.newArrayList();
    private boolean initialized = false;
    private boolean debugMode = false;
    private boolean verboseMode = false;
    private int lastMouseX = 0;
    private int lastMouseY = 0;

    public ExtendedScreen(axr parentScreen) {
        this.g = CraftPresence.instance;
        this.currentScreen = this;
        this.parentScreen = parentScreen;
        this.setDebugMode(ModUtils.IS_DEV);
        this.setVerboseMode(ModUtils.IS_VERBOSE);
    }

    public ExtendedScreen(axr parentScreen, boolean debugMode) {
        this(parentScreen);
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(axr parentScreen, boolean debugMode, boolean verboseMode) {
        this(parentScreen, debugMode);
        this.setVerboseMode(verboseMode);
    }

    public void A_() {
        this.k.clear();
        this.extendedControls.clear();
        this.extendedLists.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.initializeUi();
        super.A_();
        this.initialized = true;
    }

    public void initializeUi() {
    }

    public void a(@NonNull Minecraft mcIn, int w, int h) {
        this.initialized = false;
        super.a(mcIn, w, h);
    }

    @NonNull
    protected awx addControl(@NonNull awx buttonIn) {
        if (buttonIn instanceof awg && !this.k.contains(buttonIn)) {
            this.k.add((awg)buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @NonNull
    protected ScrollableListControl addList(@NonNull ScrollableListControl buttonIn) {
        if (!this.extendedLists.contains((Object)buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        CraftPresence.GUIS.drawBackground(this.h, this.i);
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        if (this.initialized) {
            this.renderCriticalData();
            this.preRender();
            for (ScrollableListControl listControl : this.extendedLists) {
                if (!listControl.isVisible()) continue;
                listControl.a(mouseX, mouseY, partialTicks);
            }
            for (awx extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.f();
            }
            super.a(mouseX, mouseY, partialTicks);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            for (awx extendedControl : this.extendedControls) {
                ExtendedButtonControl extendedButton;
                if (!(extendedControl instanceof ExtendedButtonControl) || !CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, extendedButton = (ExtendedButtonControl)extendedControl)) continue;
                extendedButton.onHover();
            }
            this.postRender();
        }
    }

    public void d() {
        if (this.initialized) {
            super.d();
        }
    }

    protected void a(@NonNull awg button) {
        if (button instanceof ExtendedButtonControl) {
            ((ExtendedButtonControl)button).onClick();
        }
        super.a(button);
    }

    protected void a(char typedChar, int keyCode) {
        if (this.initialized) {
            if (keyCode == 1) {
                CraftPresence.GUIS.openScreen(this.parentScreen);
            }
            for (awx extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.a(typedChar, keyCode);
            }
        }
    }

    protected void a(int mouseX, int mouseY, int mouseButton) {
        if (this.initialized) {
            for (awx extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.a(mouseX, mouseY, mouseButton);
            }
            super.a(mouseX, mouseY, mouseButton);
        }
    }

    public void c() {
        if (this.initialized) {
            for (awx extendedControl : this.extendedControls) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.a();
            }
        }
    }

    public void b() {
        this.initialized = false;
        CraftPresence.GUIS.resetIndex();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void renderNotice(List notice) {
        this.renderNotice(notice, 2.0f, 3.0f, false, false);
    }

    public void renderNotice(List notice, float widthScale, float heightScale) {
        this.renderNotice(notice, widthScale, heightScale, false, false);
    }

    public void renderNotice(List notice, float widthScale, float heightScale, boolean useXAsActual, boolean useYAsActual) {
        if (notice != null && !notice.isEmpty()) {
            for (int i = 0; i < notice.size(); ++i) {
                String string = (String)notice.get(i);
                this.renderString(string, (useXAsActual ? widthScale : (float)this.h / widthScale) - (float)StringUtils.getStringWidth(string) / widthScale, (useYAsActual ? heightScale : (float)this.i / heightScale) + (float)(i * 10), 0xFFFFFF);
            }
        }
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        this.getFontRenderer().a(text, Math.round(xPos), Math.round(yPos), color);
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public awv getFontRenderer() {
        return this.g.q != null ? this.g.q : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        return this.getFontRenderer().a;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.debugMode = isDebugMode;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(boolean isVerboseMode) {
        this.verboseMode = isVerboseMode;
    }
}

