/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.DataConsumer;
import com.gitlab.cdagaming.craftpresence.impl.PairConsumer;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.MessageGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class SelectorGui
extends ExtendedScreen {
    private final String mainTitle;
    private final String attributeName;
    private final String originalValue;
    private final List originalList;
    private final boolean allowContinuing;
    private final boolean allowDynamicEditing;
    private final PairConsumer onUpdatedCallback;
    private final ScrollableListControl.RenderType renderType;
    private final PairConsumer onAdjustDynamicEntry;
    private final DataConsumer onAddDynamicEntry;
    private ExtendedButtonControl proceedButton;
    private ScrollableListControl scrollList;
    private ExtendedTextControl searchBox;
    private String searchTerm;
    private List itemList;

    public SelectorGui(axr parentScreen, String mainTitle, List list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, ScrollableListControl.RenderType renderType, PairConsumer onUpdatedCallback, PairConsumer onAdjustDynamicEntry, DataConsumer onAddDynamicEntry) {
        super(parentScreen);
        this.itemList = this.originalList = list;
        this.originalValue = currentValue;
        this.mainTitle = mainTitle;
        this.attributeName = attributeName;
        this.allowContinuing = allowContinuing;
        this.allowDynamicEditing = allowDynamicEditing;
        this.renderType = renderType;
        this.onUpdatedCallback = onUpdatedCallback;
        this.onAdjustDynamicEntry = onAdjustDynamicEntry;
        this.onAddDynamicEntry = onAddDynamicEntry;
    }

    public SelectorGui(axr parentScreen, String mainTitle, List list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, ScrollableListControl.RenderType renderType, PairConsumer onAdjustDynamicEntry, DataConsumer onAddDynamicEntry) {
        this(parentScreen, mainTitle, list, currentValue, attributeName, allowContinuing, allowDynamicEditing, renderType, null, onAdjustDynamicEntry, onAddDynamicEntry);
    }

    public SelectorGui(axr parentScreen, String mainTitle, List list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, PairConsumer onAdjustDynamicEntry, DataConsumer onAddDynamicEntry) {
        this(parentScreen, mainTitle, list, currentValue, attributeName, allowContinuing, allowDynamicEditing, ScrollableListControl.RenderType.None, onAdjustDynamicEntry, onAddDynamicEntry);
    }

    @Override
    public void initializeUi() {
        if (this.itemList != null && !this.itemList.isEmpty()) {
            this.proceedButton = (ExtendedButtonControl)this.addControl((awx)new ExtendedButtonControl(this.h - 100, this.i - 30, 90, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    if (SelectorGui.this.allowContinuing && ((SelectorGui)SelectorGui.this).scrollList.currentValue != null) {
                        if (SelectorGui.this.originalValue != null) {
                            if (!((SelectorGui)SelectorGui.this).scrollList.currentValue.equals(SelectorGui.this.originalValue)) {
                                if (SelectorGui.this.onUpdatedCallback != null) {
                                    SelectorGui.this.onUpdatedCallback.accept(SelectorGui.this.attributeName, ((SelectorGui)SelectorGui.this).scrollList.currentValue);
                                    CraftPresence.GUIS.openScreen(SelectorGui.this.parentScreen);
                                } else {
                                    CraftPresence.GUIS.openScreen(new MessageGui(SelectorGui.this.parentScreen, StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.null", new Object[0]))));
                                }
                            } else {
                                CraftPresence.GUIS.openScreen(SelectorGui.this.parentScreen);
                            }
                        } else if (SelectorGui.this.allowDynamicEditing && SelectorGui.this.onAdjustDynamicEntry != null) {
                            SelectorGui.this.onAdjustDynamicEntry.accept(((SelectorGui)SelectorGui.this).scrollList.currentValue, SelectorGui.this.parentScreen);
                        } else {
                            CraftPresence.GUIS.openScreen(new MessageGui(SelectorGui.this.parentScreen, StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.null", new Object[0]))));
                        }
                    } else {
                        CraftPresence.GUIS.openScreen(SelectorGui.this.parentScreen);
                    }
                }
            }, new String[0]));
            this.scrollList = this.addList(new ScrollableListControl(this.g, this.h, this.i, 32, this.i - 45, this.renderType != ScrollableListControl.RenderType.None && !CraftPresence.CONFIG.stripExtraGuiElements ? 45 : 18, this.itemList, this.originalValue, this.renderType));
            this.searchBox = (ExtendedTextControl)this.addControl((awx)new ExtendedTextControl(this.getFontRenderer(), 60, this.i - 30, 120, 20));
            if (this.allowDynamicEditing && this.onAddDynamicEntry != null) {
                this.addControl((awx)new ExtendedButtonControl(this.h - 195, this.i - 30, 90, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.add.new", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        SelectorGui.this.onAddDynamicEntry.accept(SelectorGui.this.parentScreen);
                    }
                }, new String[0]));
            }
            super.initializeUi();
        } else {
            CraftPresence.GUIS.openScreen(new MessageGui(this.parentScreen, StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.empty.list", new Object[0]))));
        }
    }

    @Override
    public void preRender() {
        ArrayList modifiedList = Lists.newArrayList();
        if (!this.searchBox.b().isEmpty()) {
            if (!this.searchBox.b().equals(this.searchTerm)) {
                this.searchTerm = this.searchBox.b();
                for (String item : this.originalList) {
                    if (!item.toLowerCase().contains(this.searchTerm.toLowerCase()) || modifiedList.contains(item.toLowerCase())) continue;
                    modifiedList.add(item);
                }
                this.itemList = modifiedList;
            }
        } else {
            this.itemList = this.originalList;
        }
        if (!this.itemList.equals(this.originalList) && !this.itemList.contains(this.scrollList.currentValue)) {
            this.scrollList.currentValue = this.originalValue != null && this.itemList.contains(this.originalValue) ? this.originalValue : null;
        } else if (this.scrollList.currentValue == null && this.originalValue != null) {
            this.scrollList.currentValue = this.originalValue;
        }
        this.scrollList.itemList = this.itemList;
        this.proceedButton.setControlMessage(this.allowContinuing && this.scrollList.currentValue != null && (this.originalValue != null && !this.scrollList.currentValue.equals(this.originalValue) || StringUtils.isNullOrEmpty(this.originalValue)) ? ModUtils.TRANSLATOR.translate("gui.config.message.button.continue", new Object[0]) : ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]));
    }

    @Override
    public void postRender() {
        String searchText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.search", new Object[0]);
        String extraText = this.isVerboseMode() ? ModUtils.TRANSLATOR.translate("gui.config.title.selector.extra", this.itemList.size(), this.originalList.size()) : "";
        String displayText = this.mainTitle + " " + extraText;
        this.renderString(searchText, 30.0f - (float)StringUtils.getStringWidth(searchText) / 2.0f, this.i - 25, 0xFFFFFF);
        this.renderString(displayText, (float)this.h / 2.0f - (float)StringUtils.getStringWidth(displayText) / 2.0f, 15.0f, 0xFFFFFF);
    }
}

