/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.PairConsumer;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;

public class DynamicEditorGui
extends ExtendedScreen {
    private final boolean isNewValue;
    private final boolean isDefaultValue;
    private final PairConsumer onAdjustEntry;
    private final PairConsumer onRemoveEntry;
    private final PairConsumer onAdjustInit;
    private final PairConsumer onNewInit;
    private final PairConsumer onSpecificCallback;
    private final PairConsumer onHoverCallback;
    public String specificMessage;
    public String defaultMessage;
    public String mainTitle;
    private ExtendedButtonControl proceedButton;
    private ExtendedTextControl specificMessageInput;
    private ExtendedTextControl newValueName;
    private String attributeName;
    private String removeMessage;

    public DynamicEditorGui(axr parentScreen, String attributeName, PairConsumer onNewInit, PairConsumer onAdjustInit, PairConsumer onAdjustEntry, PairConsumer onRemoveEntry, PairConsumer onSpecificCallback, PairConsumer onHoverCallback) {
        super(parentScreen);
        this.attributeName = attributeName;
        this.isNewValue = StringUtils.isNullOrEmpty(attributeName);
        this.isDefaultValue = !StringUtils.isNullOrEmpty(attributeName) && "default".equals(attributeName);
        this.onNewInit = onNewInit;
        this.onAdjustInit = onAdjustInit;
        this.onAdjustEntry = onAdjustEntry;
        this.onRemoveEntry = onRemoveEntry;
        this.onSpecificCallback = onSpecificCallback;
        this.onHoverCallback = onHoverCallback;
    }

    @Override
    public void initializeUi() {
        if (this.isNewValue) {
            this.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.editor.add.new", new Object[0]);
            if (this.onNewInit != null) {
                this.onNewInit.accept(this.attributeName, (Object)this);
            }
        } else if (this.onAdjustInit != null) {
            this.onAdjustInit.accept(this.attributeName, (Object)this);
        }
        this.removeMessage = ModUtils.TRANSLATOR.translate("gui.config.message.remove", new Object[0]);
        this.specificMessageInput = (ExtendedTextControl)this.addControl((awx)new ExtendedTextControl(this.getFontRenderer(), this.h / 2 + 3, CraftPresence.GUIS.getButtonY(1), 180, 20));
        this.specificMessageInput.a(this.specificMessage);
        if (this.onSpecificCallback != null && !this.isNewValue) {
            this.addControl((awx)new ExtendedButtonControl(this.h / 2 - 90, CraftPresence.GUIS.getButtonY(2), 180, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.icon.change", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    DynamicEditorGui.this.onSpecificCallback.accept(DynamicEditorGui.this.attributeName, (Object)DynamicEditorGui.this);
                }
            }, new String[0]));
        }
        if (this.isNewValue) {
            this.newValueName = (ExtendedTextControl)this.addControl((awx)new ExtendedTextControl(this.getFontRenderer(), this.h / 2 + 3, CraftPresence.GUIS.getButtonY(3), 180, 20));
        }
        this.proceedButton = (ExtendedButtonControl)this.addControl((awx)new ExtendedButtonControl(this.h / 2 - 90, this.i - 30, 180, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]), new Runnable(){

            @Override
            public void run() {
                if (!DynamicEditorGui.this.specificMessageInput.b().equals(DynamicEditorGui.this.specificMessage) || DynamicEditorGui.this.isNewValue && !StringUtils.isNullOrEmpty(DynamicEditorGui.this.newValueName.b()) && !DynamicEditorGui.this.specificMessageInput.b().equals(DynamicEditorGui.this.defaultMessage) || DynamicEditorGui.this.isDefaultValue && !StringUtils.isNullOrEmpty(DynamicEditorGui.this.specificMessageInput.b()) && !DynamicEditorGui.this.specificMessageInput.b().equals(DynamicEditorGui.this.specificMessage)) {
                    if (DynamicEditorGui.this.isNewValue && !StringUtils.isNullOrEmpty(DynamicEditorGui.this.newValueName.b())) {
                        DynamicEditorGui.this.attributeName = DynamicEditorGui.this.newValueName.b();
                    }
                    if (DynamicEditorGui.this.onAdjustEntry != null) {
                        DynamicEditorGui.this.onAdjustEntry.accept(DynamicEditorGui.this.attributeName, DynamicEditorGui.this.specificMessageInput.b());
                    }
                }
                if (StringUtils.isNullOrEmpty(DynamicEditorGui.this.specificMessageInput.b()) || DynamicEditorGui.this.specificMessageInput.b().equalsIgnoreCase(DynamicEditorGui.this.defaultMessage) && !DynamicEditorGui.this.specificMessage.equals(DynamicEditorGui.this.defaultMessage) && !DynamicEditorGui.this.isDefaultValue) {
                    if (DynamicEditorGui.this.isNewValue && !StringUtils.isNullOrEmpty(DynamicEditorGui.this.newValueName.b())) {
                        DynamicEditorGui.this.attributeName = DynamicEditorGui.this.newValueName.b();
                    }
                    if (DynamicEditorGui.this.onRemoveEntry != null) {
                        DynamicEditorGui.this.onRemoveEntry.accept(DynamicEditorGui.this.attributeName, DynamicEditorGui.this.specificMessageInput.b());
                    }
                }
                CraftPresence.GUIS.openScreen(DynamicEditorGui.this.parentScreen);
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (!DynamicEditorGui.this.proceedButton.isControlEnabled()) {
                    CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])), DynamicEditorGui.this.getMouseX(), DynamicEditorGui.this.getMouseY(), DynamicEditorGui.this.h, DynamicEditorGui.this.i, DynamicEditorGui.this.getWrapWidth(), DynamicEditorGui.this.getFontRenderer(), true);
                }
            }
        }, new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        String messageText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
        String valueNameText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.value.name", new Object[0]);
        this.renderString(this.mainTitle, (float)this.h / 2.0f - (float)StringUtils.getStringWidth(this.mainTitle) / 2.0f, 15.0f, 0xFFFFFF);
        this.renderString(messageText, (float)this.h / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
        if (this.isNewValue) {
            this.renderString(valueNameText, (float)this.h / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(3, 5), 0xFFFFFF);
        } else {
            this.renderString(this.removeMessage, (float)this.h / 2.0f - (float)StringUtils.getStringWidth(this.removeMessage) / 2.0f, this.i - 45, 0xFFFFFF);
        }
        this.proceedButton.setControlMessage(!this.specificMessageInput.b().equals(this.specificMessage) || this.isNewValue && !StringUtils.isNullOrEmpty(this.newValueName.b()) && !this.specificMessageInput.b().equals(this.defaultMessage) || this.isDefaultValue && !StringUtils.isNullOrEmpty(this.specificMessageInput.b()) && !this.specificMessageInput.b().equals(this.specificMessage) ? ModUtils.TRANSLATOR.translate("gui.config.message.button.continue", new Object[0]) : ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]));
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.specificMessageInput.b()) || !this.isDefaultValue);
    }

    @Override
    public void postRender() {
        String messageText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
        String valueNameText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.value.name", new Object[0]);
        boolean isHovering = CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.h / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), StringUtils.getStringWidth(messageText), this.getFontHeight());
        if (isHovering && this.onHoverCallback != null) {
            this.onHoverCallback.accept(this.attributeName, (Object)this);
        }
        if (this.isNewValue && CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.h / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(3, 5), StringUtils.getStringWidth(valueNameText), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.value.name", new Object[0])), this.getMouseX(), this.getMouseY(), this.h, this.i, this.getWrapWidth(), this.getFontRenderer(), true);
        }
    }
}

