/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.config.ConfigUtils;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.integrations.PaginatedScreen;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ControlsGui
extends PaginatedScreen {
    private final Map keyMappings;
    private final Map categorizedNames = Maps.newHashMap();
    private final Map preRenderQueue = Maps.newHashMap();
    private final Map postRenderQueue = Maps.newHashMap();
    private final int maxElementsPerPage = 7;
    private final int startRow = 1;
    private String backupKeyString;
    private Pair entryData = null;
    private int currentAllocatedRow = 1;
    private int currentAllocatedPage = this.startPage;

    public ControlsGui(axr parentScreen) {
        super(parentScreen);
        this.keyMappings = CraftPresence.KEYBINDINGS.getKeyMappings();
        this.sortMappings();
    }

    public ControlsGui(axr parentScreen, KeyUtils.FilterMode filterMode, List filterData) {
        super(parentScreen);
        this.keyMappings = CraftPresence.KEYBINDINGS.getKeyMappings(filterMode, filterData);
        this.sortMappings();
    }

    public ControlsGui(axr parentScreen, KeyUtils.FilterMode filterMode, String ... filterData) {
        this(parentScreen, filterMode, Arrays.asList(filterData));
    }

    @Override
    public void initializeUi() {
        this.setupScreenData();
        super.initializeUi();
        this.backButton.setOnClick(new Runnable(){

            @Override
            public void run() {
                if (ControlsGui.this.entryData == null) {
                    CraftPresence.GUIS.openScreen(ControlsGui.this.parentScreen);
                }
            }
        });
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.message.button.controls", new Object[0]);
        this.renderString(mainTitle, (float)this.h / 2.0f - (float)StringUtils.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(subTitle, (float)this.h / 2.0f - (float)StringUtils.getStringWidth(subTitle) / 2.0f, 20.0f, 0xFFFFFF);
        super.preRender();
        for (Integer pageNumber : this.preRenderQueue.keySet()) {
            List elementList = (List)this.preRenderQueue.get(pageNumber);
            for (Tuple elementData : elementList) {
                this.renderString(ModUtils.TRANSLATOR.translate((String)elementData.getFirst(), new Object[0]), ((Float)((Pair)elementData.getSecond()).getFirst()).floatValue(), ((Float)((Pair)elementData.getSecond()).getSecond()).floatValue(), (Integer)elementData.getThird(), pageNumber);
            }
        }
    }

    @Override
    public void postRender() {
        for (Integer pageNumber : this.postRenderQueue.keySet()) {
            List elementList = (List)this.postRenderQueue.get(pageNumber);
            for (Tuple elementData : elementList) {
                if (this.currentPage != pageNumber || !CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), ((Float)((Pair)elementData.getSecond()).getFirst()).floatValue(), ((Float)((Pair)elementData.getSecond()).getSecond()).floatValue(), StringUtils.getStringWidth(ModUtils.TRANSLATOR.translate((String)elementData.getFirst(), new Object[0])), this.getFontHeight())) continue;
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate(((String)elementData.getFirst()).replace(".name", ".description"), new Object[0])), this.getMouseX(), this.getMouseY(), this.h, this.i, this.getWrapWidth(), this.getFontRenderer(), true);
            }
        }
    }

    @Override
    protected void a(char typedChar, int keyCode) {
        if (this.entryData != null) {
            this.setKeyData(keyCode);
        } else {
            super.a(typedChar, keyCode);
        }
    }

    private void sortMappings() {
        for (String keyName : this.keyMappings.keySet()) {
            Tuple keyData = (Tuple)this.keyMappings.get(keyName);
            if (!this.categorizedNames.containsKey(((ava)keyData.getFirst()).c)) {
                this.categorizedNames.put(((ava)keyData.getFirst()).c, Lists.newArrayList((Object[])new String[]{keyName}));
                continue;
            }
            if (((List)this.categorizedNames.get(((ava)keyData.getFirst()).c)).contains(keyName)) continue;
            ((List)this.categorizedNames.get(((ava)keyData.getFirst()).c)).add(keyName);
        }
    }

    private void setupScreenData() {
        this.preRenderQueue.clear();
        this.postRenderQueue.clear();
        int renderPosition = this.h / 2 + 3;
        for (String categoryName : this.categorizedNames.keySet()) {
            this.syncPageData();
            Tuple categoryData = new Tuple(categoryName, new Pair(Float.valueOf((float)this.h / 2.0f - (float)StringUtils.getStringWidth(categoryName) / 2.0f), Float.valueOf(CraftPresence.GUIS.getButtonY(this.currentAllocatedRow, 5))), 0xFFFFFF);
            if (!this.preRenderQueue.containsKey(this.currentAllocatedPage)) {
                this.preRenderQueue.put(this.currentAllocatedPage, Lists.newArrayList());
            }
            List keyNames = (List)this.categorizedNames.get(categoryName);
            ++this.currentAllocatedRow;
            for (String keyName : keyNames) {
                Tuple keyData = (Tuple)this.keyMappings.get(keyName);
                Tuple positionData = new Tuple(((ava)keyData.getFirst()).c, new Pair(Float.valueOf((float)this.h / 2.0f - 130.0f), Float.valueOf(CraftPresence.GUIS.getButtonY(this.currentAllocatedRow, 5))), 0xFFFFFF);
                if (!this.preRenderQueue.containsKey(this.currentAllocatedPage)) {
                    this.preRenderQueue.put(this.currentAllocatedPage, Lists.newArrayList((Object[])new Tuple[]{positionData}));
                } else {
                    ((List)this.preRenderQueue.get(this.currentAllocatedPage)).add(positionData);
                }
                if (!this.postRenderQueue.containsKey(this.currentAllocatedPage)) {
                    this.postRenderQueue.put(this.currentAllocatedPage, Lists.newArrayList((Object[])new Tuple[]{positionData}));
                } else {
                    ((List)this.postRenderQueue.get(this.currentAllocatedPage)).add(positionData);
                }
                final ExtendedButtonControl keyCodeButton = new ExtendedButtonControl(renderPosition + 20, CraftPresence.GUIS.getButtonY(this.currentAllocatedRow), 120, 20, CraftPresence.KEYBINDINGS.getKeyName(((ava)keyData.getFirst()).d), keyName);
                keyCodeButton.setOnClick(new Runnable(){

                    @Override
                    public void run() {
                        ControlsGui.this.setupEntryData(keyCodeButton);
                    }
                });
                this.addControl((awx)keyCodeButton, this.currentAllocatedPage);
                ++this.currentAllocatedRow;
                this.syncPageData();
            }
        }
    }

    private void syncPageData() {
        if (this.currentAllocatedRow >= 7) {
            ++this.currentAllocatedPage;
            this.currentAllocatedRow = 1;
        }
    }

    private void setupEntryData(ExtendedButtonControl button) {
        if (this.entryData == null && button.getOptionalArgs() != null) {
            this.entryData = new Pair((Object)button, button.getOptionalArgs()[0]);
            this.backupKeyString = button.getControlMessage();
            button.setControlMessage(ModUtils.TRANSLATOR.translate("gui.config.message.editor.enter_key", new Object[0]));
        }
    }

    private void setKeyData(int keyCode) {
        int keyToSubmit = keyCode;
        if (!CraftPresence.KEYBINDINGS.isValidKeyCode(keyToSubmit) || CraftPresence.KEYBINDINGS.isValidClearCode(keyToSubmit)) {
            keyToSubmit = 0;
        }
        String formattedKey = CraftPresence.KEYBINDINGS.getKeyName(keyToSubmit);
        try {
            StringUtils.updateField(ConfigUtils.class, CraftPresence.CONFIG, new Tuple(this.entryData.getSecond(), keyToSubmit, null));
            CraftPresence.CONFIG.keySyncQueue.put(this.entryData.getSecond(), keyToSubmit);
            CraftPresence.CONFIG.hasChanged = true;
            ((ExtendedButtonControl)((Object)this.entryData.getFirst())).setControlMessage(formattedKey);
        }
        catch (Error | Exception ex) {
            ((ExtendedButtonControl)((Object)this.entryData.getFirst())).setControlMessage(this.backupKeyString);
            ex.printStackTrace();
        }
        this.backupKeyString = null;
        this.entryData = null;
    }
}

