/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.DataConsumer;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.PairConsumer;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.SliderControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.integrations.PaginatedScreen;
import java.awt.Color;
import java.io.File;

public class ColorEditorGui
extends PaginatedScreen {
    private final String configValueName;
    private final PairConsumer onAdjustEntry;
    private final DataConsumer onInit;
    public String currentNormalHexValue;
    public String startingHexValue;
    public String currentNormalTexturePath;
    public String startingTexturePath;
    public boolean usingExternalTexture = false;
    private String currentConvertedHexValue;
    private int currentRed;
    private int currentGreen;
    private int currentBlue;
    private int currentAlpha;
    private ExtendedTextControl hexText;
    private SliderControl redText;
    private SliderControl greenText;
    private SliderControl blueText;
    private SliderControl alphaText;
    private String currentConvertedTexturePath;
    private ExtendedTextControl textureText;
    private boolean isModified = false;
    private String currentTexture;

    public ColorEditorGui(axr parentScreen, String configValueName, PairConsumer onAdjustEntry, DataConsumer onInit) {
        super(parentScreen);
        this.configValueName = configValueName;
        this.onAdjustEntry = onAdjustEntry;
        this.onInit = onInit;
    }

    @Override
    public void initializeUi() {
        int calc1 = this.h / 2 - 183;
        int calc2 = this.h / 2 + 3;
        String redTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.color.value.red", new Object[0]);
        String greenTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.color.value.green", new Object[0]);
        String blueTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.color.value.blue", new Object[0]);
        String alphaTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.color.value.alpha", new Object[0]);
        this.hexText = (ExtendedTextControl)this.addControl((awx)new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(1), 180, 20), this.startPage);
        this.hexText.f(10);
        this.redText = (SliderControl)this.addControl((awx)new SliderControl(new Pair(calc1, CraftPresence.GUIS.getButtonY(2)), new Pair(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, redTitle, new Tuple(new Runnable(){

            @Override
            public void run() {
                ColorEditorGui.this.syncValues();
            }
        }, new Runnable(){

            @Override
            public void run() {
            }
        }, new Runnable(){

            @Override
            public void run() {
                ColorEditorGui.this.syncValues();
            }
        })), this.startPage);
        this.greenText = (SliderControl)this.addControl((awx)new SliderControl(new Pair(calc2, CraftPresence.GUIS.getButtonY(2)), new Pair(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, greenTitle, new Tuple(new Runnable(){

            @Override
            public void run() {
                ColorEditorGui.this.syncValues();
            }
        }, new Runnable(){

            @Override
            public void run() {
            }
        }, new Runnable(){

            @Override
            public void run() {
                ColorEditorGui.this.syncValues();
            }
        })), this.startPage);
        this.blueText = (SliderControl)this.addControl((awx)new SliderControl(new Pair(calc1, CraftPresence.GUIS.getButtonY(3)), new Pair(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, blueTitle, new Tuple(new Runnable(){

            @Override
            public void run() {
                ColorEditorGui.this.syncValues();
            }
        }, new Runnable(){

            @Override
            public void run() {
            }
        }, new Runnable(){

            @Override
            public void run() {
                ColorEditorGui.this.syncValues();
            }
        })), this.startPage);
        this.alphaText = (SliderControl)this.addControl((awx)new SliderControl(new Pair(calc2, CraftPresence.GUIS.getButtonY(3)), new Pair(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, alphaTitle, new Tuple(new Runnable(){

            @Override
            public void run() {
                ColorEditorGui.this.syncValues();
            }
        }, new Runnable(){

            @Override
            public void run() {
            }
        }, new Runnable(){

            @Override
            public void run() {
                ColorEditorGui.this.syncValues();
            }
        })), this.startPage);
        this.textureText = (ExtendedTextControl)this.addControl((awx)new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(1), 180, 20, new Runnable(){

            @Override
            public void run() {
                ColorEditorGui.this.syncValues();
            }
        }), this.startPage + 1);
        this.textureText.f(Short.MAX_VALUE);
        this.initValues();
        this.syncValues();
        super.initializeUi();
        this.backButton.setOnClick(new Runnable(){

            @Override
            public void run() {
                ColorEditorGui.this.syncValues();
                if (ColorEditorGui.this.isModified && ColorEditorGui.this.onAdjustEntry != null) {
                    ColorEditorGui.this.onAdjustEntry.accept(ColorEditorGui.this.currentPage, (Object)ColorEditorGui.this);
                }
                CraftPresence.GUIS.openScreen(ColorEditorGui.this.parentScreen);
            }
        });
        this.setOnPageChange(new Runnable(){

            @Override
            public void run() {
                ColorEditorGui.this.initValues();
                ColorEditorGui.this.syncValues();
            }
        });
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.editor.color", this.configValueName.replaceAll("_", " "));
        String previewTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]);
        this.renderString(mainTitle, (float)this.h / 2.0f - (float)StringUtils.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(previewTitle, this.h - 90, (float)this.i - 29.5f, 0xFFFFFF);
        double tooltipX = this.h - 45;
        double tooltipY = this.i - 45;
        double tooltipHeight = 40.0;
        double tooltipTextWidth = 40.0;
        String borderColor = "#000000";
        String borderColorEnd = "#000000";
        super.preRender();
        if (this.currentPage == this.startPage) {
            String hexCodeTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.hex_code", new Object[0]);
            this.renderString(hexCodeTitle, (float)this.h / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
            this.backButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.hexText.b()));
            CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX - 3.0, tooltipY - 3.0, this.h - 2, this.i - 2, this.currentConvertedHexValue, this.currentConvertedHexValue);
        }
        if (this.currentPage == this.startPage + 1) {
            String textureTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.texture_path", new Object[0]);
            this.renderString(textureTitle, (float)this.h / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
            this.backButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.textureText.b()));
            if (this.currentTexture == null) {
                this.currentTexture = "";
            }
            double widthDivider = 32.0;
            double heightDivider = 32.0;
            if (this.usingExternalTexture) {
                String formattedConvertedName = this.currentConvertedTexturePath.replaceFirst("file://", "");
                String[] urlBits = formattedConvertedName.split("/");
                String textureName = urlBits[urlBits.length - 1].trim();
                this.currentTexture = ImageUtils.getTextureFromUrl(textureName, this.currentConvertedTexturePath.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                widthDivider = 44.0;
                heightDivider = 43.0;
            }
            CraftPresence.GUIS.drawTextureRect(0.0, this.h - 47, this.i - 47, 44.0, 44.0, 0.0, widthDivider, heightDivider, false, this.currentTexture);
        }
        CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX - 3.0, tooltipY - 3.0 + 1.0, tooltipX - 3.0 + 1.0, tooltipY + tooltipHeight + 3.0 - 1.0, borderColor, borderColorEnd);
        CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 2.0, tooltipY - 3.0 + 1.0, tooltipX + tooltipTextWidth + 3.0, tooltipY + tooltipHeight + 3.0 - 1.0, borderColor, borderColorEnd);
        CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX - 3.0, tooltipY - 3.0, tooltipX + tooltipTextWidth + 3.0, tooltipY - 3.0 + 1.0, borderColor, borderColor);
        CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX - 3.0, tooltipY + tooltipHeight + 2.0, tooltipX + tooltipTextWidth + 3.0, tooltipY + tooltipHeight + 3.0, borderColorEnd, borderColorEnd);
        this.backButton.setControlMessage(this.isModified ? ModUtils.TRANSLATOR.translate("gui.config.message.button.save", new Object[0]) : ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]));
    }

    private void initValues() {
        if (this.onInit != null) {
            this.onInit.accept((Object)this);
            if (StringUtils.isNullOrEmpty(this.hexText.b()) && !StringUtils.isNullOrEmpty(this.startingHexValue)) {
                this.hexText.a(this.startingHexValue);
                this.currentNormalHexValue = null;
                this.currentConvertedHexValue = null;
                this.currentConvertedTexturePath = null;
                this.currentTexture = "";
                this.currentPage = this.startPage;
            } else if (StringUtils.isNullOrEmpty(this.textureText.b()) && !StringUtils.isNullOrEmpty(this.startingTexturePath)) {
                this.textureText.a(this.startingTexturePath);
                this.currentNormalHexValue = null;
                this.currentConvertedHexValue = null;
                this.currentConvertedTexturePath = null;
                this.currentTexture = "";
                this.currentPage = this.startPage + 1;
            }
        }
    }

    private void syncValues() {
        if (this.currentPage == this.startPage) {
            Color localColor;
            Integer localValue = null;
            if (!StringUtils.isNullOrEmpty(this.hexText.b())) {
                if (this.hexText.b().startsWith("#") || this.hexText.b().length() == 6) {
                    localValue = StringUtils.getColorFromHex(this.hexText.b()).getRGB();
                } else if (this.hexText.b().startsWith("0x")) {
                    try {
                        localColor = new Color(Long.decode(this.hexText.b()).intValue(), true);
                        localValue = localColor.getRGB();
                    }
                    catch (Exception exception) {}
                } else if (((Boolean)StringUtils.getValidInteger(this.hexText.b()).getFirst()).booleanValue()) {
                    localValue = Integer.decode(this.hexText.b());
                }
            }
            if (localValue != null && !Integer.toString(localValue).equals(this.currentConvertedHexValue)) {
                this.currentAlpha = localValue >> 24 & 0xFF;
                this.currentRed = localValue >> 16 & 0xFF;
                this.currentGreen = localValue >> 8 & 0xFF;
                this.currentBlue = localValue & 0xFF;
                this.alphaText.setSliderValue(this.currentAlpha);
                this.redText.setSliderValue(this.currentRed);
                this.greenText.setSliderValue(this.currentGreen);
                this.blueText.setSliderValue(this.currentBlue);
                this.currentNormalHexValue = this.hexText.b();
                this.currentConvertedHexValue = Integer.toString(localValue);
            } else {
                boolean isAlphaDifferent;
                boolean isRedDifferent = this.redText.isDragging() && this.redText.getSliderValue(false) != (float)this.currentRed;
                boolean isGreenDifferent = this.greenText.isDragging() && this.greenText.getSliderValue(false) != (float)this.currentGreen;
                boolean isBlueDifferent = this.blueText.isDragging() && this.blueText.getSliderValue(false) != (float)this.currentBlue;
                boolean bl = isAlphaDifferent = this.alphaText.isDragging() && this.alphaText.getSliderValue(false) != (float)this.currentAlpha;
                if (isRedDifferent || isGreenDifferent || isBlueDifferent || isAlphaDifferent) {
                    this.currentRed = (int)this.redText.getSliderValue(false) & 0xFF;
                    this.currentGreen = (int)this.greenText.getSliderValue(false) & 0xFF;
                    this.currentBlue = (int)this.blueText.getSliderValue(false) & 0xFF;
                    this.currentAlpha = (int)this.alphaText.getSliderValue(false) & 0xFF;
                    localColor = new Color(this.currentRed, this.currentGreen, this.currentBlue, this.currentAlpha);
                    this.currentNormalHexValue = StringUtils.getHexFromColor(localColor);
                    this.hexText.a(this.currentNormalHexValue);
                    this.currentConvertedHexValue = Long.toString(Long.decode(this.currentNormalHexValue).intValue());
                }
            }
            boolean bl = this.isModified = !this.hexText.b().equals(this.startingHexValue);
        }
        if (this.currentPage == this.startPage + 1) {
            if (!StringUtils.isNullOrEmpty(this.textureText.b())) {
                this.usingExternalTexture = ImageUtils.isExternalImage(this.textureText.b());
                if (!this.usingExternalTexture) {
                    if (this.textureText.b().contains(CraftPresence.CONFIG.splitCharacter)) {
                        this.textureText.a(this.textureText.b().replace(CraftPresence.CONFIG.splitCharacter, ":"));
                    }
                    this.currentNormalTexturePath = this.textureText.b().contains(":") && !this.textureText.b().startsWith(":") ? this.textureText.b() : (this.textureText.b().startsWith(":") ? this.textureText.b().substring(1) : "minecraft:" + this.textureText.b());
                } else {
                    this.currentNormalTexturePath = this.textureText.b();
                }
                this.currentConvertedTexturePath = this.currentNormalTexturePath.trim();
                if (!this.usingExternalTexture) {
                    if (this.currentConvertedTexturePath.contains(":")) {
                        String[] splitInput = this.currentConvertedTexturePath.split(":", 2);
                        this.currentTexture = splitInput[1];
                    } else {
                        this.currentTexture = this.currentConvertedTexturePath;
                    }
                } else {
                    String formattedConvertedName = this.currentConvertedTexturePath.replaceFirst("file://", "");
                    String[] urlBits = formattedConvertedName.trim().split("/");
                    String textureName = urlBits[urlBits.length - 1].trim();
                    this.currentTexture = ImageUtils.getTextureFromUrl(textureName, this.currentConvertedTexturePath.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                }
            } else {
                this.currentTexture = "";
            }
            this.isModified = !StringUtils.isNullOrEmpty(this.startingTexturePath) && !this.textureText.b().equals(this.startingTexturePath.replace(CraftPresence.CONFIG.splitCharacter, ":"));
        }
    }
}

