/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.util.Arrays;
import java.util.List;

public class CharacterEditorGui
extends ExtendedScreen {
    private ExtendedButtonControl saveButton;
    private ExtendedButtonControl syncSingleButton;
    private ExtendedTextControl charInput;
    private ExtendedTextControl charWidth;
    private String lastScannedString;
    private char lastScannedChar;
    private int[] originalCharArray = (int[])StringUtils.MC_CHAR_WIDTH.clone();
    private byte[] originalGlyphArray = (byte[])StringUtils.MC_GLYPH_WIDTH.clone();

    public CharacterEditorGui(axr parentScreen) {
        super(parentScreen);
    }

    @Override
    public void initializeUi() {
        this.charInput = (ExtendedTextControl)this.addControl((awx)new ExtendedTextControl(this.getFontRenderer(), this.h / 2 + 3, CraftPresence.GUIS.getButtonY(1), 180, 20));
        this.charWidth = (ExtendedTextControl)this.addControl((awx)new ExtendedTextControl(this.getFontRenderer(), this.h / 2 + 3, CraftPresence.GUIS.getButtonY(2), 180, 20));
        this.charInput.f(1);
        this.charWidth.f(2);
        ExtendedButtonControl resetCharsButton = (ExtendedButtonControl)this.addControl((awx)new ExtendedButtonControl(this.h / 2 - 90, this.i - 30, 180, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.reset", new Object[0]), new Runnable(){

            @Override
            public void run() {
                ModUtils.loadCharData(true, "UTF-8");
            }
        }, new String[0]));
        ExtendedButtonControl syncAllButton = (ExtendedButtonControl)this.addControl((awx)new ExtendedButtonControl(this.h / 2 - 90, resetCharsButton.getControlPosY() - 25, 180, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.sync.all", new Object[0]), new Runnable(){

            @Override
            public void run() {
                for (int currentCharIndex = 0; currentCharIndex < StringUtils.MC_CHAR_WIDTH.length - 1; ++currentCharIndex) {
                    char characterObj = (char)currentCharIndex;
                    StringUtils.MC_CHAR_WIDTH[currentCharIndex] = CharacterEditorGui.this.getFontRenderer().a(Character.toString(characterObj));
                }
                for (int currentGlyphIndex = 0; currentGlyphIndex < StringUtils.MC_GLYPH_WIDTH.length - 1; ++currentGlyphIndex) {
                    char glyphObj = (char)(currentGlyphIndex & 0xFF);
                    StringUtils.MC_GLYPH_WIDTH[currentGlyphIndex] = (byte)CharacterEditorGui.this.getFontRenderer().a(Character.toString(glyphObj));
                }
            }
        }, new String[0]));
        this.syncSingleButton = (ExtendedButtonControl)this.addControl((awx)new ExtendedButtonControl(this.h / 2 - 90, syncAllButton.getControlPosY() - 25, 180, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.sync.single", this.charInput.b()), new Runnable(){

            @Override
            public void run() {
                if (CharacterEditorGui.this.lastScannedChar > '\u0000' && CharacterEditorGui.this.lastScannedChar < StringUtils.MC_CHAR_WIDTH.length && !ModUtils.TRANSLATOR.isUnicode) {
                    StringUtils.MC_CHAR_WIDTH[((CharacterEditorGui)CharacterEditorGui.this).lastScannedChar] = CharacterEditorGui.this.getFontRenderer().a(Character.toString(CharacterEditorGui.this.lastScannedChar));
                } else if (StringUtils.MC_GLYPH_WIDTH[CharacterEditorGui.this.lastScannedChar] != 0) {
                    StringUtils.MC_GLYPH_WIDTH[((CharacterEditorGui)CharacterEditorGui.this).lastScannedChar & 0xFF] = (byte)CharacterEditorGui.this.getFontRenderer().a(Character.toString(CharacterEditorGui.this.lastScannedChar));
                }
            }
        }, new String[0]));
        this.addControl((awx)new ExtendedButtonControl(5, this.i - 30, 100, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]), new Runnable(){

            @Override
            public void run() {
                CraftPresence.GUIS.openScreen(CharacterEditorGui.this.parentScreen);
            }
        }, new String[0]));
        this.saveButton = (ExtendedButtonControl)this.addControl((awx)new ExtendedButtonControl(this.h - 105, this.i - 30, 100, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.save", new Object[0]), new Runnable(){

            @Override
            public void run() {
                Pair charData = StringUtils.getValidInteger(CharacterEditorGui.this.charWidth.b());
                if (((Boolean)charData.getFirst()).booleanValue()) {
                    int characterWidth = (Integer)charData.getSecond();
                    if (CharacterEditorGui.this.lastScannedChar > '\u0000' && CharacterEditorGui.this.lastScannedChar <= StringUtils.MC_CHAR_WIDTH.length && !ModUtils.TRANSLATOR.isUnicode) {
                        StringUtils.MC_CHAR_WIDTH[((CharacterEditorGui)CharacterEditorGui.this).lastScannedChar] = characterWidth;
                    } else if (StringUtils.MC_GLYPH_WIDTH[CharacterEditorGui.this.lastScannedChar] != 0) {
                        StringUtils.MC_GLYPH_WIDTH[((CharacterEditorGui)CharacterEditorGui.this).lastScannedChar & 0xFF] = (byte)characterWidth;
                    }
                }
            }
        }, new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.checkValues();
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.editor.character", new Object[0]);
        String charInputTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.char.input", new Object[0]);
        String charWidthTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.char.width", new Object[0]);
        List notice = StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.character.notice", new Object[0]));
        this.renderNotice(notice, 2.0f, 2.0f);
        this.renderString(mainTitle, (float)this.h / 2.0f - (float)StringUtils.getStringWidth(mainTitle) / 2.0f, 15.0f, 0xFFFFFF);
        this.renderString(charInputTitle, (float)this.h / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
        if (StringUtils.isNullOrEmpty(this.charInput.b())) {
            this.charWidth.a("");
            this.charWidth.e(false);
            this.charWidth.c(this.charWidth.q());
            this.syncSingleButton.setControlEnabled(false);
        }
        if (!this.charInput.b().equals(this.lastScannedString)) {
            this.lastScannedString = this.charInput.b();
            if (!StringUtils.isNullOrEmpty(this.lastScannedString)) {
                this.lastScannedChar = this.lastScannedString.charAt(0);
                this.charWidth.a(Integer.toString(StringUtils.getStringWidth(this.lastScannedString)));
                this.charWidth.e(true);
                this.charWidth.c(this.charWidth.q());
                this.syncSingleButton.setControlEnabled(true);
            } else {
                this.lastScannedChar = '\u0000';
            }
        }
        if (this.charWidth.q()) {
            this.renderString(charWidthTitle, (float)this.h / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(2, 10), 0xFFFFFF);
        }
        this.syncSingleButton.setControlMessage(ModUtils.TRANSLATOR.translate("gui.config.message.button.sync.single", this.charInput.b()));
        this.saveButton.setControlEnabled(this.syncSingleButton.isControlEnabled());
        this.syncSingleButton.setControlVisible(this.syncSingleButton.isControlEnabled());
        this.saveButton.setControlVisible(this.syncSingleButton.isControlVisible());
    }

    private void checkValues() {
        if (!Arrays.equals(this.originalCharArray, StringUtils.MC_CHAR_WIDTH) || !Arrays.equals(this.originalGlyphArray, StringUtils.MC_GLYPH_WIDTH)) {
            ModUtils.writeToCharData("UTF-8");
            this.originalCharArray = (int[])StringUtils.MC_CHAR_WIDTH.clone();
            this.originalGlyphArray = (byte[])StringUtils.MC_GLYPH_WIDTH.clone();
            this.lastScannedString = null;
            this.lastScannedChar = '\u0000';
            this.charInput.a("");
            this.charWidth.a("");
        }
    }
}

