/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import java.util.List;
import net.minecraft.client.Minecraft;

public class ScrollableListControl
extends axt {
    public String currentValue;
    public List itemList;
    public RenderType renderType;
    public boolean visible = true;

    public ScrollableListControl(Minecraft mc, int width, int height, int topIn, int bottomIn, int slotHeightIn, List itemList, String currentValue) {
        this(mc, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue, RenderType.None);
    }

    public ScrollableListControl(Minecraft mc, int width, int height, int topIn, int bottomIn, int slotHeightIn, List itemList, String currentValue, RenderType renderType) {
        super(mc, width, height, topIn, bottomIn, slotHeightIn);
        this.itemList = itemList;
        this.currentValue = currentValue;
        this.renderType = renderType;
    }

    protected int a() {
        return this.itemList.size();
    }

    public void a(int slotIndex, boolean isDoubleClick) {
        this.currentValue = this.getSelectedItem(slotIndex);
    }

    public boolean a(int slotIndex) {
        return this.getSelectedItem(slotIndex).equals(this.currentValue);
    }

    protected void b() {
    }

    protected void a(int slotIndex, int xPos, int yPos, int heightIn, bgd tessellatorIn) {
        int xOffset = xPos;
        String displayName = this.getSelectedItem(slotIndex);
        if (!CraftPresence.CONFIG.stripExtraGuiElements && (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.ServerData && CraftPresence.SERVER.enabled || this.renderType == RenderType.EntityData && CraftPresence.ENTITIES.enabled || this.renderType == RenderType.ItemData && CraftPresence.TILE_ENTITIES.enabled)) {
            String texture = "";
            if (this.renderType == RenderType.DiscordAsset) {
                String assetUrl = DiscordAssetUtils.getAssetUrl(CraftPresence.CONFIG.clientId, displayName, true);
                texture = ImageUtils.getTextureFromUrl(displayName, assetUrl);
            } else if (this.renderType == RenderType.EntityData) {
                if (StringUtils.isValidUuid(displayName)) {
                    displayName = displayName.replaceAll("-", "");
                    texture = ImageUtils.getTextureFromUrl(displayName, String.format(CraftPresence.CONFIG.playerSkinEndpoint, displayName));
                }
            } else if (this.renderType == RenderType.ItemData) {
                String string = texture = CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES.containsKey(displayName) ? (String)CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES.get(displayName) : texture;
            }
            if (!ImageUtils.isTextureNull(texture)) {
                CraftPresence.GUIS.drawTextureRect(0.0, xOffset, (double)yPos + 4.5, 32.0, 32.0, 0.0, texture);
            }
            xOffset += 35;
        }
        this.getFontRenderer().a(displayName, xOffset, yPos + (heightIn / 2 - this.getFontRenderer().a / 2), 0xFFFFFF);
    }

    public String getSelectedItem(int slotIndex) {
        try {
            return (String)this.itemList.get(slotIndex);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public awv getFontRenderer() {
        return GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        return this.getFontRenderer().a;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public static enum RenderType {
        DiscordAsset,
        ServerData,
        EntityData,
        ItemData,
        None;

    }
}

