/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.entity;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TileEntityUtils {
    private final List BLOCK_NAMES = Lists.newArrayList();
    private final List BLOCK_CLASSES = Lists.newArrayList();
    private final List ITEM_NAMES = Lists.newArrayList();
    private final List ITEM_CLASSES = Lists.newArrayList();
    private final List TILE_ENTITY_CLASSES = Lists.newArrayList();
    private final wk EMPTY_ITEM = null;
    private final wm EMPTY_STACK = null;
    public boolean isInUse = false;
    public boolean enabled = false;
    public List TILE_ENTITY_NAMES = Lists.newArrayList();
    public Map TILE_ENTITY_RESOURCES = Maps.newHashMap();
    public List CURRENT_MAIN_HAND_ITEM_TAGS = Lists.newArrayList();
    public List CURRENT_HELMET_TAGS = Lists.newArrayList();
    public List CURRENT_CHEST_TAGS = Lists.newArrayList();
    public List CURRENT_LEGS_TAGS = Lists.newArrayList();
    public List CURRENT_BOOTS_TAGS = Lists.newArrayList();
    private wm CURRENT_MAIN_HAND_ITEM;
    private wm CURRENT_HELMET;
    private wm CURRENT_CHEST;
    private wm CURRENT_LEGS;
    private wm CURRENT_BOOTS;
    private String CURRENT_MAIN_HAND_ITEM_NAME;
    private String CURRENT_HELMET_NAME;
    private String CURRENT_CHEST_NAME;
    private String CURRENT_LEGS_NAME;
    private String CURRENT_BOOTS_NAME;
    private bs CURRENT_MAIN_HAND_ITEM_TAG;
    private bs CURRENT_HELMET_TAG;
    private bs CURRENT_CHEST_TAG;
    private bs CURRENT_LEGS_TAG;
    private bs CURRENT_BOOTS_TAG;
    private boolean allItemsEmpty = false;
    private boolean currentlyCleared = true;

    private void emptyData() {
        this.BLOCK_NAMES.clear();
        this.BLOCK_CLASSES.clear();
        this.ITEM_NAMES.clear();
        this.ITEM_CLASSES.clear();
        this.TILE_ENTITY_NAMES.clear();
        this.TILE_ENTITY_CLASSES.clear();
        this.TILE_ENTITY_RESOURCES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_MAIN_HAND_ITEM = this.EMPTY_STACK;
        this.CURRENT_MAIN_HAND_ITEM_NAME = null;
        this.CURRENT_HELMET = this.EMPTY_STACK;
        this.CURRENT_CHEST = this.EMPTY_STACK;
        this.CURRENT_LEGS = this.EMPTY_STACK;
        this.CURRENT_BOOTS = this.EMPTY_STACK;
        this.CURRENT_HELMET_NAME = null;
        this.CURRENT_CHEST_NAME = null;
        this.CURRENT_LEGS_NAME = null;
        this.CURRENT_BOOTS_NAME = null;
        this.CURRENT_MAIN_HAND_ITEM_TAG = null;
        this.CURRENT_HELMET_TAG = null;
        this.CURRENT_CHEST_TAG = null;
        this.CURRENT_LEGS_TAG = null;
        this.CURRENT_BOOTS_TAG = null;
        this.CURRENT_MAIN_HAND_ITEM_TAGS.clear();
        this.CURRENT_HELMET_TAGS.clear();
        this.CURRENT_CHEST_TAGS.clear();
        this.CURRENT_LEGS_TAGS.clear();
        this.CURRENT_BOOTS_TAGS.clear();
        this.allItemsEmpty = true;
        this.isInUse = false;
        this.currentlyCleared = true;
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enablePerItem : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.TILE_ENTITY_NAMES.isEmpty() || this.TILE_ENTITY_CLASSES.isEmpty());
        if (needsUpdate) {
            this.getEntities();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateEntityData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private boolean isEmpty(wk item) {
        return item == null || this.isEmpty(this.getDefaultInstance(item));
    }

    private boolean isEmpty(apa block) {
        return block == null;
    }

    private wm getDefaultInstance(wk itemIn) {
        return new wm(itemIn);
    }

    private boolean isEmpty(wm itemStack) {
        if (itemStack == null || itemStack.equals(this.EMPTY_STACK)) {
            return true;
        }
        if (itemStack.b() != this.EMPTY_ITEM) {
            if (itemStack.a <= 0) {
                return true;
            }
            return itemStack.k() < Short.MIN_VALUE || itemStack.k() > 65535;
        }
        return true;
    }

    private void updateEntityData() {
        boolean hasBootsChanged;
        wm NEW_CURRENT_MAIN_HAND_ITEM = CraftPresence.player.bG();
        wm NEW_CURRENT_HELMET = CraftPresence.player.bK.b[3];
        wm NEW_CURRENT_CHEST = CraftPresence.player.bK.b[2];
        wm NEW_CURRENT_LEGS = CraftPresence.player.bK.b[1];
        wm NEW_CURRENT_BOOTS = CraftPresence.player.bK.b[0];
        String NEW_CURRENT_MAIN_HAND_ITEM_NAME = !this.isEmpty(NEW_CURRENT_MAIN_HAND_ITEM) ? StringUtils.stripColors(NEW_CURRENT_MAIN_HAND_ITEM.s()) : "";
        String NEW_CURRENT_HELMET_NAME = !this.isEmpty(NEW_CURRENT_HELMET) ? StringUtils.stripColors(NEW_CURRENT_HELMET.s()) : "";
        String NEW_CURRENT_CHEST_NAME = !this.isEmpty(NEW_CURRENT_CHEST) ? StringUtils.stripColors(NEW_CURRENT_CHEST.s()) : "";
        String NEW_CURRENT_LEGS_NAME = !this.isEmpty(NEW_CURRENT_LEGS) ? StringUtils.stripColors(NEW_CURRENT_LEGS.s()) : "";
        String NEW_CURRENT_BOOTS_NAME = !this.isEmpty(NEW_CURRENT_BOOTS) ? StringUtils.stripColors(NEW_CURRENT_BOOTS.s()) : "";
        boolean hasMainHandChanged = !this.isEmpty(NEW_CURRENT_MAIN_HAND_ITEM) && !NEW_CURRENT_MAIN_HAND_ITEM.equals(this.CURRENT_MAIN_HAND_ITEM) || !NEW_CURRENT_MAIN_HAND_ITEM_NAME.equals(this.CURRENT_MAIN_HAND_ITEM_NAME) || this.isEmpty(NEW_CURRENT_MAIN_HAND_ITEM) && !this.isEmpty(this.CURRENT_MAIN_HAND_ITEM);
        boolean hasHelmetChanged = !this.isEmpty(NEW_CURRENT_HELMET) && !NEW_CURRENT_HELMET.equals(this.CURRENT_HELMET) || !NEW_CURRENT_HELMET_NAME.equals(this.CURRENT_HELMET_NAME) || this.isEmpty(NEW_CURRENT_HELMET) && !this.isEmpty(this.CURRENT_HELMET);
        boolean hasChestChanged = !this.isEmpty(NEW_CURRENT_CHEST) && !NEW_CURRENT_CHEST.equals(this.CURRENT_CHEST) || !NEW_CURRENT_CHEST_NAME.equals(this.CURRENT_CHEST_NAME) || this.isEmpty(NEW_CURRENT_CHEST) && !this.isEmpty(this.CURRENT_CHEST);
        boolean hasLegsChanged = !this.isEmpty(NEW_CURRENT_LEGS) && !NEW_CURRENT_LEGS.equals(this.CURRENT_LEGS) || !NEW_CURRENT_LEGS_NAME.equals(this.CURRENT_LEGS_NAME) || this.isEmpty(NEW_CURRENT_LEGS) && !this.isEmpty(this.CURRENT_LEGS);
        boolean bl = hasBootsChanged = !this.isEmpty(NEW_CURRENT_BOOTS) && !NEW_CURRENT_BOOTS.equals(this.CURRENT_BOOTS) || !NEW_CURRENT_BOOTS_NAME.equals(this.CURRENT_BOOTS_NAME) || this.isEmpty(NEW_CURRENT_BOOTS) && !this.isEmpty(this.CURRENT_BOOTS);
        if (hasMainHandChanged) {
            ArrayList NEW_CURRENT_MAIN_HAND_ITEM_TAGS;
            this.CURRENT_MAIN_HAND_ITEM = NEW_CURRENT_MAIN_HAND_ITEM;
            this.CURRENT_MAIN_HAND_ITEM_TAG = !this.isEmpty(this.CURRENT_MAIN_HAND_ITEM) ? this.CURRENT_MAIN_HAND_ITEM.b(new bs()) : null;
            ArrayList arrayList = NEW_CURRENT_MAIN_HAND_ITEM_TAGS = this.CURRENT_MAIN_HAND_ITEM_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_MAIN_HAND_ITEM_TAG.c()) : Lists.newArrayList();
            if (!NEW_CURRENT_MAIN_HAND_ITEM_TAGS.equals(this.CURRENT_MAIN_HAND_ITEM_TAGS)) {
                this.CURRENT_MAIN_HAND_ITEM_TAGS = NEW_CURRENT_MAIN_HAND_ITEM_TAGS;
            }
            this.CURRENT_MAIN_HAND_ITEM_NAME = NEW_CURRENT_MAIN_HAND_ITEM_NAME;
        }
        if (hasHelmetChanged) {
            ArrayList NEW_CURRENT_HELMET_TAGS;
            this.CURRENT_HELMET = NEW_CURRENT_HELMET;
            this.CURRENT_HELMET_TAG = !this.isEmpty(this.CURRENT_HELMET) ? this.CURRENT_HELMET.b(new bs()) : null;
            ArrayList arrayList = NEW_CURRENT_HELMET_TAGS = this.CURRENT_HELMET_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_HELMET_TAG.c()) : Lists.newArrayList();
            if (!NEW_CURRENT_HELMET_TAGS.equals(this.CURRENT_HELMET_TAGS)) {
                this.CURRENT_HELMET_TAGS = NEW_CURRENT_HELMET_TAGS;
            }
            this.CURRENT_HELMET_NAME = NEW_CURRENT_HELMET_NAME;
        }
        if (hasChestChanged) {
            ArrayList NEW_CURRENT_CHEST_TAGS;
            this.CURRENT_CHEST = NEW_CURRENT_CHEST;
            this.CURRENT_CHEST_TAG = !this.isEmpty(this.CURRENT_CHEST) ? this.CURRENT_CHEST.b(new bs()) : null;
            ArrayList arrayList = NEW_CURRENT_CHEST_TAGS = this.CURRENT_CHEST_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_CHEST_TAG.c()) : Lists.newArrayList();
            if (!NEW_CURRENT_CHEST_TAGS.equals(this.CURRENT_CHEST_TAGS)) {
                this.CURRENT_CHEST_TAGS = NEW_CURRENT_CHEST_TAGS;
            }
            this.CURRENT_CHEST_NAME = NEW_CURRENT_CHEST_NAME;
        }
        if (hasLegsChanged) {
            ArrayList NEW_CURRENT_LEGS_TAGS;
            this.CURRENT_LEGS = NEW_CURRENT_LEGS;
            this.CURRENT_LEGS_TAG = !this.isEmpty(this.CURRENT_LEGS) ? this.CURRENT_LEGS.b(new bs()) : null;
            ArrayList arrayList = NEW_CURRENT_LEGS_TAGS = this.CURRENT_LEGS_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_LEGS_TAG.c()) : Lists.newArrayList();
            if (!NEW_CURRENT_LEGS_TAGS.equals(this.CURRENT_LEGS_TAGS)) {
                this.CURRENT_LEGS_TAGS = NEW_CURRENT_LEGS_TAGS;
            }
            this.CURRENT_LEGS_NAME = NEW_CURRENT_LEGS_NAME;
        }
        if (hasBootsChanged) {
            ArrayList NEW_CURRENT_BOOTS_TAGS;
            this.CURRENT_BOOTS = NEW_CURRENT_BOOTS;
            this.CURRENT_BOOTS_TAG = !this.isEmpty(this.CURRENT_BOOTS) ? this.CURRENT_BOOTS.b(new bs()) : null;
            ArrayList arrayList = NEW_CURRENT_BOOTS_TAGS = this.CURRENT_BOOTS_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_BOOTS_TAG.c()) : Lists.newArrayList();
            if (!NEW_CURRENT_BOOTS_TAGS.equals(this.CURRENT_BOOTS_TAGS)) {
                this.CURRENT_BOOTS_TAGS = NEW_CURRENT_BOOTS_TAGS;
            }
            this.CURRENT_BOOTS_NAME = NEW_CURRENT_BOOTS_NAME;
        }
        if (hasMainHandChanged || hasHelmetChanged || hasChestChanged || hasLegsChanged || hasBootsChanged) {
            this.allItemsEmpty = this.isEmpty(this.CURRENT_MAIN_HAND_ITEM) && this.isEmpty(this.CURRENT_HELMET) && this.isEmpty(this.CURRENT_CHEST) && this.isEmpty(this.CURRENT_LEGS) && this.isEmpty(this.CURRENT_BOOTS);
            this.updateEntityPresence();
        }
    }

    public void updateEntityPresence() {
        String defaultItemMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String placeholderItemMessage = CraftPresence.CONFIG.playerItemsPlaceholderMessage;
        String mainItemMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_MAIN_HAND_ITEM_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultItemMessage);
        String helmetMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_HELMET_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_HELMET_NAME);
        String chestMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_CHEST_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_CHEST_NAME);
        String legsMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_LEGS_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_LEGS_NAME);
        String bootsMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_BOOTS_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_BOOTS_NAME);
        ArrayList tileEntityArgs = Lists.newArrayList();
        if (!this.CURRENT_MAIN_HAND_ITEM_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_MAIN_HAND_ITEM_TAGS) {
                mainItemMessage = StringUtils.replaceAnyCase(mainItemMessage, "&" + tagName + "&", this.CURRENT_MAIN_HAND_ITEM_TAG.a(tagName).toString());
            }
        }
        if (!this.CURRENT_HELMET_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_HELMET_TAGS) {
                helmetMessage = StringUtils.replaceAnyCase(helmetMessage, "&" + tagName + "&", this.CURRENT_HELMET_TAG.a(tagName).toString());
            }
        }
        if (!this.CURRENT_CHEST_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_CHEST_TAGS) {
                chestMessage = StringUtils.replaceAnyCase(chestMessage, "&" + tagName + "&", this.CURRENT_CHEST_TAG.a(tagName).toString());
            }
        }
        if (!this.CURRENT_LEGS_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_LEGS_TAGS) {
                legsMessage = StringUtils.replaceAnyCase(legsMessage, "&" + tagName + "&", this.CURRENT_LEGS_TAG.a(tagName).toString());
            }
        }
        if (!this.CURRENT_BOOTS_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_BOOTS_TAGS) {
                bootsMessage = StringUtils.replaceAnyCase(bootsMessage, "&" + tagName + "&", this.CURRENT_BOOTS_TAG.a(tagName).toString());
            }
        }
        tileEntityArgs.add(new Pair("&MAIN&", !StringUtils.isNullOrEmpty(this.CURRENT_MAIN_HAND_ITEM_NAME) ? StringUtils.replaceAnyCase(mainItemMessage, "&item&", this.CURRENT_MAIN_HAND_ITEM_NAME) : ""));
        tileEntityArgs.add(new Pair("&HELMET&", !StringUtils.isNullOrEmpty(this.CURRENT_HELMET_NAME) ? StringUtils.replaceAnyCase(helmetMessage, "&item&", this.CURRENT_HELMET_NAME) : ""));
        tileEntityArgs.add(new Pair("&CHEST&", !StringUtils.isNullOrEmpty(this.CURRENT_CHEST_NAME) ? StringUtils.replaceAnyCase(chestMessage, "&item&", this.CURRENT_CHEST_NAME) : ""));
        tileEntityArgs.add(new Pair("&LEGS&", !StringUtils.isNullOrEmpty(this.CURRENT_LEGS_NAME) ? StringUtils.replaceAnyCase(legsMessage, "&item&", this.CURRENT_LEGS_NAME) : ""));
        tileEntityArgs.add(new Pair("&BOOTS&", !StringUtils.isNullOrEmpty(this.CURRENT_BOOTS_NAME) ? StringUtils.replaceAnyCase(bootsMessage, "&item&", this.CURRENT_BOOTS_NAME) : ""));
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            tileEntityArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String CURRENT_MESSAGE = StringUtils.sequentialReplaceAnyCase(placeholderItemMessage, tileEntityArgs);
        if (!this.allItemsEmpty) {
            CraftPresence.CLIENT.syncArgument("&TILEENTITY&", CURRENT_MESSAGE, false);
        } else if (!this.currentlyCleared) {
            CraftPresence.CLIENT.initArgument("&TILEENTITY&");
        }
    }

    public List getListFromName(String name) {
        return name.equalsIgnoreCase(this.CURRENT_MAIN_HAND_ITEM_NAME) ? this.CURRENT_MAIN_HAND_ITEM_TAGS : (name.equalsIgnoreCase(this.CURRENT_HELMET_NAME) ? this.CURRENT_HELMET_TAGS : (name.equalsIgnoreCase(this.CURRENT_CHEST_NAME) ? this.CURRENT_CHEST_TAGS : (name.equalsIgnoreCase(this.CURRENT_LEGS_NAME) ? this.CURRENT_LEGS_TAGS : (name.equalsIgnoreCase(this.CURRENT_BOOTS_NAME) ? this.CURRENT_BOOTS_TAGS : Lists.newArrayList()))));
    }

    public String generatePlaceholderString(String name, boolean addExtraData, List tags) {
        StringBuilder finalString = new StringBuilder();
        if (!tags.isEmpty()) {
            for (String tagName : tags) {
                String tagValue;
                finalString.append("\n - &").append(tagName).append("&");
                if (!addExtraData || StringUtils.isNullOrEmpty(tagValue = tags.equals(this.CURRENT_MAIN_HAND_ITEM_TAGS) ? this.CURRENT_MAIN_HAND_ITEM_TAG.a(tagName).toString() : (tags.equals(this.CURRENT_HELMET_TAGS) ? this.CURRENT_HELMET_TAG.a(tagName).toString() : (tags.equals(this.CURRENT_CHEST_TAGS) ? this.CURRENT_CHEST_TAG.a(tagName).toString() : (tags.equals(this.CURRENT_LEGS_TAGS) ? this.CURRENT_LEGS_TAG.a(tagName).toString() : (tags.equals(this.CURRENT_BOOTS_TAGS) ? this.CURRENT_BOOTS_TAG.a(tagName).toString() : null)))))) continue;
                finalString.append(" (Value -> ").append(tagValue).append(")");
            }
        }
        return (!StringUtils.isNullOrEmpty(name) ? name : "None") + " " + (!StringUtils.isNullOrEmpty(finalString.toString()) ? finalString.toString() : "\\n - N/A");
    }

    public void getEntities() {
        String initialData;
        for (apa apa2 : apa.r) {
            if (this.isEmpty(apa2)) continue;
            if (!this.BLOCK_NAMES.contains(apa2.A())) {
                this.BLOCK_NAMES.add(apa2.A());
            }
            if (!this.BLOCK_CLASSES.contains(apa2.getClass().getName())) {
                this.BLOCK_CLASSES.add(apa2.getClass().getName());
            }
            if (this.TILE_ENTITY_RESOURCES.containsKey(apa2.A())) continue;
            initialData = "";
            this.TILE_ENTITY_RESOURCES.put(apa2.A(), "textures/blocks/.png");
        }
        for (wk wk2 : wk.f) {
            if (this.isEmpty(wk2)) continue;
            if (!this.ITEM_NAMES.contains(wk2.l(this.getDefaultInstance(wk2)))) {
                this.ITEM_NAMES.add(wk2.l(this.getDefaultInstance(wk2)));
            }
            if (!this.ITEM_CLASSES.contains(wk2.getClass().getName())) {
                this.ITEM_CLASSES.add(wk2.getClass().getName());
            }
            if (this.TILE_ENTITY_RESOURCES.containsKey(wk2.l(this.getDefaultInstance(wk2)))) continue;
            initialData = "";
            this.TILE_ENTITY_RESOURCES.put(wk2.l(this.getDefaultInstance(wk2)), "textures/items/.png");
        }
        for (String string : CraftPresence.CONFIG.itemMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(string) || StringUtils.isNullOrEmpty((part = string.split(CraftPresence.CONFIG.splitCharacter))[0])) continue;
            if (!this.ITEM_NAMES.contains(part[0])) {
                this.ITEM_NAMES.add(part[0]);
            }
            if (this.BLOCK_NAMES.contains(part[0])) continue;
            this.BLOCK_NAMES.add(part[0]);
        }
        this.verifyEntities();
    }

    private void verifyEntities() {
        ArrayList removingBlocks = Lists.newArrayList();
        ArrayList removingItems = Lists.newArrayList();
        for (String itemName : this.ITEM_NAMES) {
            String lowerItemName;
            if (StringUtils.isNullOrEmpty(itemName) || !(lowerItemName = itemName.toLowerCase()).contains("tile.") && !lowerItemName.contains("item.") && !lowerItemName.contains(".") && !lowerItemName.contains(".name")) continue;
            removingItems.add(itemName);
        }
        for (String blockName : this.BLOCK_NAMES) {
            String lowerBlockName;
            if (StringUtils.isNullOrEmpty(blockName) || !(lowerBlockName = blockName.toLowerCase()).contains("tile.") && !lowerBlockName.contains("item.") && !lowerBlockName.contains(".") && !lowerBlockName.contains(".name")) continue;
            removingBlocks.add(blockName);
        }
        this.ITEM_NAMES.removeAll(removingItems);
        this.ITEM_NAMES.removeAll(this.BLOCK_NAMES);
        this.BLOCK_NAMES.removeAll(this.ITEM_NAMES);
        this.BLOCK_NAMES.removeAll(removingBlocks);
        this.TILE_ENTITY_NAMES.addAll(this.BLOCK_NAMES);
        this.TILE_ENTITY_NAMES.addAll(this.ITEM_NAMES);
        this.TILE_ENTITY_CLASSES.addAll(this.BLOCK_CLASSES);
        this.TILE_ENTITY_CLASSES.addAll(this.ITEM_CLASSES);
    }
}

