/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.entity;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class EntityUtils {
    private final List ENTITY_CLASSES = Lists.newArrayList();
    public boolean isInUse = false;
    public boolean enabled = false;
    public String CURRENT_TARGET_NAME;
    public String CURRENT_ATTACKING_NAME;
    public String CURRENT_RIDING_NAME;
    public List ENTITY_NAMES = Lists.newArrayList();
    public List CURRENT_TARGET_TAGS = Lists.newArrayList();
    public List CURRENT_ATTACKING_TAGS = Lists.newArrayList();
    public List CURRENT_RIDING_TAGS = Lists.newArrayList();
    private mp CURRENT_TARGET;
    private mp CURRENT_ATTACKING;
    private mp CURRENT_RIDING;
    private bs CURRENT_TARGET_TAG;
    private bs CURRENT_ATTACKING_TAG;
    private bs CURRENT_RIDING_TAG;
    private boolean allEntitiesEmpty = false;
    private boolean currentlyCleared = true;

    private void emptyData() {
        this.ENTITY_NAMES.clear();
        this.ENTITY_CLASSES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_TARGET = null;
        this.CURRENT_ATTACKING = null;
        this.CURRENT_RIDING = null;
        this.CURRENT_TARGET_NAME = null;
        this.CURRENT_ATTACKING_NAME = null;
        this.CURRENT_RIDING_NAME = null;
        this.CURRENT_TARGET_TAG = null;
        this.CURRENT_ATTACKING_TAG = null;
        this.CURRENT_RIDING_TAG = null;
        this.CURRENT_TARGET_TAGS.clear();
        this.CURRENT_ATTACKING_TAGS.clear();
        this.CURRENT_RIDING_TAGS.clear();
        this.allEntitiesEmpty = true;
        this.isInUse = false;
        this.currentlyCleared = true;
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enablePerEntity : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.ENTITY_NAMES.isEmpty() || this.ENTITY_CLASSES.isEmpty());
        if (needsUpdate) {
            this.getEntities();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateEntityData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private void updateEntityData() {
        boolean hasRidingChanged;
        String NEW_CURRENT_RIDING_NAME;
        String NEW_CURRENT_ATTACKING_NAME;
        String NEW_CURRENT_TARGET_NAME;
        mp NEW_CURRENT_TARGET = CraftPresence.instance.y != null && CraftPresence.instance.y.a == arb.b ? CraftPresence.instance.y.g : null;
        ng NEW_CURRENT_ATTACKING = CraftPresence.player.bN();
        mp NEW_CURRENT_RIDING = CraftPresence.player.o;
        if (NEW_CURRENT_TARGET instanceof sq) {
            sq NEW_CURRENT_PLAYER_TARGET = (sq)NEW_CURRENT_TARGET;
            NEW_CURRENT_TARGET_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_TARGET.am());
        } else {
            String string = NEW_CURRENT_TARGET_NAME = NEW_CURRENT_TARGET != null ? StringUtils.stripColors(NEW_CURRENT_TARGET.am()) : "";
        }
        if (NEW_CURRENT_ATTACKING instanceof sq) {
            sq NEW_CURRENT_PLAYER_ATTACKING = (sq)NEW_CURRENT_ATTACKING;
            NEW_CURRENT_ATTACKING_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_ATTACKING.am());
        } else {
            String string = NEW_CURRENT_ATTACKING_NAME = NEW_CURRENT_ATTACKING != null ? StringUtils.stripColors(NEW_CURRENT_ATTACKING.am()) : "";
        }
        if (NEW_CURRENT_RIDING instanceof sq) {
            sq NEW_CURRENT_PLAYER_RIDING = (sq)NEW_CURRENT_RIDING;
            NEW_CURRENT_RIDING_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_RIDING.am());
        } else {
            NEW_CURRENT_RIDING_NAME = NEW_CURRENT_RIDING != null ? StringUtils.stripColors(NEW_CURRENT_RIDING.am()) : "";
        }
        boolean hasTargetChanged = NEW_CURRENT_TARGET != null && !NEW_CURRENT_TARGET.equals((Object)this.CURRENT_TARGET) || !NEW_CURRENT_TARGET_NAME.equals(this.CURRENT_TARGET_NAME) || NEW_CURRENT_TARGET == null && this.CURRENT_TARGET != null;
        boolean hasAttackingChanged = NEW_CURRENT_ATTACKING != null && !NEW_CURRENT_ATTACKING.equals((Object)this.CURRENT_ATTACKING) || !NEW_CURRENT_ATTACKING_NAME.equals(this.CURRENT_ATTACKING_NAME) || NEW_CURRENT_ATTACKING == null && this.CURRENT_ATTACKING != null;
        boolean bl = hasRidingChanged = NEW_CURRENT_RIDING != null && !NEW_CURRENT_RIDING.equals((Object)this.CURRENT_RIDING) || !NEW_CURRENT_RIDING_NAME.equals(this.CURRENT_RIDING_NAME) || NEW_CURRENT_RIDING == null && this.CURRENT_RIDING != null;
        if (hasTargetChanged) {
            ArrayList NEW_CURRENT_TARGET_TAGS;
            this.CURRENT_TARGET = NEW_CURRENT_TARGET;
            this.CURRENT_TARGET_TAG = this.CURRENT_TARGET != null ? this.CURRENT_TARGET.getEntityData() : null;
            ArrayList arrayList = NEW_CURRENT_TARGET_TAGS = this.CURRENT_TARGET_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_TARGET_TAG.c()) : Lists.newArrayList();
            if (!NEW_CURRENT_TARGET_TAGS.equals(this.CURRENT_TARGET_TAGS)) {
                this.CURRENT_TARGET_TAGS = NEW_CURRENT_TARGET_TAGS;
            }
            this.CURRENT_TARGET_NAME = NEW_CURRENT_TARGET_NAME;
        }
        if (hasAttackingChanged) {
            ArrayList NEW_CURRENT_ATTACKING_TAGS;
            this.CURRENT_ATTACKING = NEW_CURRENT_ATTACKING;
            this.CURRENT_ATTACKING_TAG = this.CURRENT_ATTACKING != null ? this.CURRENT_ATTACKING.getEntityData() : null;
            ArrayList arrayList = NEW_CURRENT_ATTACKING_TAGS = this.CURRENT_ATTACKING_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_ATTACKING_TAG.c()) : Lists.newArrayList();
            if (!NEW_CURRENT_ATTACKING_TAGS.equals(this.CURRENT_ATTACKING_TAGS)) {
                this.CURRENT_ATTACKING_TAGS = NEW_CURRENT_ATTACKING_TAGS;
            }
            this.CURRENT_ATTACKING_NAME = NEW_CURRENT_ATTACKING_NAME;
        }
        if (hasRidingChanged) {
            ArrayList NEW_CURRENT_RIDING_TAGS;
            this.CURRENT_RIDING = NEW_CURRENT_RIDING;
            this.CURRENT_RIDING_TAG = this.CURRENT_RIDING != null ? this.CURRENT_RIDING.getEntityData() : null;
            ArrayList arrayList = NEW_CURRENT_RIDING_TAGS = this.CURRENT_RIDING_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_RIDING_TAG.c()) : Lists.newArrayList();
            if (!NEW_CURRENT_RIDING_TAGS.equals(this.CURRENT_RIDING_TAGS)) {
                this.CURRENT_RIDING_TAGS = NEW_CURRENT_RIDING_TAGS;
            }
            this.CURRENT_RIDING_NAME = NEW_CURRENT_RIDING_NAME;
        }
        if (hasTargetChanged || hasAttackingChanged || hasRidingChanged) {
            this.allEntitiesEmpty = this.CURRENT_TARGET == null && this.CURRENT_ATTACKING == null && this.CURRENT_RIDING == null;
            this.updateEntityPresence();
        }
    }

    public void updateEntityPresence() {
        String defaultEntityTargetMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityTargetMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String defaultEntityAttackingMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityAttackingMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String defaultEntityRidingMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityRidingMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String targetEntityMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityTargetMessages, this.CURRENT_TARGET_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultEntityTargetMessage);
        String attackingEntityMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityAttackingMessages, this.CURRENT_ATTACKING_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultEntityAttackingMessage);
        String ridingEntityMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityRidingMessages, this.CURRENT_RIDING_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultEntityRidingMessage);
        ArrayList entityTargetArgs = Lists.newArrayList();
        ArrayList entityAttackingArgs = Lists.newArrayList();
        ArrayList entityRidingArgs = Lists.newArrayList();
        entityTargetArgs.add(new Pair("&entity&", this.CURRENT_TARGET_NAME));
        entityAttackingArgs.add(new Pair("&entity&", this.CURRENT_ATTACKING_NAME));
        entityRidingArgs.add(new Pair("&entity&", this.CURRENT_RIDING_NAME));
        if (!this.CURRENT_TARGET_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_TARGET_TAGS) {
                entityTargetArgs.add(new Pair("&" + tagName + "&", this.CURRENT_TARGET_TAG.a(tagName).toString()));
            }
        }
        if (!this.CURRENT_ATTACKING_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_ATTACKING_TAGS) {
                entityAttackingArgs.add(new Pair("&" + tagName + "&", this.CURRENT_ATTACKING_TAG.a(tagName).toString()));
            }
        }
        if (!this.CURRENT_RIDING_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_RIDING_TAGS) {
                entityRidingArgs.add(new Pair("&" + tagName + "&", this.CURRENT_RIDING_TAG.a(tagName).toString()));
            }
        }
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            entityTargetArgs.addAll(CraftPresence.CLIENT.generalArgs);
            entityAttackingArgs.addAll(CraftPresence.CLIENT.generalArgs);
            entityRidingArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String CURRENT_TARGET_MESSAGE = StringUtils.sequentialReplaceAnyCase(targetEntityMessage, entityTargetArgs);
        String CURRENT_ATTACKING_MESSAGE = StringUtils.sequentialReplaceAnyCase(attackingEntityMessage, entityAttackingArgs);
        String CURRENT_RIDING_MESSAGE = StringUtils.sequentialReplaceAnyCase(ridingEntityMessage, entityRidingArgs);
        if (!this.allEntitiesEmpty) {
            CraftPresence.CLIENT.syncArgument("&TARGETENTITY&", CURRENT_TARGET_MESSAGE, false);
            CraftPresence.CLIENT.syncArgument("&ATTACKINGENTITY&", CURRENT_ATTACKING_MESSAGE, false);
            CraftPresence.CLIENT.syncArgument("&RIDINGENTITY&", CURRENT_RIDING_MESSAGE, false);
        } else if (!this.currentlyCleared) {
            CraftPresence.CLIENT.initArgument("&TARGETENTITY&", "&ATTACKINGENTITY&", "&RIDINGENTITY&");
        }
    }

    public List getListFromName(String name) {
        return name.equalsIgnoreCase(this.CURRENT_TARGET_NAME) ? this.CURRENT_TARGET_TAGS : (name.equalsIgnoreCase(this.CURRENT_ATTACKING_NAME) ? this.CURRENT_ATTACKING_TAGS : (name.equalsIgnoreCase(this.CURRENT_RIDING_NAME) ? this.CURRENT_RIDING_TAGS : Lists.newArrayList()));
    }

    public String generatePlaceholderString(String name, boolean addExtraData, List tags) {
        StringBuilder finalString = new StringBuilder();
        if (!tags.isEmpty()) {
            for (String tagName : tags) {
                String tagValue;
                finalString.append("\n - &").append(tagName).append("&");
                if (!addExtraData || StringUtils.isNullOrEmpty(tagValue = tags.equals(this.CURRENT_TARGET_TAGS) ? this.CURRENT_TARGET_TAG.a(tagName).toString() : (tags.equals(this.CURRENT_ATTACKING_TAGS) ? this.CURRENT_ATTACKING_TAG.a(tagName).toString() : (tags.equals(this.CURRENT_RIDING_TAGS) ? this.CURRENT_RIDING_TAG.a(tagName).toString() : null)))) continue;
                finalString.append(" (Value -> ").append(tagValue).append(")");
            }
        }
        return (!StringUtils.isNullOrEmpty(name) ? name : "None") + " " + (!StringUtils.isNullOrEmpty(finalString.toString()) ? finalString.toString() : "\\n - N/A");
    }

    public void getEntities() {
        String[] part;
        if (!mv.c.values().isEmpty()) {
            for (Object entityLocationObj : mv.c.values()) {
                String entityName;
                String entityLocation = (String)entityLocationObj;
                if (entityLocation == null) continue;
                String string = entityName = !StringUtils.isNullOrEmpty(entityLocation) ? entityLocation : "generic";
                Class entityClass = (Class)mv.b.get(entityLocation);
                if (entityClass == null) continue;
                if (!this.ENTITY_NAMES.contains(entityName)) {
                    this.ENTITY_NAMES.add(entityName);
                }
                if (this.ENTITY_CLASSES.contains(entityClass.getName())) continue;
                this.ENTITY_CLASSES.add(entityClass.getName());
            }
        }
        if (CraftPresence.SERVER.enabled) {
            for (bdw playerInfo : CraftPresence.SERVER.currentPlayerList) {
                String uuidString = playerInfo.a;
                if (StringUtils.isNullOrEmpty(uuidString) || this.ENTITY_NAMES.contains(uuidString)) continue;
                this.ENTITY_NAMES.add(uuidString);
            }
        }
        for (String entityTargetMessage : CraftPresence.CONFIG.entityTargetMessages) {
            if (StringUtils.isNullOrEmpty(entityTargetMessage) || StringUtils.isNullOrEmpty((part = entityTargetMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.ENTITY_NAMES.contains(part[0])) continue;
            this.ENTITY_NAMES.add(part[0]);
        }
        for (String entityAttackingMessage : CraftPresence.CONFIG.entityAttackingMessages) {
            if (StringUtils.isNullOrEmpty(entityAttackingMessage) || StringUtils.isNullOrEmpty((part = entityAttackingMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.ENTITY_NAMES.contains(part[0])) continue;
            this.ENTITY_NAMES.add(part[0]);
        }
        for (String entityRidingMessage : CraftPresence.CONFIG.entityRidingMessages) {
            if (StringUtils.isNullOrEmpty(entityRidingMessage) || StringUtils.isNullOrEmpty((part = entityRidingMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.ENTITY_NAMES.contains(part[0])) continue;
            this.ENTITY_NAMES.add(part[0]);
        }
        this.verifyEntities();
    }

    private void verifyEntities() {
    }
}

